#include "pexceptions.h"
#include "fitsbntbllinereader.h"
#include "utils.h"
///////////////////////////////////////////////////////////
//    
//    
///////////////////////////////////////////////////////////


#define LONNOM 31 


FITS_BntblLineReader::FITS_BntblLineReader()
{
  InitNull();
}

FITS_BntblLineReader::FITS_BntblLineReader(char inputfile[],int hdunum)
{
  InitNull();

  //  FitsFile* fn=ReadFInit(inputfile,hdunum);
  //  ReadFInit(inputfile,hdunum);
  inFits_  = new FitsInFile (inputfile);
  inFits_->ReadFInit(hdunum);

  //  if (!fn->IsFitsTable())
  if (!inFits_->IsFitsTable())
    {
      throw PException("FITS_BntblLineReader: the fits file seems not to be a bintable nor ASCII table");
    }

  //
  int nbcols, nbentries;
  //  nbcols = fn->NbColsFromFits();
  nbcols = inFits_->NbColsFromFits();
  nbentries = 0;
  int k;
  //  for (k=0; k<nbcols; k++) nbentries=max( nbentries, fn->NentriesFromFits(k) );
  for (k=0; k<nbcols; k++) nbentries=max( nbentries, inFits_->NentriesFromFits(k) );

  //
  // pour mettre les colonnes dans l'ordre double, float, int, char :
  // tableau de correspondance 
  // DfitsCol(j)= numero dans le fichier fits de la  jeme variable double du 
  // xntuple;
  // FfitsCol(j)= numero dans le fichier fits de la  jeme variable float du 
  // xntuple;
  // etc.
  vector<int> DfitsCol;
  vector<int> FfitsCol;
  vector<int> IfitsCol;
  vector<int> SfitsCol;
  for (k=0; k<nbcols;k++)
    {
      //      char ss= fn->ColTypeFromFits(k);
      char ss= inFits_->ColTypeFromFits(k);
      if (ss == 'D') DfitsCol.push_back(k);
      else if (ss == 'E') FfitsCol.push_back(k);
      else if (ss == 'I') IfitsCol.push_back(k);
      else if (ss == 'S') SfitsCol.push_back(k);
      else {
	cout << " FITS_XNTuple: colonne fits " << k << " type= " << ss << endl;
	throw  IOExc("type de champ inconnu");
      }
    }
  vector<string> ColN(nbcols);
  int compt=0;
  for (k=0; k<DfitsCol.size(); k++)
    {
      ColN[compt] = inFits_->ColNameFromFits(DfitsCol[k]);
    }
  for (k=0; k<FfitsCol.size(); k++)
    {
      ColN[compt] =  inFits_->ColNameFromFits(FfitsCol[k]);
    }
  for (k=0; k<IfitsCol.size(); k++)
    {
      ColN[compt] =  inFits_->ColNameFromFits(IfitsCol[k]);
    }
  for (k=0; k<SfitsCol.size(); k++)
    {
      ColN[compt] = inFits_->ColNameFromFits(SfitsCol[k]);
    }

  ligne_.setFormat(DfitsCol.size(), FfitsCol.size(), IfitsCol.size(), SfitsCol.size(), ColN);
}


FITS_BntblLineReader::~FITS_BntblLineReader()
{
  if (inFits_ != NULL) delete inFits_;
}

BnTblLine& FITS_BntblLineReader::ReadNextLine()
{
  inFits_->GetBinTabLine(nextLineToBeRead_++, ligne_);
  return ligne_;
}


void  FITS_BntblLineReader::ReadFromFits(FitsInFile&)
{   
}

void FITS_BntblLineReader::WriteToFits(FitsOutFile&)
{
}
