#ifndef HEALPixUtils_SEEN
#define HEALPixUtils_SEEN
#include "machdefs.h"
#include "ndatablock.h"

// utilitaires de pixelisation HEALPix


namespace SOPHYA {

//////////////////////////////////////////////////////////////////////////
//
// ------------- Classe PIXELS_XY -----------------------
//
class PIXELS_XY
{

public :

static PIXELS_XY& instance();

NDataBlock<int_4> pix2x_;
NDataBlock<int_4> pix2y_;
NDataBlock<int_4> x2pix_;
NDataBlock<int_4> y2pix_;

private :

PIXELS_XY();
void mk_pix2xy();
void mk_xy2pix();
};


int_4  nest2ring(int_4 nside,int_4 ipnest) ;
int_4  ring2nest(int_4 nside,int_4 ipring) ;

int_4  ang2pix_ring(int_4 nside,double theta,double phi) ;
int_4  ang2pix_nest(int_4 nside,double theta,double phi) ;
void pix2ang_ring(int_4 nside,int_4 ipix,double& theta,double& phi) ;
void pix2ang_nest(int_4 nside,int_4 ipix,double& theta,double& phi) ;




} // Fin du namespace

#endif
