// Module PI : Peida Interactive PIDrawer3D PIDraw3DWdg
// Drawer et DrawWidget 3D       R. Ansari 06/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIDRW3D_H_SEEN
#define PIDRW3D_H_SEEN

#include "pisysdep.h"
#include "pidrawer.h"
#include "pigraph3d.h"

#include PIBWDG_H

#include <list>

// Traceur (Drawer) 3D 
class PIDrawer3D : public PIDrawer
{
public :
			PIDrawer3D();
  virtual		~PIDrawer3D();

  virtual void		Set3DView_Obs(float xo, float yo, float zo, float teta, float phi, float psi, 
                                      float dax, float day, float co, float dco=0.2);
  virtual void       	Set3DView(float xc, float yc, float zc, float xo, float yo, float zo, 
                                  float dax, float day, float dco=0.2, float psi=0.);
  bool           	Get3DView(float& xc, float& yc, float& zc, float& xo, float& yo, float& zo,
                                  float& teta, float& phi, float& psi, float& dax, float& day, float& co, float& dco);
  
  virtual PIGraphicUC*	SetDrwWdg(PIBaseWdgGen* drw, int x0, int y0, int dx, int dy, PIGraphicGen* g);

protected :
  float xO, yO, zO;  // Position observateur = camera
  float xC, yC, zC;  // Position centre du champ
  float tO,fO,pO;    // Orientation observateur (Teta, Phi, Psi, Angles d Euler)
  float daxO, dayO;  // Demi-ouverture de la camera suivant les deux axes de projection (xp/zp, yp/zp) 
  float lCO, dlCO;   // Distance Camera-Centre du champ et profondeur de champ 
  bool v3D_obs;      // Si defini par Set3DView_Obs 
};



class PIDraw3DWdg : public PIBaseWdg {
public:
  enum {ClassId = 5500};

			PIDraw3DWdg(PIContainerGen *par, char *nom,
                                    int sx=100, int sy=100, int px=0, int py=0);
  virtual		~PIDraw3DWdg();
  virtual long		kind() {return ClassId; }

  virtual void		Set3DView_Obs(float xo, float yo, float zo, float teta, float phi, float psi, 
                                      float dax, float day, float co, float dco=0.2);
  virtual void       	Set3DView(float xc, float yc, float zc, float xo, float yo, float zo, 
                                  float dax, float day, float dco=0.2, float psi=0.);
  bool           	Get3DView(float& xc, float& yc, float& zc, float& xo, float& yo, float& zo, 
                                  float& teta, float& phi, float& psi, float& dax, float& day, float& co, float& dco);

  virtual void          Update3DView();   // Vue 3-D a partir de Drawer No 1

  int                   AddDrawer3D(PIDrawer3D*, bool ad=false);   // Ajoute un Drawer 

//  Pour tenir trace des Drawers-3D qui sont detruits 
  virtual void      	RemoveDrawer(int id);       
  virtual void       	DeleteDrawers();            

  virtual void		But1Press(int x, int y);

  virtual void		But2Press(int x, int y);
  virtual void		But2Release(int x, int y);
  virtual void		Ptr2Move(int x, int y);

  virtual void		But3Press(int x, int y);
  virtual void		But3Release(int x, int y);
  virtual void		Ptr3Move(int x, int y);


protected :
  virtual void		SetDrawers3DView();
  virtual void		DrawXYZAxes();

  bool vfixed;       // SetView fait ou pas
  list<int> m3DrIl;  // Liste des Id drawers 3D 
  PIGraphic3D* mGr3d;   // PIGraphic3D courante
  int lPx, lPy;         // dernier position pointeur
  PIColors lCol;        // Couleur
  float cTeta, cPhi, cUlen;    // Pour garder valeurs avant rotation, Unite de longeur 
  float clCO, cDax, cDay;      // Pour garder les valeurs avant Zoom In/Out
};

#endif
