#include "pidrawer.h"
#include "psfile.h"

PIDrawer::PIDrawer()
{
  mBWdg = NULL; 
  mGrUC = NULL;
  xW0 = yW0 = 0; xWd = yWd = 100; 
  aXdir = false;  // Vrai si Axe X de Droite vers Gauche 
  aYdir = false;  // Vrai si Axe Y de Haut vers Bas
  SetLimits(-1, 1, -1, 1, kAxeDirLtoR, kAxeDirDownUp);
  limitsFixed = 0;
  SetAxesFlags();   // Pas de trace d'axes par defaut 
  mDndfg = false;  // Pour controle de l'appel de Detach() si delete

  mFCol = mBCol = PI_NotDefColor;
  mLAtt = PI_NotDefLineAtt;
  mFSz = PI_NotDefFontSize;
  mFAtt = PI_NotDefFontAtt;
  mMSz = -1;
  mMrk = PI_NotDefMarker;
  mCmapid = CMAP_OTHER;
}

PIDrawer::~PIDrawer()
{
  list<DrwBWId>::iterator it;
  mDndfg = true;
  for(it = mBWdgList.begin(); it != mBWdgList.end(); it++)
         (*it).wdg->RemoveDrawer((*it).id);
  if (mGrUC)  delete mGrUC;
}


void
PIDrawer::SetLimits(float xmin, float xmax, float ymin, float ymax,
                    int axrl, int ayud)
{
  if (axrl == kAxeDirAuto) {
    float ff;
    if (xmax < xmin)  { axrl = kAxeDirRtoL;   ff=xmin;  xmin=xmax;  xmax=ff; }
    else  axrl = kAxeDirLtoR;
  }
  if (ayud == kAxeDirAuto) {
    float ff;
    if (ymax < ymin)  { ayud = kAxeDirUpDown;   ff=ymin;  ymin=ymax;  ymax=ff; }
    else  ayud = kAxeDirDownUp;
  }
  if (xmax <= xmin || ymax <= ymin)
    return; // $CHECK$ exception ?
  if (axrl == kAxeDirLtoR)  aXdir = false;
  else if (axrl == kAxeDirRtoL)  aXdir = true;
  if (ayud == kAxeDirDownUp)  aYdir = false;
  else if (ayud == kAxeDirUpDown)  aYdir = true;
  xMin = xmin;
  xMax = xmax;
  yMin = ymin;
  yMax = ymax;
  aXFlg = axrl;  aYFlg = ayud;
  CalcTicks();
  limitsFixed = 1;
}


void
PIDrawer::UpdateLimits()
{
// Ne fait rien !
  return;
}

void
PIDrawer::Refresh()
{
  list<DrwBWId>::iterator it;
  for(it = mBWdgList.begin(); it != mBWdgList.end(); it++)
         (*it).wdg->CallDrawer((*it).id);

}

void 
PIDrawer::SetColAtt(PIColors fg, PIColors bg)
{
  mFCol = fg;
  mBCol = bg;
}

void 
PIDrawer::SetLineAtt(PILineAtt lat)
{
  mLAtt = lat;
}

void 
PIDrawer::SetFontAtt(PIFontSize fsz, PIFontAtt fat)
{
  mFSz = fsz;
  mFAtt = fat;
}

void 
PIDrawer::SetMarkerAtt(int sz, PIMarker mrk)
{
  mMSz = sz;
  mMrk = mrk;
}

void 
PIDrawer::SetColMapId(CMapId cid)
{
  mCmapid = cid;
}

void 
PIDrawer::SelGraAtt(PIGraphicUC* g)
{
  if (mFCol != PI_NotDefColor)    g->SelForeground(mFCol);
  if (mBCol != PI_NotDefColor)    g->SelBackground(mBCol);
  if (mLAtt != PI_NotDefLineAtt)  g->SelLine(mLAtt);
  if ( (mFSz != PI_NotDefFontSize) || (mFAtt != PI_NotDefFontAtt) )
                                  g->SelFont(mFSz, mFAtt);
  if ( (mMrk != PI_NotDefMarker) || (mMSz >= 0) )
                                  g->SelMarker(mMSz, mMrk);
}


void
PIDrawer::Attach(PIBaseWdgGen* wdg, int id)
{
  if (!wdg) return;
  DrwBWId bwi;
  bwi.id = id;  bwi.wdg = wdg;
  mBWdgList.push_back(bwi);
  return;
}

void
PIDrawer::Detach(PIBaseWdgGen* wdg, int id)
{
  if (mDndfg) return;
  if (!wdg) return;
  list<DrwBWId>::iterator it;
  for(it = mBWdgList.begin(); it != mBWdgList.end(); it++)
     if ( ((*it).id == id) && ((*it).wdg == wdg) ) { mBWdgList.erase(it);  break; }
  return;
}


PIGraphicUC*
PIDrawer::SetDrwWdg(PIBaseWdgGen* drw, int x0, int y0, int dx, int dy, PIGraphicGen* g)
{
  mBWdg = drw;
  xW0 = x0;   yW0 = y0;
  xWd = dx;   yWd = dy;
  if (mGrUC)  delete mGrUC;
  mGrUC = new PIGraphicUC(g, x0, y0, dx, dy);
  mGrUC->SetUCS(xMin, xMax, yMin, yMax, aXFlg, aYFlg);
  return(mGrUC);
}


void
PIDrawer::CalcTicks()
{
	float xExt = xMax-xMin;
	int lx = (int) ceil(log10(xExt)-0.1);
	xExt = (float)pow(10.0,lx);
	xMajTickStep = xExt/10;
	xMinTickStep = xMajTickStep/10;
    xFirstMajTick = int(xMin / xMajTickStep) * xMajTickStep;
    if (xFirstMajTick < xMin) xFirstMajTick += xMajTickStep;
    xFirstMinTick = int(xMin / xMinTickStep) * xMinTickStep;
    if (xFirstMinTick < xMin) xFirstMinTick += xMinTickStep;
    
    
	float yExt = yMax-yMin;
	int ly = (int) ceil(log10(yExt)-0.1);
	yExt = (float)pow(10.0,ly);
	yMajTickStep = yExt/10;
	yMinTickStep = yMajTickStep/10;
    yFirstMajTick = int(yMin / yMajTickStep) * yMajTickStep;
    if (yFirstMajTick < yMin) yFirstMajTick += yMajTickStep;
    yFirstMinTick = int(yMin / yMinTickStep) * yMinTickStep;
    if (yFirstMinTick < yMin) yFirstMinTick += yMinTickStep;
    
    yMajTickLen = (xMax-xMin)/100;
    yMinTickLen = (xMax-xMin)/250;
    xMajTickLen = (yMax-yMin)/100;
    xMinTickLen = (yMax-yMin)/250;

}



void
PIDrawer::SetAxesFlags(unsigned int flags)
{
  axesFlags = flags;
  if (axesFlags & (kIntTicks | kExtTicks | kMajTicks | kMinTicks))
    axesFlags |= kTicks;
  if ((axesFlags & (kTicks | kIntTicks | kExtTicks)) == kTicks)
    axesFlags |= kIntTicks | kExtTicks;
  if ((axesFlags & (kTicks | kMajTicks | kMinTicks)) == kTicks)
    axesFlags |= kMajTicks;
}


void
PIDrawer::DrawAxes(PIGraphicUC* g)
{
  g->NoClip();
  unsigned int flags = axesFlags;
  if (flags & kStdAxes) {
  
    // Les axes
    
    g->DrawLine(xMin, 0, xMax, 0);
    g->DrawLine(0, yMin, 0, yMax);
  
    // Les ticks majeurs
  
    if (flags & kMajTicks) {
        DrawHTicks(g, 0, xMajTickLen, xMajTickLen, xFirstMajTick, xMajTickStep);
        DrawVTicks(g, 0, yMajTickLen, yMajTickLen, yFirstMajTick, yMajTickStep);
    }
    
    // Les ticks mineurs
  
    if (flags & kMinTicks) {
        DrawHTicks(g, 0, xMinTickLen, xMinTickLen, xFirstMinTick, xMinTickStep);
        DrawVTicks(g, 0, yMinTickLen, yMinTickLen, yFirstMinTick, yMinTickStep);
    }
    
    // Les labels
    
    if (flags & kLabels) {
      if (!aYdir)
        DrawHLabels(g, -xMajTickLen*8, xFirstMajTick, xMajTickStep,0);
      else 
        DrawHLabels(g, xMajTickLen*8, xFirstMajTick, xMajTickStep,0);
      if (!aXdir)
        DrawVLabels(g, -yMajTickLen*2, yFirstMajTick, yMajTickStep,1);
      else 
        DrawVLabels(g, yMajTickLen*2, yFirstMajTick, yMajTickStep,1);
    }
    
  }
  
  if (flags & kBoxAxes) {
  
    // La boite
    
    g->DrawLine(xMin, yMin, xMax, yMin);
    g->DrawLine(xMax, yMin, xMax, yMax);
    g->DrawLine(xMax, yMax, xMin, yMax);
    g->DrawLine(xMin, yMax, xMin, yMin);

    // Longueur des ticks
    
    float extXMajTickLen = flags&kExtTicks ? xMajTickLen : 0;
    float intXMajTickLen = flags&kIntTicks ? xMajTickLen : 0;
    float extXMinTickLen = flags&kExtTicks ? xMinTickLen : 0;
    float intXMinTickLen = flags&kIntTicks ? xMinTickLen : 0;
    float extYMajTickLen = flags&kExtTicks ? yMajTickLen : 0;
    float intYMajTickLen = flags&kIntTicks ? yMajTickLen : 0;
    float extYMinTickLen = flags&kExtTicks ? yMinTickLen : 0;
    float intYMinTickLen = flags&kIntTicks ? yMinTickLen : 0;

    // Les ticks majeurs
  
    if (flags & kMajTicks) {
        DrawHTicks(g, yMin, intXMajTickLen, extXMajTickLen, xFirstMajTick, xMajTickStep);
        DrawHTicks(g, yMax, extXMajTickLen, intXMajTickLen, xFirstMajTick, xMajTickStep);
        DrawVTicks(g, xMin, extYMajTickLen, intYMajTickLen, yFirstMajTick, yMajTickStep);
        DrawVTicks(g, xMax, intYMajTickLen, extYMajTickLen, yFirstMajTick, yMajTickStep);
    }
    
    // Les ticks mineurs
  
    if (flags & kMinTicks) {
        DrawHTicks(g, yMin, intXMinTickLen, extXMinTickLen, xFirstMinTick, xMinTickStep);
        DrawHTicks(g, yMax, extXMinTickLen, intXMinTickLen, xFirstMinTick, xMinTickStep);
        DrawVTicks(g, xMin, extYMinTickLen, intYMinTickLen, yFirstMinTick, yMinTickStep);
        DrawVTicks(g, xMax, intYMinTickLen, extYMinTickLen, yFirstMinTick, yMinTickStep);
    }


    // Les labels
    
    if (flags & kLabels) {
      if (!aYdir) {
        DrawHLabels(g, yMin-xMajTickLen*8, xFirstMajTick, xMajTickStep,0);
        DrawHLabels(g, yMax+xMajTickLen*2, xFirstMajTick, xMajTickStep,0);
      }
      else {
        DrawHLabels(g, yMin-xMajTickLen*2, xFirstMajTick, xMajTickStep,0);
        DrawHLabels(g, yMax+xMajTickLen*8, xFirstMajTick, xMajTickStep,0);
      }
      if (!aXdir) {
        DrawVLabels(g, xMin-yMajTickLen*2, yFirstMajTick, yMajTickStep,1);
        DrawVLabels(g, xMax+yMajTickLen*2, yFirstMajTick, yMajTickStep,-1);
      }
      else {
        DrawVLabels(g, xMin-yMajTickLen*2, yFirstMajTick, yMajTickStep,-1);
        DrawVLabels(g, xMax+yMajTickLen*2, yFirstMajTick, yMajTickStep,1);
      }
    }
  }
  g->Clip();
}

  

void
PIDrawer::Draw(PIGraphicUC* g, float /*xmin*/, float /*ymin*/, float /*xmax*/, float /*ymax*/)
{
}


void
PIDrawer::DrawHTicks(PIGraphicUC* g, float y, float tickUp, float tickDown, float xBeg, float xStep)
{
  for (float x=xBeg; x<=xMax; x += xStep)
    g->DrawLine(x, y-tickDown, x, y+tickUp);
}

void
PIDrawer::DrawVTicks(PIGraphicUC* g, float x, float tickLeft, float tickRight, float yBeg, float yStep)
{
  for (float y=yBeg; y<=yMax; y += yStep)
    g->DrawLine(x-tickLeft, y, x+tickRight, y);
}

void
PIDrawer::DrawHLabels(PIGraphicUC* g, float y, float xBeg, float xStep, int just)
{
  float xOffset = 0;
  int kk;
  g->SelFontSz(xMajTickLen*4.);
  for (float x=xBeg; x<=xMax; x += xStep) {
      char label[20]; sprintf(label, "%-6g", x);
      for(kk=0; kk<20; kk++)
        if (label[kk] == ' ')   { label[kk] = '\0' ; break; }
      float largeur = g->CalcStringWidth(label);
      if (just == 1)
        xOffset = -largeur;
      else if (just == 0)
        xOffset = -largeur/2;
      else
        xOffset = 0;
      if (aXdir)  xOffset = -xOffset;
      g->DrawString(x+xOffset, y, label);
  }
}

void
PIDrawer::DrawVLabels(PIGraphicUC* g, float x, float yBeg, float yStep, int just)
{
  float xOffset = 0;
  g->SelFontSz(xMajTickLen*4.);
  for (float y=yBeg; y<=yMax; y += yStep) {
      char label[20]; sprintf(label, "%-6g", y);
      float largeur = g->CalcStringWidth(label);
      if (just == 1)
        xOffset = -largeur;
      else if (just == 0)
        xOffset = -largeur/2;
      else
        xOffset = 0;
      if (aXdir)  xOffset = -xOffset;
      g->DrawString(x+xOffset, y, label);
  }
}


/*  --------------------------------------------------------------  */
/*  ------------------- Classe PIElDrawer ------------------------  */
/*  --------------------------------------------------------------  */

/* --Methode-- */
PIElDrawer::PIElDrawer()
{
mEn = 0;
}

/* --Methode-- */
PIElDrawer::~PIElDrawer()
{
}

/* --Methode-- */
void  PIElDrawer::Draw(PIGraphicUC* g, float /*xmin*/, float /*ymin*/, float /*xmax*/, float /*ymax*/)
{
DrawAxes(g);   // Trace des axes 

SelGraAtt(g);   // DrawAxes change certains attributs graphiques
DrwElList::iterator it;
for (it = mElist.begin(); it != mElist.end(); it++)
  {
  switch ( (*it).etyp )
    {
    case PIDEL_Line :
      g->DrawLine((*it).ex, (*it).ey, (*it).edx, (*it).edy ); 
      break;
    case PIDEL_Text :
      g->DrawString((*it).ex, (*it).ey, (char*) ((*it).es.c_str()) ); 
      break;
    case PIDEL_Rect :
      g->DrawBox((*it).ex, (*it).ey, (*it).edx, (*it).edy ); 
      break;
    case PIDEL_FRect :
      g->DrawFBox((*it).ex, (*it).ey, (*it).edx, (*it).edy ); 
      break;
    case PIDEL_Circ :
      g->DrawCircle((*it).ex, (*it).ey, (*it).edx ); 
      break;
    case PIDEL_FCirc :
      g->DrawFCircle((*it).ex, (*it).ey, (*it).edx ); 
      break;
    default :
      break;
    }
  }
}


/* --Methode-- */
int PIElDrawer::ElAdd(int typ, PIGrCoord x, PIGrCoord  y, PIGrCoord dx, PIGrCoord dy, char* s)
{
DrwEl dre;
mEn++;
dre.eid = mEn;  dre.etyp = typ;
dre.ex = x;   dre.ey = y;
dre.edx = dx;  dre.edy = dy;
if (s)  dre.es = s;
mElist.push_back(dre);
return(mEn);
}

/* --Methode-- */
void  PIElDrawer::ElDel(int id)
{
DrwElList::iterator it;
for (it = mElist.begin(); it != mElist.end(); it++)
  if ( (*it).eid == id) { mElist.erase(it);   break; }
return;
}

/* --Methode-- */
void  PIElDrawer::ElDelAll()
{
mElist.erase(mElist.begin(), mElist.end());
return;
}

