// This may look like C code, but it is really -*- C++ -*-
// Adaptateur d objets (pour NamedObjMgr) pour Histos/NTuple
//                                    Reza 05/99
//  LAL-IN2P3/CNRS               CEA-DAPNIA     
 
#ifndef NOMIMAGADAPTER_H_SEEN
#define NOMIMAGADAPTER_H_SEEN

#include "nomgadapter.h"
#include "cimage.h"
#include "generalfit.h"



//---------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet  Image<T> 
//---------------------------------------------------------------

template <class T>
class NOMAdapter_Image : public NObjMgrAdapter {
public:
				NOMAdapter_Image(Image<T> * o = NULL);
  virtual			~NOMAdapter_Image();

  virtual NObjMgrAdapter*	Clone(AnyDataObj* o);
  virtual AnyDataObj*		CloneDataObj();

  //  virtual void			ReadFits(string const & flnm);
  virtual void			SaveFits(string const & flnm);
  virtual void			SavePPF(POutPersist& s, string const & nom);

  virtual void			Print(ostream& os);
  virtual P2DArrayAdapter*	Get2DArray(string& dopt);
  virtual NTupleInterface*	GetNTupleInterface(bool& adel);

  virtual GeneralFitData* GetGeneralFitData(bool& adel
          ,GeneralFitData::FitErrType errtype=GeneralFitData::DefaultError
          ,double errscale=1.,double errmin=1.
          ,int i1=0,int i2=-1,int j1=0,int j2=-1);
  virtual AnyDataObj* FitResidusObj(GeneralFit& mfit);
  virtual AnyDataObj* FitFunctionObj(GeneralFit& mfit);

protected:
  Image<T> * mImg;
};

// Class Interface NTuple pour Image

template <class T>
class NTupInt_Image : public NTupleInterface {
public:
			NTupInt_Image(Image<T> * m);
  virtual		~NTupInt_Image();
  virtual uint_4        NbLines() const ;
  virtual uint_4        NbColumns() const ;
  virtual r_8 *         GetLineD(int n) const ;
  virtual string        VarList_C(const char* nomx=NULL) const ;
protected:
  Image<T> * mImg;
  mutable r_8 mRet[3];
};


#endif
