// This may look like C code, but it is really -*- C++ -*-
// Classe de gestion d objets nommes pour piapp
// Reza      Aout 97 , Juillet,Aout 98
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef NOBJMGR_H_SEEN
#define NOBJMGR_H_SEEN

#include "machdefs.h"

#include <fstream.h>
#include <string>
#include <vector>

#include "anydataobj.h"
#include "ppersist.h"
#include "dvlist.h"
#include "dlftypes.h"


class NObjMgrAdapter;
class PIStdImgApp;
class Services2NObjMgr;

class NamedObjMgr {
public:
// Constructeur et destructeur
			NamedObjMgr();
  virtual		~NamedObjMgr();

  virtual void 		SetImgApp(PIStdImgApp* app);
  virtual void 		SetVerbose(bool fg=false);

// Gestion des variables globales (dans un DVList) 
  virtual bool          SetVar(string const & key, string const & val);
  virtual bool          HasVar(string const & key);
  virtual bool          DeleteVar(string const & key);
  virtual string        GetVar(string const & key);
  virtual DVList&       GetVarList();

// Gestion des repertoires (Repertoire d'objets en memoire)
  virtual bool		CreateDir(string & dirname);
  virtual bool		DeleteDir(string & dirname);
  virtual void		LockDir(string & dirname); 
  virtual void		UnlockDir(string & dirname);
  virtual void		SetKeepOldDirAtt(string & dirname, bool keepold=false); 
  virtual bool		SetCurrentDir(string & dirname);
  virtual void		GetCurrentDir(string & dirname);
  virtual void		ListDirs(string & patt);
  virtual void		GetDirList(string & patt, vector<string>& );
  virtual void		CleanDir(string & dirname);

//  Pour ajouter, supprimer et acceder aux objets 
  virtual bool		AddObj(AnyDataObj* obj, string & nom, bool crd=false);
  virtual bool		RenameObj(string & nom, string& nomnew);
  virtual bool          DelObj(string & nom, bool fgd=true);
  virtual void		DelObjects(string & patt, bool fgd=true); 
  virtual bool          DelObj_Id(int oid);
  virtual AnyDataObj*	GetObj(string & nom);
// Acces a l'adaptateur
  virtual NObjMgrAdapter*	GetObjAdapter(string & nom);
// Liste des objets
  virtual void          ListObjs(string & patt);  		
  virtual void          GetObjList(string & patt, vector<string>& );  		
// Methode CopyObj() a virer probablement (Reza 30/8/200 obsolete ?) 
  virtual bool          CopyObj(string & nom, string& nomcp);

//  Lecture et sauvegarde des objets sur fichier
  virtual void		ReadObj(PInPersist& s, int num=-1);
  virtual void		ReadObj(string const & nomppf, string & nobj);
  virtual void		ReadAll(string const & nomppf);
  virtual void		ReadFits(string const & flnm, string & nobj);
  virtual void          SaveObj(string & nom, POutPersist& s, bool keeppath=false);
  virtual void          SaveObjects(string & patt, string const& nomppf);
  virtual void          SaveAll(string const& nomppf);
  virtual void          SaveFits(string & nom, string const & flnm);

// Info sur les objets 
  virtual void          PrintObj(string & nom);

//  Affichage des objets 
  virtual void          DisplayObj(string & nom, string dopt="");
  virtual void          DisplayImage(string & nom, string dopt="");
  virtual void          DisplaySurf3D(string & nom, string dopt="");
  virtual void          DisplayNT(string & nom, string& nmx, string& nmy, string& nmz,  
                                  string& erx, string& ery, string& erz, string& wt,
                                  string& label, string dopt="", bool fg3d=false);
  virtual void          DisplayGFD(string & nom, string& numvarx, string& numvary, 
                                   string& err, string dopt="");

  virtual void		SetGraphicAttributes(string gratt="");
  virtual void		SetGraphicWinZone(int nzx, int nzy, bool fcr=false);


// Acces au PIApplication et a la classe de service 
  virtual PIStdImgApp*		GetImgApp();
  virtual Services2NObjMgr* 	GetServiceObj();

  virtual void		AddWRsId(string & nom, int wrsid);
// Pour utilisation par ObjMgrWind
  virtual void		UpdateObjMgrWindow(int did);

// Pour completer le nom de l'objet avec le nom du repertoire
  static void RemoveSpacesFromName(string & nom);
  static bool CheckDirName(string & nom);
  static int  ParseObjectName(string & nom, string & nomrep, string & nomobj);
};


#endif
