#ifndef PIPODRW_H_SEEN
#define PIPODRW_H_SEEN

#include "pidrawer.h"
#include "parradapter.h"
#include "cvector.h"

class PIFuncDrawer : public PIDrawer {
public:
  typedef double(*FUNC)(double);
                     PIFuncDrawer(FUNC);
  virtual           ~PIFuncDrawer();
  
  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);
protected:
  FUNC               mFunc;
};

class GeneralFunction;
class PIGFFDrawer : public PIDrawer {
public:
                     PIGFFDrawer(GeneralFunction*);
  virtual           ~PIGFFDrawer();
  
  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);
  virtual void       SetParms(double const*);
protected:
  GeneralFunction*    mFunc;
  int                 mNParms;
  double*             mParms;
};


// Adaptateur de vecteurs Peida++ a P1DArrayAdapter
class POVectorAdapter : public P1DArrayAdapter {
public :
                  POVectorAdapter(Vector* v, bool ad=false);
  virtual         ~POVectorAdapter();
  virtual float   Value(int i);

protected:
  bool aDel;
  Vector* mVec;
};

#endif
