// This may look like C code, but it is really -*- C++ -*-
//  Adaptateur pour objets gere par   NamedObjMgr (piapp)
//                                    Reza 05/99
//  LAL-IN2P3/CNRS               CEA-DAPNIA      

#ifndef NOMGADAPTER_H_SEEN
#define NOMGADAPTER_H_SEEN

#include "machdefs.h"
#include "ppersist.h"
#include "anydataobj.h"
#include "pidrawer.h"
#include "parradapter.h"
#include "ntupintf.h"
#include "generalfit.h"


// Classe d'adaptateur d'objets de donnees pour la gestion d'objets
// nommes (NamedObjMgr) de piapp

class NObjMgrAdapter {
public:
				NObjMgrAdapter(AnyDataObj* o);
  virtual			~NObjMgrAdapter();

  virtual NObjMgrAdapter*	Clone(AnyDataObj* o);

  // Returns the actual data-object
  virtual AnyDataObj*		GetDataObj();

  // Returns the actual data-object type (class name)
  virtual string		GetDataObjType();

  // Returns a new data-object, cloning the original object 
  virtual AnyDataObj*		CloneDataObj();

  // Copies data from object o 
  virtual void   		CopyFrom(AnyDataObj* o);

// Returns a string representation of the object
  virtual string	        ToString();
// Fills the object from a string
  virtual void	                FillFromString();

  virtual void			ReadFits(string const & flnm);
  virtual void			SaveFits(string const & flnm);
  virtual void			SavePPF(POutPersist& s, string const & nom);

  virtual void			Print(ostream& os);
  virtual PIDrawer*		GetDrawer(string& dopt);
  virtual P2DArrayAdapter*	Get2DArray(string& dopt);

// NTupleInterface* nti = GetNTupleInterface(adel)
// Retourne un objet de type NTupleInterface (nti), ainsi que adel
// si adel == true, le programme appelant doit faire delete de nti 
  virtual NTupleInterface*	GetNTupleInterface(bool& adel);

// Methode pour l'interface GeneralFit.
// Si adel==true:
// le programme appelant doit faire delete du GeneralFitData retourne
  virtual GeneralFitData* GetGeneralFitData(bool& adel
          ,GeneralFitData::FitErrType errtype=GeneralFitData::DefaultError
          ,double errscale=1.,double errmin=0.
          ,int i1=0,int i2=-1,int j1=0,int j2=-1);
  virtual AnyDataObj* FitResidusObj(GeneralFit& mfit);
  virtual AnyDataObj* FitFunctionObj(GeneralFit& mfit);

protected:
  string DecodeTypeIdName(string linuxtype);

  AnyDataObj* mObj;
};

#endif
