// This may look like C code, but it is really -*- C++ -*-
#ifndef LOCALMAP_SEEN
#define LOCALMAP_SEEN

#include "pixelmap.h"
#include "sphericalmap.h"
#include "ndatablock.h"

#include "anydataobj.h"
#include "ppersist.h"



// ***************** Class LocalMap *****************************



namespace SOPHYA {


/* Class LocalMap */


template<class T>
class LocalMap : public PixelMap<T>
{

public:

LocalMap();
LocalMap(int_4 nx, int_4 ny);
LocalMap(const LocalMap<T>& lm, bool share);
LocalMap(const LocalMap<T>& lm);
virtual ~LocalMap();

inline virtual bool IsTemp(void) const { return pixels_.IsTemp();}

/*! Setting blockdata to temporary (see ndatablock documentation) */
inline virtual void SetTemp(bool temp=false) const {pixels_.SetTemp(temp);};


// ---------- Overloading of () to access pixel number k ----

inline T& operator()(int_4 k) {return(PixVal(k));}
inline T const& operator()(int_4 k) const {return(PixVal(k));}
inline T& operator()(int_4 ix, int_4 iy) {return PixVal(iy*nSzX_+ix);};
inline T const& operator()(int_4 ix, int_4 iy) const {return PixVal(iy*nSzX_+ix);};
   
// ---------- Definition of PixelMap abstract methods -------

virtual int_4 NbPixels() const;   // D.Y. int change en int_4 rationalisation Mac
  
virtual T& PixVal(int_4 k);
virtual T const& PixVal(int_4 k) const;

virtual bool ContainsSph(double theta, double phi) const;
virtual int_4 PixIndexSph(double theta,double phi) const;
   
virtual void PixThetaPhi(int_4 k,double& theta,double& phi) const;

virtual T SetPixels(T v);

virtual double PixSolAngle(int_4 k) const; 

// ---------- Specific methods ------------------------------

void ReSize(int_4 nx, int_4 ny);

inline virtual char* TypeOfMap() const {return "LOCAL";};
 
virtual void SetOrigin(double theta=90.,double phi=0.,double angle=0.);
virtual void SetOrigin(double theta,double phi,int_4 x0,int_4 y0,double angle=0.);

virtual void SetSize(double angleX,double angleY);

/*! Check to see if the local mapping is done */
inline bool LocalMap_isDone() const {return(originFlag_ && extensFlag_);};

virtual void Project(SphericalMap<T>& sphere) const;
  
/* There should be a more complex algorithm somewhere to combine *several* local maps to a full sphere.
      -> static method, or separate class */
  
/*! provides a integer characterizing the pixelization refinement  (here : number of pixels) */
inline virtual int_4 SizeIndex() const {return(nPix_);}
inline int_4 Size_x() const {return nSzX_;}
inline int_4 Size_y() const {return nSzY_;}

/* Je rajoute ces 2 fonctions inlines pour compatibilite d'interface 
   avec TArray  -   Reza 30/8/2000                                   */
inline int_4 SizeX() const {return nSzX_;}
inline int_4 SizeY() const {return nSzY_;}

inline void Origin(double& theta,double& phi,int_4& x0,int_4& y0,double& angle) const {theta= theta0_; phi= phi0_; x0= x0_; y0= y0_;angle= angle_;}

inline void Aperture(double& anglex,double& angley) const {anglex= angleX_; angley= angleY_;}


/*  Acces to the DataBlock  */
inline       NDataBlock<T>& DataBlock()       {return pixels_;}
inline const NDataBlock<T>& DataBlock() const {return pixels_;}

/* impression */ 
void print(ostream& os) const;

inline  LocalMap<T>& operator = (const LocalMap<T>& a) {return Set(a);}



// ---------- Mthodes internes -----------------------------
          
private :

void InitNul();
void Getij(int_4 k,int_4& i,int_4& j) const;
void ReferenceToUser(double& theta,double& phi) const; 
void UserToReference(double& theta,double& phi) const;
void PixProjToAngle(double x,double y,double& theta,double& phi) const; 
void AngleProjToPix(double theta,double phi,double& x,double& y) const; 

void recopierVariablesSimples(const LocalMap<T>& lm);
LocalMap<T>& Set(const LocalMap<T>& a);
void CloneOrShare(const LocalMap<T>& a);
  LocalMap<T>& CopyElt(const LocalMap<T>& a);


// ---------- Variables internes ----------------------------

int_4 nSzX_;
int_4 nSzY_;
int_4 nPix_;
bool originFlag_;
bool extensFlag_;
int_4 x0_;
int_4 y0_;
double theta0_;
double phi0_;
double angle_;
double cos_angle_;
double sin_angle_;
double angleX_;
double angleY_;
double tgAngleX_;
double tgAngleY_;
NDataBlock<T> pixels_;
};



} // Fin du namespace

#endif
