#ifndef LAMBDABUILDER_SEEN
#define LAMBDABUILDER_SEEN

#include <math.h>
#include "ndatablock.h"
#include "tvector.h" 
#include "alm.h"


namespace SOPHYA {

/*!  classe pour les polynomes de legendre*/
class Legendre {

 public :
Legendre();
Legendre(r_8 x, int_4 lmax);
 inline r_8 getPl(int_4 l) 
{
  if (l>lmax_) 
    {
      throw (" illegal call of Legendre::getPl with index greater than lmax, which Legendre Class was instanciated with : instanciate Legendre with a greater lmax... ");
    }
return Pl_(l);
}

 private : 
  void array_init(int_4 lmax);

  r_8 x_;
  int_4 lmax_;
  TVector<r_8> Pl_;
};



 class LambdaLMBuilder {

 public:

LambdaLMBuilder() {}
LambdaLMBuilder(r_8 theta,int_4 lmax, int_4 mmax);
virtual ~LambdaLMBuilder() {};

 /*! return the value of the coefficient \f$  \lambda_l^m \f$ */
inline double lamlm(int l, int m) const { return lambda_(l,m); }

 private:
 void updateArrayRecurrence(int_4 lmax);

 void array_init(int lmax, int mmax);


 static TriangularMatrix<r_8>* a_recurrence_;
 TriangularMatrix<r_8> lambda_;

 protected :

 void updateArrayLamNorm();

 static  TriangularMatrix<r_8>* lam_fact_;
 static  TVector<r_8>*  normal_l_;
 int_4 lmax_;
 int_4 mmax_;
 r_8 cth_;
 r_8 sth_;
 
 };



class LambdaWXBuilder : public LambdaLMBuilder
{
 public:


LambdaWXBuilder() {}

LambdaWXBuilder(r_8 theta, int_4 lmax, int_4 mmax);
 
 /*! return the value of the coefficients \f$ _{w}\lambda_l^m\f$ and \f$_{x}\lambda_l^m\f$ */
inline void lam_wx(int l, int m, r_8& w, r_8& x) const
   {
     w=lamWlm_(l,m);
     x=lamXlm_(l,m);
   }

 private:

 void array_init();


  TriangularMatrix<r_8> lamWlm_;
  TriangularMatrix<r_8> lamXlm_;
  

};

class LambdaPMBuilder : public LambdaLMBuilder
{
 public:

LambdaPMBuilder() {}

 LambdaPMBuilder(r_8 theta, int_4 lmax, int_4 mmax);
 /*! return the value of the coefficients \f$ _{+}\lambda_l^m\f$ and \f$_{-}\lambda_l^m\f$ */
inline void lam_pm(int l, int m, r_8& lambda_plus, r_8& lambda_moins) const
   {
      lambda_plus = lamPlm_(l,m);
     lambda_moins = lamMlm_(l,m);
   }

 private:
 void array_init();

  TriangularMatrix<r_8> lamPlm_;
  TriangularMatrix<r_8> lamMlm_;

};

} // Fin du namespace

#endif
