#include "machdefs.h"
#include <stdlib.h>
#include <typeinfo>
#include <iostream.h>
#include <string>
#include "nomgadapter.h"

/* --Methode-- */
NObjMgrAdapter::NObjMgrAdapter(AnyDataObj* o)
{
mObj = o;
}

/* --Methode-- */
NObjMgrAdapter::~NObjMgrAdapter()
{
}

/* --Methode-- */
NObjMgrAdapter* NObjMgrAdapter::Clone(AnyDataObj* o)
{
return(new NObjMgrAdapter(o));
}

/* --Methode-- */
AnyDataObj* NObjMgrAdapter::GetDataObj()
{
return(mObj);
}

/* --Methode-- */
string NObjMgrAdapter::GetDataObjType()
{
  return("AnyDataObj ");
}


/* --Methode-- */
AnyDataObj* NObjMgrAdapter::CloneDataObj()
{
string s = typeid(*mObj).name();
cout << "NObjMgrAdapter::CloneDataObj() - Error : Not supported for " << s << endl;
return(NULL);
}

/* --Methode-- */
void NObjMgrAdapter::CopyFrom(AnyDataObj *)
{
string s = typeid(*mObj).name();
cout << "NObjMgrAdapter::CopyFrom() - Error : Not supported for " << s << endl;
}


/* --Methode-- */
string NObjMgrAdapter::ToString()
{
char buff[128];
sprintf("%s@%lx", typeid(*mObj).name(), (long)mObj);
return(buff);
}

/* --Methode-- */
void NObjMgrAdapter::FillFromString()
{
string s = typeid(*mObj).name();
cout << "NObjMgrAdapter::FillFromString() - Error : Not supported for " << s << endl;
 return;
}

/* --Methode-- */
void NObjMgrAdapter::ReadFits(string const & )
{
string s = typeid(*mObj).name();
cout << "NObjMgrAdapter::ReadFits() - Error : Not supported for " << s << endl;
}

/* --Methode-- */
void NObjMgrAdapter::SaveFits(string const & )
{
string s = typeid(*mObj).name();
cout << "NObjMgrAdapter::SaveFits() - Error : Not supported for " << s << endl;
}

/* --Methode-- */
void NObjMgrAdapter::SavePPF(POutPersist&, string const & )
{
string s = typeid(*mObj).name();
cout << "NObjMgrAdapter::SavePPF() - Error : Not supported for " << s << endl;
}

/* --Methode-- */
void NObjMgrAdapter::Print(ostream& )
{
string s = typeid(*mObj).name();
cout << "NObjMgrAdapter::Print() - Error : Not supported for " << s << endl;
}

/* --Methode-- */
PIDrawer* NObjMgrAdapter::GetDrawer(string &)
{
return(NULL);
}

/* --Methode-- */
P2DArrayAdapter* NObjMgrAdapter::Get2DArray(string &)
{
return(NULL);
}

/* --Methode-- */
NTupleInterface* NObjMgrAdapter::GetNTupleInterface(bool& adel)
{
string s = typeid(*mObj).name();
cout << "NObjMgrAdapter::GetNTupleInterface() - Error : Not supported for " << s << endl;
adel = false;
return(NULL);
}

/* --Methode-- */
GeneralFitData* NObjMgrAdapter::GetGeneralFitData(bool& adel
                ,GeneralFitData::FitErrType errtype
                ,double errscale,double errmin,int i1,int i2,int j1,int j2)
{
string s = typeid(*mObj).name();
cout << "NObjMgrAdapter::GetGeneralFitData() - Error : Not supported for "<<s<<endl;
adel = false;
return(NULL);
}

AnyDataObj* NObjMgrAdapter::FitResidusObj(GeneralFit& mfit)
{
string s = typeid(*mObj).name();
cout << "NObjMgrAdapter::FitResidusObj() - Error : Not supported for "<<s<<endl;
return(NULL);
}


AnyDataObj* NObjMgrAdapter::FitFunctionObj(GeneralFit& mfit)
{
string s = typeid(*mObj).name();
cout << "NObjMgrAdapter::FitFunctionObj() - Error : Not supported for "<<s<<endl;
return(NULL);
}

/* --Methode-- */
string NObjMgrAdapter::DecodeTypeIdName(string linuxtype)
// seulement pour Linux qui ne code pas correctement
{
#if defined(Linux)  || defined(linux)
  string type("");
  const char* str = linuxtype.c_str();
  int lstr = (int) strlen(str);
  if(lstr<=0) return string("Linux Decoding error: lstr<=0");

  // Le dernier caractere donne le type
  lstr--;
  if     (str[lstr]=='v') type = "void";
  else if(str[lstr]=='b') type = "bool";
  else if(str[lstr]=='c') type = "char";
  else if(str[lstr]=='s') type = "short";
  else if(str[lstr]=='i') type = "int";
  else if(str[lstr]=='l') type = "long";
  else if(str[lstr]=='x') type = "long long";
  else if(str[lstr]=='f') type = "float";
  else if(str[lstr]=='d') type = "double";
  else if(str[lstr]=='r') type = "long double";
  else return string("Linux Decoding error: bad last char");
  if(lstr==0) return type;

  // Les caracteres precedents donnent: signed, unsigned, *, & ou const.
  // Mais si on a un Z, alors c'est un complexe (code ...t7complex1Z...)
  for(int i=0; i<(int)strlen(str); i++) {
    lstr--;
    if     (str[lstr]=='U') type = "unsigned " + type;
    else if(str[lstr]=='S') type = "signed " + type;
    else if(str[lstr]=='P') type = type + "*";
    else if(str[lstr]=='R') type = type + "&";
    else if(str[lstr]=='C') type = "const " + type;
    else if(str[lstr]=='Z') {  // Complexe
      type = "complex<" + type + ">";
      for(int j=0;j<(int)strlen(str);j++) {
        if     (str[j]=='P') type = type + "*";
        else if(str[j]=='R') type = type + "&";
        else if(str[j]=='C') type = "const " + type;
        else if(str[j]=='t') break;
        else return string("Linux Decoding error: bad char 1,2 for Z");
      }
      break;
    }
    else return string("Linux Decoding error: bad last-1,last-2 char");
    if(lstr==0) break;
  }

return type;
#else
return linuxtype;
#endif
}
