#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream.h>

#include "histinit.h"
#include "dvlist.h"
#include "ntuple.h"
#include "xntuple.h"
#include "fitsxntuple.h"
#include "fitsntuple.h"

int main(int narg, char *arg[])
{
  if (narg < 2) {
    cerr << "scanfits/Erreur arg - Usage scanfits nomfits \n" << endl;
    exit(0);
  }
  try {
    SophyaInit();
    string flnm = arg[1];
    int nbblk = FitsInFile::NbBlocks(arg[1]);
    cout << " :::: File " << flnm << " has " << nbblk << " blocks " << endl;
    DVList header;
    FitsFile::FitsExtensionType exttype;
    FitsFile::FitsDataType datatype;

    cout << " FitsFile::FitsExtensionType : FitsExtensionType_IMAGE= " <<
      (int)FitsFile::FitsExtensionType_IMAGE << 
      "  FitsExtensionType_ASCII_TBL= " << (int)FitsFile::FitsExtensionType_ASCII_TBL <<
      "  FitsExtensionType_BINARY_TBL= " << (int)FitsFile::FitsExtensionType_BINARY_TBL << endl;
    cout << " FitsFile::FitsDataType: FitsDataType_double= " <<
      (int)FitsFile::FitsDataType_double << 
      " FitsDataType_float= " << (int)FitsFile::FitsDataType_float <<
      " FitsDataType_int= " << (int)FitsFile::FitsDataType_int <<
      " FitsDataType_char= " << (int)FitsFile::FitsDataType_char <<
      " FitsDataType_ASCII= " << (int)FitsFile::FitsDataType_ASCII << endl << endl;

    int naxis;
    vector<int> axis;
    for(int i=1; i<=nbblk; i++) {
      FitsInFile::GetBlockType(arg[1], i, exttype, naxis, axis, datatype, header);
      cout << " --------- Header Num " << i << " Type " << (int)exttype 
	   << " NAxis= " << naxis << " (" << axis.size() << " )" 
	   << " DataType= " << (int)datatype << endl;
      for(int j=0; j<axis.size(); j++) cout  << axis[j] << " x "  ;
      cout << endl;
      cout << header << endl;
      cout << "----------------------------------------------------" << endl;
    } 
 
  }
  catch (PThrowable & exc) {
    cerr << " Catched Exception " << (string)typeid(exc).name()
         << " - Msg= " << exc.Msg() << endl;
  }
  catch (...) {
    cerr << " some other exception was caught ! " << endl;
  }

}
