#include "cxxexecutor.h"

#include <typeinfo>

#include "strutilxx.h"
#include "dvlist.h"

#include "nomgadapter.h"
#include "pistdimgapp.h"


/* --Methode-- */
CxxExecutor::CxxExecutor(PIACmd *mpiac, PIStdImgApp* /* app */)
  : mUserCodeFn(""), mCompOpt(""), mLinkOpt(""), mMyLibs("")
{
mIncList.resize(0);
mCallArgs.resize(0);

// On enregistre les nouvelles commandes 
string hgrp = "CxxExecutorCmd";
string usage,kw;

kw = "c++exec";
usage = "c++exec: Execute the following c++ user code\n";
usage+= "Usage: c++exec c++ user code\n";
usage+= "Warning: c++ user code can be found in \"cxx_spiapp.h\"\n";
usage+= "         total generated code can be found in \"cxx_spiapp.cc\"";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++execfrf";
usage = "c++execfrf: Execute c++ user code contained in a file\n";
usage+= "Usage: c++execfrf fileuser.cc\n";
usage+= "Warning: total generated code can be found in \"cxx_spiapp.cc\"";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++args";
usage = "c++args: Define user function arguments for c++exec and c++execfrf\n";
usage+= "Usage: c++args arg1 arg2 arg3 ...\n";
usage+= "       c++args -? : give current arguments\n";
usage+= "       c++args    : reset current arguments";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++create";
usage = "c++create: create a file to be used by spiapp\n";
usage+= "Usage: c++create file.cc func c++ user code...\n";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++createfrf";
usage = "c++createfrf: create a file \"file.cc\"to be used by spiapp\n";
usage+= "              with a user file \"fileuser.cc\"\n";
usage+= "Usage: c++createfrf file.cc func fileuser.cc\n";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++compile";
usage = "c++compile: compile a file (file.cc -> file.so)\n";
usage+= "Usage: c++compile file\n";
usage+= "Warning: give \"file\" or \"file.so\" to create \"file.so\" from \"file.cc\"\n";
usage+= "       : to be used before c++link";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++link";
usage = "c++link: link function \"func\" in file.so to spiapp\n";
usage+= "Usage: c++link file.so func";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++include";
usage = "c++include: give personnal includes to be used\n";
usage+= "Usage: c++include myinc1.h myinc2.h ...\n";
usage+= "       c++include -? : give current include files\n";
usage+= "       c++include    : reset current include files\n";
usage+= "Warning: to be used before c++create... c++exec...";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++compileopt";
usage = "c++compileopt: give additionnal compile options\n";
usage+= "Usage: c++compileopt -g -O5 -IMy_Inc_Dir ...\n";
usage+= "       c++compileopt -? : give current compile options\n";
usage+= "       c++compileopt    : reset current compile options\n";
usage+= "Warning: to be used before c++compile";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++linkopt";
usage = "c++linkopt: give additionnal link options\n";
usage+= "Usage: c++linkopt -g -O5 ...\n";
usage+= "       c++linkopt -? : give current link options\n";
usage+= "       c++linkopt    : reset current link options\n";
usage+= "Warning: to be used before c++compile";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++mylibs";
usage = "c++mylibs: give additionnal libraries\n";
usage+= "Usage: c++mylibs -LMy_Lib_Dir -lmylib1 -lmylib2 ...\n";
usage+= "       c++mylibs -? : give current additionnal libraries\n";
usage+= "       c++mylibs    : reset current additionnal libraries\n";
usage+= "Warning: to be used before c++compile";
mpiac->RegisterCommand(kw, usage, this, hgrp);



//// A VIRER quand variable de objmanager OK  --> Pour Reza
kw = "c++setvar";
usage = "c++setvar: Setting test variable \n";
usage+= "c++setvar varname varcontent ";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++getvar";
usage = "c++getvar: Getting test variable content\n";
usage+= "c++getvar varname ";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++varlist";
usage = "c++getvar: Printing test variable list\n";
usage+= "c++varlist  ";
mpiac->RegisterCommand(kw, usage, this, hgrp);
//// A VIRER quand variable de objmanager OK  --> Pour Reza

}

/* --Methode-- */
CxxExecutor::~CxxExecutor()
{
}

/* --Methode-- */
int CxxExecutor::Execute(string& kw, vector<string>& tokens)
{
int rc=0;
if(kw == "c++exec" || kw == "c++execfrf") {
  if(tokens.size()<1) {
    cout<<"Usage: c++exec c++ user code"<<endl;
    cout<<"Usage: c++execfrf fileuser.cc"<<endl;
    return(1);
  }
  if(kw == "c++exec")    rc = FillUserCode(tokens,0);
  if(kw == "c++execfrf") rc = FillUserCode(tokens[0]);
  if(rc) return(1);
  rc = CrFile();   if(rc) return(1);
  rc = Compile();  if(rc) return(1);
  rc = Link();     if(rc) return(1);
  rc = Call();     if(rc) return(1);

} else if(kw == "c++args") {
  if(tokens.size()==1) if(tokens[0]=="-?")
    {cout<<"c++args "<<GetArgs()<<endl; return(0);}
  FillArgs(tokens);

} else if(kw == "c++create") {
  if(tokens.size()<3) {
    cout<<"Usage: c++create file.cc func c++ user code ..."<<endl;
    return(1);
  }
  rc = FillUserCode(tokens,2);       if(rc) return(1);
  rc = CrFile(tokens[0],tokens[1]);  if(rc) return(1);

} else if(kw == "c++createfrf") {
  if(tokens.size()<3) {
    cout<<"Usage: c++createfrf file.cc func fileuser.cc"<<endl;
    return(1);
  }
  rc = FillUserCode(tokens[2]);     if(rc) return(1);
  rc = CrFile(tokens[0],tokens[1]); if(rc) return(1);

} else if(kw == "c++compile") {
  if(tokens.size()>=1) rc = Compile(tokens[0]);
  else                 rc = Compile();
  if(rc) return(1);

} else if(kw == "c++link") {
  if(tokens.size()>=2)      rc = Link(tokens[0],tokens[1]);
  else if(tokens.size()>=1) rc = Link(tokens[0]);
  else                      rc = Link();
  if(rc) return(1);

} else if(kw == "c++include") {
  if(tokens.size()==1) if(tokens[0]=="-?")
    {cout<<"c++include "<<GetInclude()<<endl; return(0);}
  FillInclude(tokens);

} else if(kw == "c++compileopt") {
  if(tokens.size()==1) if(tokens[0]=="-?")
    {cout<<"c++compileopt "<<GetCompileOpt()<<endl; return(0);}
  FillCompileOpt(tokens);

} else if(kw == "c++linkopt") {
  if(tokens.size()==1) if(tokens[0]=="-?")
    {cout<<"c++linkopt "<<GetLinkOpt()<<endl; return(0);}
  FillLinkOpt(tokens);

} else if(kw == "c++mylibs") {
  if(tokens.size()==1) if(tokens[0]=="-?")
    {cout<<"c++mylibs "<<GetLinkLibs()<<endl; return(0);}
  FillLinkLibs(tokens);


//// A VIRER quand variable de objmanager OK  --> Pour Reza
} else if(kw == "c++setvar") {
  if(tokens.size()<2) {
    cout<<" Usage: c++setvar varname varcontent "<<endl;
    return(1);
  }
  string varcont = tokens[1];
  if(tokens.size()>2) 
    for(uint_4 i=2;i<tokens.size();i++) varcont += " " + tokens[i] ;
  NamedObjMgr omg;
  omg.SetVar(tokens[0], varcont);
} else if(kw == "c++getvar") {
  if(tokens.size()<1) {
    cout<<" Usage: c++getvar varname "<<endl;
    return(1);
  }
  NamedObjMgr omg;
  cout<<"c++getvar("<<tokens[0]<<")="<<omg.GetVar(tokens[0])<<endl;
}  else if(kw == "c++varlist") {
  NamedObjMgr omg; 
  cout<<omg.GetVarList();
}
//// A VIRER quand variable de objmanager OK  --> Pour Reza


return(0);
}

/* --Methode-- */
int CxxExecutor::CrFile(string cfilename,string func)
{
ofstream os(cfilename.c_str(),ios::out);
if(!os)
  {cout<<"CxxExecutor::CrFile: unable to open "<<cfilename<<endl;
   return 1;}

PutInclude(os);
os<<endl;

PutIncludeUser(os);
os<<endl;

os<<"extern \"C\" {"<<endl;
os<<"  int "<<func<<"( vector<string>& args );"<<endl;
os<<"}"<<endl<<endl;
os<<"int "<<func<<"( vector<string>& args )"<<endl;
os<<"{"<<endl;
os<<"// Some definitions to help using spiapp;"<<endl;
os<<"NamedObjMgr omg;"<<endl;
os<<"Services2NObjMgr& srvo = *omg.GetServiceObj();"<<endl;
os<<endl;

PutObject(os);
os<<endl;

PutVar(os);
os<<endl;

os<<"//--------------------------------------------//"<<endl;
os<<"//------------- Code utilisateur -------------//"<<endl;
os<<"//--------------------------------------------//"<<endl;
os<<endl;
os<<"#include \""<<mUserCodeFn<<"\""<<endl;
os<<endl;

os<<"return 0;"<<endl;
os<<"}"<<endl;

cout<<"File "<<cfilename<<" for function "<<func<<" created"<<endl;
cout<<"User code is in file "<<mUserCodeFn<<" included in "<<cfilename<<endl;
return 0;
}

/* --Methode-- */
void CxxExecutor::PutInclude(ofstream& os)
{
os<<"#include \"machdefs.h\""<<endl
  <<endl

  <<"//---- System et stdc++ include files"<<endl
  <<"#include <stdio.h>"<<endl
  <<"#include <stdlib.h>"<<endl
  <<"#include <math.h>"<<endl
  <<"#include <ctype.h>"<<endl
  <<"#include <string.h>"<<endl
  <<"#include <iostream.h>"<<endl
  <<"#include <fstream.h>"<<endl
  <<"#include <complex>"<<endl
  <<endl

  <<"#include <typeinfo>"<<endl
  <<"#include <string>"<<endl
  <<"#include <vector>"<<endl
  <<"#include <map>"<<endl
  <<"#include <functional>"<<endl
  <<"#include <list>"<<endl
  <<endl

  <<"//---- Sophya include files"<<endl
  <<"#include \"systools.h\""<<endl
  <<"#include \"ntools.h\""<<endl
  <<"#include \"array.h\""<<endl
  <<"#include \"histats.h\""<<endl
  <<endl

  <<"//---- Spiapp include files"<<endl
  <<"#include \"nobjmgr.h\""<<endl
  <<"#include \"servnobjm.h\""<<endl
  <<endl

  <<"#define KeepObj(obj) ___nomobj = #obj; omg.AddObj(obj,___nomobj);"<<endl
  <<"#define KeepVar(var) ___nomobj = #var; omg.GetVarList().Get(___nomobj) = var ;"<<endl
  <<endl;

return;
}

/* --Methode-- */
void CxxExecutor::PutIncludeUser(ofstream& os)
{
if(mIncList.size()<1) return;
for(uint_4 i=0;i<mIncList.size();i++)
  os<<"#include \""<<mIncList[i]<<"\""<<endl;
}

/* --Methode-- */
void CxxExecutor::PutObject(ofstream& os)
{
NamedObjMgr omg;
NObjMgrAdapter* objmgrad;
vector<string> objlist;
string patt = "*";
omg.GetObjList(patt,objlist); 
int nobjs = objlist.size();

os<<"//-------------- Object List --------------"<<endl;
os<<"//Number of objects = "<<nobjs<<endl;
os<<"string ___nomobj;"<<endl<<endl;
if(nobjs<=0) return;

string dir,nobj,stmp,obtype;
for(int i=0;i<nobjs;i++) {
  objmgrad = omg.GetObjAdapter(objlist[i]);
  omg.ParseObjectName(objlist[i],dir,nobj);
  obtype = objmgrad->GetDataObjType();
  stmp = "___" + nobj;

  os<<"___nomobj = \""<<nobj<<"\";"<<endl;
  os<<obtype<<"* "<<stmp
    <<" = dynamic_cast< "<<obtype<<" * >(omg.GetObj(___nomobj));"<<endl;
  os<<"if("<<stmp<<"==NULL) throw NullPtrError"
    <<"(\"CxxExecutor::PutObject: Non existing object "<<nobj
    <<"... please update file\");"<<endl;
  os<<obtype<<"& "<<nobj<<" = (*"<<stmp<<");"<<endl<<endl;
}

return;
}

/* --Methode-- */
void CxxExecutor::PutVar(ofstream& os)
{  
os<<"//-------------- Variable List --------------"<<endl;
NamedObjMgr omg;
DVList& varlist = omg.GetVarList();
// varlist.Show(); varlist.Print();  
DVList::ValList::const_iterator it;
for(it=varlist.Begin(); it!=varlist.End(); it++) {
  string key = (*it).first;
  os<<"___nomobj = \""<<key<<"\";"<<endl;
  os<<"MuTyV & $"<<key<<" = omg.GetVarList().Get(___nomobj);"<<endl;
}

return;
}

/* --Methode-- */
int CxxExecutor::FillUserCode(vector<string>& usercode,uint_4 first)
// - first is the first position in the vector<> where the code starts
// User code is read from input. It is put into file "cxx_spiapp.h".
{
mUserCodeFn = "";
uint_4 nus = usercode.size();
if(nus<=first) {cout<<"CxxExecutor::FillUserCode: no user code"<<endl;
                return 1;}
mUserCodeFn = "cxx_spiapp.h";
ofstream os(mUserCodeFn.c_str(),ios::out);
if(!os) {cout<<"CxxExecutor::FillUserCode: unable to open "
             <<mUserCodeFn<<endl;  mUserCodeFn = ""; return 1;}
// On ajoute un blanc pour les chaines de caracteres contenant des blancs
for(uint_4 i=first;i<nus;i++) os<<" "<<usercode[i];
os<<endl;
cout<<"User code filled from standard input into "<<mUserCodeFn<<endl;
return 0;
}

/* --Methode-- */
int CxxExecutor::FillUserCode(string filename)
// User code is read from "filename".
{
mUserCodeFn = filename;
cout<<"User code filled from file "<<filename<<endl;
return 0;
}

/* --Methode-- */
int CxxExecutor::Compile(string rootfilename)
{
string fc = rootfilename + ".cc";
string fl = rootfilename + ".so";
cout<<"Compile: "<<rootfilename<<endl;
int rc = 0;
rc = CrMakefile();
if(rc) return(1);
string make  = "make -f cxx_spiapp_Makefile";
       make += " CXXFLAGS=\"" + mCompOpt + "\"";
       make += " LDFLAGS=\""  + mLinkOpt + "\"";
       make += " MYLIBS=\""   + mMyLibs  + "\"";
       make += " " + rootfilename;
rc = system(make.c_str());
if(rc)
  {cout<<"CxxExecutor::Compile : \n"<<make<<" Failed"<<endl;
   return 1000+rc;}
return 0;
}

/* --Methode-- */
int CxxExecutor::CrMakefile(void)
{
ofstream os("cxx_spiapp_Makefile",ios::out);
if(!os)
  {cout<<"CxxExecutor::CrMakefile: unable to open file for Makefile"<<endl;
   return 1;}
//---------------------------------------------------------------------
os<<"MODULEDECCXXFLAGS := -msg_quiet"<<endl;
os<<"include $(DPCBASEREP)/Include/MakefileUser.h"<<endl;
os<<"MYLIBS ="<<endl;
os<<"LIBS = -L$(SLB) -lPI -lextsophya -lsophya -lm"<<endl;
os<<"ifeq ($(MACHEROS),OSF1)"<<endl;
os<<"LIBS := $(LIBS) -lfor"<<endl;
os<<"endif"<<endl;
os<<"ifeq ($(MACHEROS),Linux)"<<endl;
os<<"LIBS := $(LIBS) -ldl -lf2c"<<endl;
os<<"endif"<<endl;
os<<"%.so:$(OBJ)%.o"<<endl;
os<<"%:%.cc"<<endl;
os<<"%:%.o"<<endl;
os<<"%.o:%.cc"<<endl;
os<<"%.o:%.c"<<endl;
os<<"%:%.c"<<endl;
os<<endl;
os<<".PRECIOUS: %.so"<<endl;
os<<endl;
os<<"%:%.so"<<endl;
os<<"\t"<<"echo $@ \" made (.so) \""<<endl;
os<<"%.so:$(OBJ)%.o"<<endl;
os<<"\t"<<"$(LINK.cc) -shared -o $@ $< $(LIBS) $(MYLIBS)"<<endl;
os<<"$(OBJ)%.o:%.cc"<<endl;
os<<"\t"<<"$(COMPILE.cc)  -o $@ $<"<<endl;
os<<"$(OBJ)%.o:%.c"<<endl;
os<<"\t"<<"$(COMPILE.c) -c $(CFLAGS)   $(USERFLAGS) -o $@ $<"<<endl;
//---------------------------------------------------------------------
return 0;
}

/* --Methode-- */
int CxxExecutor::Link(string libname,string func)
{
NamedObjMgr omg;
PIACmd* mpiac = omg.GetImgApp()->CmdInterpreter();
string key("link");
vector<string> arg; arg.push_back(libname); arg.push_back(func);
int rc = mpiac->ExecuteCommand(key,arg);
cout<<"Link from "<<libname<<" for function "<<func
    <<" (rc="<<rc<<")"<<endl;
return 0;
}

/* --Methode-- */
int CxxExecutor::Call(string func)
{
NamedObjMgr omg;
PIACmd* mpiac = omg.GetImgApp()->CmdInterpreter();
string key("call");
vector<string> arg; arg.push_back(func);
if(mCallArgs.size()>0)
  for(uint_4 i=0;i<mCallArgs.size();i++) arg.push_back(mCallArgs[i]);
mpiac->ExecuteCommand(key,arg);
return 0;
}

/* --Methode-- */
void CxxExecutor::FillArgs(vector<string>& args)
{
mCallArgs.resize(0);
if(args.size()<1) return;
for(uint_4 i=0;i<args.size();i++) mCallArgs.push_back(args[i]);
}

void CxxExecutor::FillArgs(string& args)
{
mCallArgs.resize(0);
FillVStringFrString(args,mCallArgs,' ');
}

string CxxExecutor::GetArgs(void)
{
string dum = "";
if(mCallArgs.size()<1) return dum;
for(uint_4 i=0;i<mCallArgs.size();i++) dum += mCallArgs[i] + " ";
return dum;
}

/* --Methode-- */
void CxxExecutor::FillInclude(vector<string>& inc)
{
mIncList.resize(0);
if(inc.size()<1) return;
for(uint_4 i=0;i<inc.size();i++) mIncList.push_back(inc[i]);
}

void CxxExecutor::FillInclude(string& inc)
{
mIncList.resize(0);
FillVStringFrString(inc,mIncList,' ');
}

string CxxExecutor::GetInclude(void)
{
string dum = "";
if(mIncList.size()<1) return dum;
for(uint_4 i=0;i<mIncList.size();i++) dum += mIncList[i] + " ";
return dum;
}

/* --Methode-- */
void CxxExecutor::FillCompileOpt(vector<string>& copt)
{
mCompOpt = "";
if(copt.size()<1) return;
for(uint_4 i=0;i<copt.size();i++) mCompOpt += copt[i] + " ";
}

void CxxExecutor::FillCompileOpt(string& copt)
{
mCompOpt = copt;
}

string CxxExecutor::GetCompileOpt(void)
{
return mCompOpt;
}

/* --Methode-- */
void CxxExecutor::FillLinkOpt(vector<string>& lopt)
{
mLinkOpt = "";
if(lopt.size()<1) return;
for(uint_4 i=0;i<lopt.size();i++) mLinkOpt += lopt[i] + " ";
}

void CxxExecutor::FillLinkOpt(string& lopt)
{
mLinkOpt = lopt;
}

string CxxExecutor::GetLinkOpt(void)
{
return mLinkOpt;
}

/* --Methode-- */
void CxxExecutor::FillLinkLibs(vector<string>& llibs)
{
mMyLibs = "";
if(llibs.size()<1) return;
for(uint_4 i=0;i<llibs.size();i++) mMyLibs += llibs[i] + " ";
}

void CxxExecutor::FillLinkLibs(string& llibs)
{
mMyLibs = llibs;
}

string CxxExecutor::GetLinkLibs(void)
{
return mMyLibs;
}




/* --Methode--  DO NOT DELETE.... cmv property !!!
int CxxExecutor::FillUserCode(vector<string>& usercode,uint_4 first)
{
mUserCodeFn = "";
uint_4 nus = usercode.size();
if(nus<=first) {
  cout<<"CxxExecutor::FillUserCode: no user code"<<endl;
  return 1;
}
mUserCodeFn = "cxx_spiapp.h";
ofstream os(mUserCodeFn.c_str(),ios::out);
if(!os)
  {cout<<"CxxExecutor::FillUserCode: unable to open "<<mUserCodeFn<<endl;
   mUserCodeFn = ""; return 1;}
// **** 1er probleme ****
// - Pour la lisibilite et eviter les bugs avec les chaines de caracteres
// contenant des blancs, on ne casse les lignes qu'apres un ";" a condition
// qu'il ne soit pas dans une chaine de caracteres c'est a dire
// entoure de "....;....".
// - Attention aux " dans les chaines de caracteres:  "...\"..."
// - Bugs non-gere pour les tortures: ".....\\" suivi par une autre
//   chaine de caracteres qui contient un ';'
//   ex: cout<<"aaa\\"; cout<<"blabla;blabla";
// **** 2ieme probleme ****
// - Le decodeur de ligne va couper les commentaires qui contiennent des blancs:
// "salut ca va" --> tokens[0]="salut tokens[1]=ca tokens[2]=va" --> "salutcava"
// - On contourne partiellement le pb en ajoutant un blanc en debut des tokens[]
// identifies comme etant dans une chaine de caracteres (mais impossible de gerer
// si il y a plusieurs blancs!): "salut     ca    va" -> "salut ca va"
// **** Conclusion ****
// Pour ecrire du code sophistique, le faire dans un fichier
string dum = "";
bool lastchar = false;
bool comment = false;
for(uint_4 i=first;i<nus;i++) {
  const char* str = usercode[i].c_str();
  size_t lstr= strlen(str);
  for(uint_4 j=0;j<lstr;j++) {
    // debut de mot dans un commentaire -> ajouter un blanc
    if(j==0 && comment) dum += " ";
    // on arrive sur un " : debut ou fin commentaire? inactif (\")?
    if(str[j]=='"') {
      if(j==0) comment = (comment) ? false: true;
      else {if(str[j-1]!='\\') comment = (comment) ? false: true;}
    }
    dum += str[j];
    if( i==nus-1 && j==lstr-1 ) lastchar = true;
    // On charge la string "dum" si : 1-/ on a un ";"
    //                                2-/ c'est le dernier charactere
    if((str[j]==';' && !comment) || lastchar)
      {os<<dum<<endl; dum = "";}
  }
}
cout<<"User code filled from standard input into "<<mUserCodeFn<<endl;
return 0;
}
*/
