// Classe CxxExecWindow : Control Window for CxxExecutor
// Classe CxxExecOptWindow : Option Window for CxxExecutor
// (c) DAPNIA (CEA)                 LAL (IN2P3/CNRS)
//                           R. Ansari  10/2000

#include "cxxexecutor.h"
#include "cxxexecwin.h"

/* --Methode-- */
CxxExecWind::CxxExecWind(PIStdImgApp* par, CxxExecutor * cxxexec)
: PIWindow((PIMsgHandler *)par, "CxxExecutor", PIWK_normal, 400, 300, 150, 150)
{
  dap = par;
  cxxex = cxxexec;

  int bsx, bsy, szx, szy;
  int px, py, spx, spy;
  // On definit la taille a partir de la taille par defaut des composantes 
  PIApplicationPrefCompSize(bsx, bsy);
  // On redefinit la taille de la fenetre
  spx = bsx/6;
  spy = bsy/6;
  szx = 8*bsx+2*spx;   
  szy = 10*bsy+8*spy;
  SetSize(szx, szy);

// Creation de champs "labels"
  px = (szx-6*bsx)/2;
  py = 2*spy;
  mLab = new PILabel(this, "File", bsx*6, bsy, bsx, py);
  mLab->SetLabel("No File Name");
  mLab->SetBorderWidth(1);
  mLab->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);
  
  px = spx;
  py = 4*spy+bsy;

// Creation du champ texte 
  mText = new PIText(this, "helptext", true, true, bsx*8, 8*bsy, px, py);
// mText->SetMutiLineMode(true);
  mText->SetTextEditable(true);
  mText->SetText("");
  mText->SetBinding(PIBK_elastic,PIBK_elastic, PIBK_elastic,PIBK_elastic);

// Creation de bouton d'action 

  py += 2*spy+8*bsy;
  px = (szx-6*bsx-8*spx)/2;
  mBut[0] = new PIButton(this, "Exec",  400, bsx*1.2, bsy, px, py);
  px += 1.2*bsx+2*spx;
  mBut[1] = new PIButton(this, "Open",  500, bsx*1.2, bsy, px, py);
  px += 1.2*bsx+2*spx;
  mBut[2] = new PIButton(this, "Save",  600, bsx*1.2, bsy, px, py);
  px += 1.2*bsx+2*spx;
  mBut[3] = new PIButton(this, "Save As",  660, bsx*1.2, bsy, px, py);
  px += 1.2*bsx+2*spx;
  mBut[4] = new PIButton(this, "Dismiss",  700, bsx*1.2, bsy, px, py);

//  Taille et position proportionnelles a la taille de la fenetre pour les elements
  for(int ii=0; ii<5; ii++) 
    mBut[ii]->SetBinding(PIBK_elastic , PIBK_elastic , PIBK_elastic , PIBK_elastic);

  // Notre File Chooser
  pfc = new PIFileChooser(this,"CxxExec-FileChooser", 5000); 
}

/* --Methode-- */
CxxExecWind::~CxxExecWind()
{
  delete mLab;
  delete mText;
  for(int i=0; i<5; i++)   delete mBut[i];
  delete pfc;
}


/* --Methode-- */
void CxxExecWind::Show()
{
  mLab->SetLabel(flnm);
  PIWindow::Show();
}

/* --Methode-- */
void CxxExecWind::Process(PIMessage msg, PIMsgHandler* /*sender*/, void* data)
{

  switch (UserMsg(msg))  {

    case 400:    // Bouton Execute C++
      {
      dap->SetBusy();
      mBut[0]->SetUnSensitive();
      //  $CHECK$  REZA + CMV 23/10/2000 - Faire quelque chose de mieux ici
      vector<string> vs;
      int rc;
      vs.push_back(mText->GetText());
      rc = cxxex->FillUserCode(vs, 0);
      if (rc) break;
      rc = cxxex->CrFile();
      if (rc) break;
      rc = cxxex->Compile();
      if (rc) break;
      rc = cxxex->Link();
      if (rc) break;
      rc = cxxex->Call();
      if (rc) break;
      // End de $CHECK$  REZA + CMV 23/10/2000
      mBut[0]->SetSensitive();
      dap->SetReady();
      break;
      }

    case 500:    // Open File
      pfc->AcceptNewFile(false); 
      pfc->SetMsg(5500);
      dap->SetBlocked();
      pfc->Show();
      break;
    
    case 5500:  // Return from open-file dialog
      dap->SetBusy();
      if (data) {
	flnm = pfc->GetFileName();
	mLab->SetLabel(flnm);
	// We have to read the file 
	mText->SetText("REZA A FAIRE \n Fichier non lu !");
      }
      dap->SetReady();
      break;

    case 600:
    case 660:
      if ( (UserMsg(msg) == 600) && (flnm.length() > 0) ) {
	cerr << " REZA A FAIRE ! Il faut sauver le champ texte ds fichier "
	     << flnm << endl;
      }
      else {
	pfc->AcceptNewFile(true); 
	pfc->SetMsg(5600);
	dap->SetBlocked();
	pfc->Show();	
      }
      break;

    case 5600:  // Return from Save-file dialog
      dap->SetBusy();
      if (data) {
	flnm = pfc->GetFileName();
	mLab->SetLabel(flnm);
	// We have to save to the file 
	cerr << " REZA A FAIRE ! Il faut sauver le champ texte ds fichier (2)"
	     << flnm << endl;
      }
      dap->SetReady();
      break;

    case 700:   // Bouton Dismiss - On cache la fenetre
      this->Hide();
      break;
  }

  // In case of compile errors, we end-up here !    
  mBut[0]->SetSensitive();
  dap->SetReady();
  return;
}

// --------------------------------------------------------------------
// --------------------------------------------------------------------
// --------------------------------------------------------------------

/* --Methode-- */
CxxOptionWind::CxxOptionWind(PIStdImgApp* par, CxxExecutor * cxxexec)
: PIWindow((PIMsgHandler *)par, "CxxOption", PIWK_normal, 400, 300, 150, 150)
{

  dap = par;
  cxxex = cxxexec;

  int bsx, bsy, szx, szy;
  int px, py, spx, spy;
  // On definit la taille a partir de la taille par defaut des composantes 
  PIApplicationPrefCompSize(bsx, bsy);
  // On redefinit la taille de la fenetre
  spx = bsx/6;
  spy = bsy/6;
  szx = 7*bsx+5*spx;   
  szy = 6*bsy+12*spy;
  SetSize(szx, szy);

// Creation de champs "labels"
  px = (szx-6*bsx)/2;
  py = 2*spy;
  mTit = new PILabel(this, "CxxExecutor Options", bsx*6, bsy, bsx, py);
  mTit->SetBorderWidth(1);
  
  px = 2*spx;
  py = 4*spy+bsy;
  mLab[0] = new PILabel(this, "Include Files", bsx*2, bsy, px, py);
  py += spy+bsy;
  mLab[1] = new PILabel(this, "Compile Options", bsx*2, bsy, px, py);
  py += spy+bsy;
  mLab[2] = new PILabel(this, "Link Options", bsx*2, bsy, px, py);
  py += spy+bsy;
  mLab[3] = new PILabel(this, "Libraries", bsx*2, bsy, px, py);

  px = 3*spx+2*bsx;
  py = 4*spy+bsy;

// Creation de champs textes 
  mText[0] = new PIText(this, "IncFiles", bsx*5, bsy, px, py);
  mText[0]->SetText("");
  py += spy+bsy;
  mText[1] = new PIText(this, "CompOpt", bsx*5, bsy, px, py);
  mText[1]->SetText("");
  py += spy+bsy;
  mText[2] = new PIText(this, "LinkOpt", bsx*5, bsy, px, py);
  mText[2]->SetText("");
  py += spy+bsy;
  mText[3] = new PIText(this, "LinkLib", bsx*5, bsy, px, py);
  mText[3]->SetText("");

// Creation de bouton d'action 

  py += 3*spy+bsy;
  px = (szx-6*bsx-6*spx)/2;
  mBut[0] = new PIButton(this, "Set Options",  500, bsx*2, bsy, px, py);
  px += 2*bsx+2*spx;
  mBut[1] = new PIButton(this, "Get Option",  600, bsx*2, bsy, px, py);
  px += 2*bsx+2*spx;
  mBut[2] = new PIButton(this, "Dismiss",  700, bsx*2, bsy, px, py);

//  Taille et position proportionnelles a la taille de la fenetre pour les elements
  mTit->SetBinding(PIBK_elastic , PIBK_elastic , PIBK_elastic , PIBK_elastic);

  for(int i=0; i<4; i++) {
    mLab[i]->SetBinding(PIBK_elastic , PIBK_elastic , PIBK_elastic , PIBK_elastic);

    mText[i]->SetBinding(PIBK_elastic , PIBK_elastic , PIBK_elastic , PIBK_elastic);
  }
  for(int ii=0; ii<3; ii++) 
    mBut[ii]->SetBinding(PIBK_elastic , PIBK_elastic , PIBK_elastic , PIBK_elastic);

}

/* --Methode-- */
CxxOptionWind::~CxxOptionWind()
{
  for(int i=0; i<4; i++) {
    delete mLab[i];
    delete mText[i];
  }
  delete mTit;
  delete mBut[0]; 
  delete mBut[1]; 
  delete mBut[2]; 
}


/* --Methode-- */
void CxxOptionWind::Show()
{
  mText[0]->SetText(cxxex->GetInclude());
  mText[1]->SetText(cxxex->GetCompileOpt());
  mText[2]->SetText(cxxex->GetLinkOpt());
  mText[2]->SetText(cxxex->GetLinkLibs());
  PIWindow::Show();
}

/* --Methode-- */
void CxxOptionWind::Process(PIMessage msg, PIMsgHandler* /*sender*/, void* /*data*/)
{

  string opt;
 
  switch (UserMsg(msg))  {

    case 500:    // Bouton Set Options
// On recupere les textes des 3 champs :
      opt = mText[0]->GetText();
      cxxex->FillInclude(opt);
      opt = mText[1]->GetText();
      cxxex->FillCompileOpt(opt);
      opt = mText[2]->GetText();
      cxxex->FillLinkOpt(opt);
      opt = mText[3]->GetText();
      cxxex->FillLinkLibs(opt);
      break;

    case 600:    // Bouton Get Options
      mText[0]->SetText(cxxex->GetInclude());
      mText[1]->SetText(cxxex->GetCompileOpt());
      mText[2]->SetText(cxxex->GetLinkOpt());
      mText[2]->SetText(cxxex->GetLinkLibs());
      break;

    case 700:   // Bouton Dismiss - On cache la fenetre
      this->Hide();
      break;
  }
    
return;
}


