#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <math.h>

#include <typeinfo>

#include <vector>
#include <string>

#include "piacmd.h"
#include "nobjmgr.h"
#include "pistdimgapp.h"
#include "servnobjm.h"
#include "tvector.h"
#include "pitvmaad.h"
#include "fftpserver.h"
#include "bruit.h"
#include "piscdrawwdg.h"
#include "ctimer.h"

extern "C" {
void sopiamodule_init();
void sopiamodule_end();
}

void SophyaFFT(string& nom, string& nomout, string dopt);

class sopiamoduleExecutor : public CmdExecutor {
public:
                sopiamoduleExecutor();
  virtual       ~sopiamoduleExecutor();
  virtual int   Execute(string& keyw, vector<string>& args, string& toks);
};

/* --Methode-- */
sopiamoduleExecutor::sopiamoduleExecutor()
{

PIACmd * mpiac;
NamedObjMgr omg;
mpiac = omg.GetImgApp()->CmdInterpreter();

string hgrp = "SophyaCmd";
string kw = "powerspec";
string usage = "FFT on a vector -> Plots power spectrum ";
usage += "\n Usage: fftp vecName vecFFT [graphic_att] ";
mpiac->RegisterCommand(kw, usage, this, hgrp);

}

/* --Methode-- */
sopiamoduleExecutor::~sopiamoduleExecutor()
{
}

/* --Methode-- */
int sopiamoduleExecutor::Execute(string& kw, vector<string>& tokens, string& toks)
{

if (kw == "powerspec") {
  if (tokens.size() < 2) {
    cout << "Usage: powerspec nameVec vecFFT [graphic_att]" << endl;
    return(0);
    }
  if (tokens.size() < 3)  tokens.push_back((string)"n");
  SophyaFFT(tokens[0], tokens[1], tokens[2]);
  }

return(0);

}

static sopiamoduleExecutor * piaerex = NULL;
/* Nouvelle-Fonction */
void sopiamodule_init()
{
// Fonction d'initialisation du module
// Appele par le gestionnaire de modules de piapp (PIACmd::LoadModule())
if (piaerex) delete piaerex;
piaerex = new sopiamoduleExecutor;
}

/* Nouvelle-Fonction */
void sopiamodule_end()
{
// Desactivation du module
if (piaerex) delete piaerex;
piaerex = NULL;
}


/* --Methode-- */
void SophyaFFT(string& nom, string& nomout, string dopt)
{
NamedObjMgr omg;
AnyDataObj* obj=omg.GetObj(nom);
if (obj == NULL) {
  cout << "SophyaFFT() Error , Pas d'objet de nom " << nom << endl;
  return;
}

Vector* vin = dynamic_cast<Vector *>(obj);
if (vin == NULL) {
  cout << "SophyaFFT() Error , Objet n'est pas un vecteur " <<  endl;
  return;
  }

TVector< complex<double> > * vout = new TVector< complex<double> > (1) ;
FFTPackServer ffts;
cout << "SophyaFFT() - Executing FFT of vector size " << vin->NElts() << endl;
ffts.FFTForward(*vin, *vout);
Timer tm;
tm.Split(" FFT done ");

omg.AddObj(vout, nomout);
omg.DisplayObj(nomout, dopt);
return;

}
