// This may look like C code, but it is really -*- C++ -*-
// Objets traceur qui peuvent etre attaches a un PIBaseWidget
//                             R. Ansari  97-98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA
#ifndef PIDRAWER_H
#define PIDRAWER_H

#include "pibwdggen.h"
#include "pigraphuc.h"
#include <list>

enum {
  kStdAxes     = 0x0001,
  kBoxAxes     = 0x0002,
  kTicks       = 0x0004,
  kIntTicks    = 0x0010,
  kExtTicks    = 0x0020,
  kMajTicks    = 0x0040,
  kMinTicks    = 0x0080,
  kLabels      = 0x1000,
  kAxesDflt    = kStdAxes | kTicks | kLabels,       // Axes trace par defaut
  kAxesNone    = 0                                  // Pas de trace d axe  
};


class PIDrawer {
public:
                     PIDrawer();
  virtual           ~PIDrawer();

  virtual void       SetLimits(float xmin, float xmax, float ymin, float ymax,
                               int axrl=kAxeDirSame, int ayud=kAxeDirSame);

  virtual void       DrawAxes(PIGraphicUC* g);
  virtual void       SetAxesFlags(unsigned int flags=kAxesNone);
    
  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax); 
   
  virtual void       Refresh();      // Recalcule les limites et reaffiche
  virtual void       UpdateLimits();   // Calcule et change les limites  

  float XMin() const {return xMin;}
  float XMax() const {return xMax;}
  float YMin() const {return yMin;}
  float YMax() const {return yMax;}
  
  inline PIGraphicUC*    GetGraphicUC() { return(mGrUC); }

  int    LimitsFixed() const {return limitsFixed;}
  void   FreeLimits() {limitsFixed = 0;}

  void               SetColAtt(PIColors fg=PI_NotDefColor, 
                               PIColors bg=PI_NotDefColor);
  void               SetLineAtt(PILineAtt lat=PI_NotDefLineAtt);
  void               SetFontAtt(PIFontSize fsz=PI_NotDefFontSize,
                                PIFontAtt fat=PI_NotDefFontAtt);
  void               SetMarkerAtt(int sz=-1, PIMarker mrk=PI_NotDefMarker);
  void               SetColMapId(CMapId cid=CMAP_OTHER);

  void               SelGraAtt(PIGraphicUC* g);

//  Les objets/methodes suivants devraient etre protected     
//  Pb avec acces depuis PIBaseWdgGen (Reza 11/07/97) 
  virtual  PIGraphicUC*  SetDrwWdg(PIBaseWdgGen* drw, int x0, int y0, int dx, int dy, PIGraphicGen* g);

//  Je declare en public a cause de cxx - Reza 11/07/97 
  struct DrwBWId { int id; PIBaseWdgGen* wdg; };
  
protected:
  friend class PIBaseWdgGen;
  virtual void       Attach(PIBaseWdgGen*, int id);
  virtual void       Detach(PIBaseWdgGen*, int id);

  void CalcTicks();

  void DrawHTicks(PIGraphicUC* g, float y, float tickUp, float tickDown, float xBeg, float xStep);
  void DrawVTicks(PIGraphicUC* g, float x, float tickLeft, float tickRight, float yBeg, float yStep);
  void DrawHLabels(PIGraphicUC* g, float y, float xBeg, float xStep, int just=0);
  void DrawVLabels(PIGraphicUC* g, float x, float yBeg, float yStep, int just=0);

  
  float xMin, xMax, yMin, yMax;  // Valeurs en unites user
  int xW0, yW0, xWd, yWd;        // Origine/largeur ds la fenetre de trace
  bool   aXdir, aYdir;           // Sens des axes horiz, vertical 
  int aXFlg, aYFlg;

  float xFirstMajTick, xFirstMinTick;
  float yFirstMajTick, yFirstMinTick;
  float xMajTickStep, xMinTickStep;
  float yMajTickStep, yMinTickStep;
  float xMajTickLen,  xMinTickLen;
  float yMajTickLen,  yMinTickLen;
  
  int limitsFixed;
  unsigned int axesFlags;
  
  PIBaseWdgGen* mBWdg;
  PIGraphicUC* mGrUC;

  list<DrwBWId>  mBWdgList;
  bool mDndfg;

//  Gestion d attributs graphiques associes a chaque drawer
  PIColors           mFCol, mBCol;
  PILineAtt          mLAtt;
  PIFontSize         mFSz;
  PIFontAtt          mFAtt;
  int                mMSz;
  PIMarker           mMrk;  
  CMapId             mCmapid;
  
};


//  Classe avec gestion d une liste d elements a tracer 

class PIElDrawer : public PIDrawer 
{
public:
  enum { PIDEL_Line = 1, PIDEL_Text = 2,
         PIDEL_Rect = 3, PIDEL_FRect = 4, 
         PIDEL_Circ = 5, PIDEL_FCirc = 6 } ; 

                     PIElDrawer();
  virtual           ~PIElDrawer();

  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax); 

  inline int         ElAddLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2)
    { return( ElAdd(PIDEL_Line, x1, y1, x2, y2, NULL) ); }  
  inline int         ElAddText(PIGrCoord x, PIGrCoord y, char* s)
    { return( ElAdd(PIDEL_Text, x, y, 0, 0, s) ); }  
  inline int         ElAddRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy)
    { return( ElAdd(PIDEL_Rect, x, y, dx, dy, NULL) ); }  
  inline int         ElAddFRect(PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy)
    { return( ElAdd(PIDEL_FRect, x, y, dx, dy, NULL) ); }  
  inline int         ElAddCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r)
    { return( ElAdd(PIDEL_Circ, x, y, r, r, NULL) ); }  
  inline int         ElAddFCirc(PIGrCoord x, PIGrCoord y, PIGrCoord r)
    { return( ElAdd(PIDEL_FCirc, x, y, r, r, NULL) ); }  

  void               ElDel(int id);
  void               ElDelAll();

protected:
  int                ElAdd(int typ, PIGrCoord x, PIGrCoord y, PIGrCoord dx, PIGrCoord dy, char* s);
#ifdef __DECCXX
public:
#endif
  struct DrwEl{
    int eid, etyp;
    PIGrCoord ex,ey;
    PIGrCoord edx,edy;
    string es;
  };
#ifdef __DECCXX
protected:
#endif
  typedef list<DrwEl> DrwElList;

  DrwElList mElist;
  int mEn;

};

#endif
