// Module PI : Peida Interactive     PIScDrawWdg
// Gestionnaire Drawer-2D  E.Aubourg, R. Ansari  96-98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PISCDRAWWDG_H
#define PISCDRAWWDG_H

#include "pisysdep.h"
#include PIBWDG_H
#include PISTDWDG_H
#include PIWIN_H
#include "pidrawer.h"


// PIScDrawWdg, Gestionnaire de traceur 2D 

class PIScDrawWdg : public PIBaseWdg {
public:
  enum {ClassId = 5300};

                     PIScDrawWdg(PIContainerGen *par, char *nom,
                                   int sx=100, int sy=100, int px=0, int py=0);
  virtual            ~PIScDrawWdg();

  virtual long       kind() {return ClassId; }
  
  virtual void       SetLimits(float xmin, float xmax, float ymin, float ymax, 
                               int axrl=kAxeDirSame, int ayud=kAxeDirSame, bool tmp=false);
  virtual void	     UpdateLimits();  // Calcule et change les limites a partir de Drawer-No-1 

  inline void        SetAxesFlags(unsigned int flags=kAxesDflt) { mBDrw->SetAxesFlags(flags); }

  int                AddScDrawer(PIDrawer*, bool ad=false);   // Ajoute un Drawer en auto 
  inline PIDrawer*   BaseDrawer() { return mBDrw; };

  float XMin() const {return mBDrw->XMin();}
  float XMax() const {return mBDrw->XMax();}
  float YMin() const {return mBDrw->YMin();}
  float YMax() const {return mBDrw->YMax();}
  float XPPos() const { return mPPos[0]; }
  float YPPos() const { return mPPos[1]; }
  int    LimitsFixed() const {return mBDrw->LimitsFixed();}
  void   FreeLimits() { mBDrw->FreeLimits(); }
    

  virtual string     GetClickText(float x, float y); // Donne le texte a afficher pour position x,y

  void               SetTextWin(PILabel * tw, bool trw=true, int tx=300, int ty=30);

  virtual void       But1Press(int x, int y);
  virtual void       But1Release(int x, int y);
  virtual void       Ptr1Move(int x, int y);

  virtual void       But2Press(int x, int y);
  virtual void       But2Release(int x, int y);
  virtual void       Ptr2Move(int x, int y);
  
  virtual void       Keyboard(int key, PIKeyModifier kmod);
  virtual void       PasteSelection(unsigned int typ, void *pdata, unsigned int l);
  
protected:
  float xMinS, xMaxS, yMinS, yMaxS; // Sauvegarde pour zoom
  float mPPos[2];               // Position click souris X,Y

  PIElDrawer* mBDrw;
  
  int xBegDrag, yBegDrag;
  int xEndDrag, yEndDrag;
  PIColors cForCol;
  PIGOMode cGOmod;  
  PIPointer cPointer;
  PILineAtt cLatt;
  PILabel * mTxw;  
  PILabel * mTrlb;
  PIWindow * mTrW;


private:
  bool  UpdateText(int xp, int yp);
};


// Classe de traceur de points/fonction Y=F(x)

class P1DArrayAdapter;
class PIYfXDrawer : public PIDrawer {
public:
                     PIYfXDrawer(P1DArrayAdapter* ax, P1DArrayAdapter* ay, bool ad);
  virtual           ~PIYfXDrawer();
  
  virtual void       Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax);
  virtual void       UpdateLimits();
  
       
protected:
  P1DArrayAdapter* mAx;
  P1DArrayAdapter* mAy;
  int mSz;
  bool mAdDO;
};

#endif
