// Module PI : Peida Interactive     PICMapView
// Visualisation de table de couleur     R. Ansari  07/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "picmapview.h"



/* --Methode-- */
PICMapView::PICMapView(PIContainerGen *par, char *nom,
                       int sx, int sy, int px, int py) 
: PIBaseWdg(par, nom, sx, sy, px, py)

{
  cmap = NULL; 
}


/* --Methode-- */
PICMapView::~PICMapView()
{
  if (cmap) delete cmap;
}

 
/* --Methode-- */
void PICMapView::SetColMap(PIColorMap* cmp, bool refr)
{
  if (cmp == NULL)   { 
    if (cmap) delete cmap;
    cmap = NULL;
    return;
    }
  if ( cmap && (cmp->Type() == cmap->Type()) && (cmp->Type() != CMAP_OTHER) ) return;
  if (cmap) delete cmap;
  cmap = new PIColorMap(*cmp);
  if (refr)  Refresh();  
  return;
}

/* --Methode-- */
void PICMapView::SetColMapId(CMapId cmapid, bool refr)
{
  if (cmap && (cmap->Type() == cmapid) && (cmapid != CMAP_OTHER) )  return;
  if (cmap) delete cmap;
  cmap = new PIColorMap(cmapid);
  if (refr)  Refresh();  
  return;
}


/* --Methode-- */
void PICMapView::Draw(PIGraphicGen* g, int /*x0*/, int /*y0*/, int /*dx*/, int /*dy*/)
{
  if (!cmap) { 
    EraseWindow(0, 0, XSize(), YSize());
    return;
    }
  // On presente la table de couleur verticalement si SizeY > SizeX 
  // ou horizontale  si SizeX > SizeY

  int sx = XSize(); 
  int sy = YSize(); 

  int k;
  if (sx > sy) {    // horizontal
    int xc, dx;
    xc = 0;
    for(k=0; k<cmap->NCol(); k++) {
      dx = (sx-xc)/(cmap->NCol()-k);
      g->SelForeground((*cmap), k);
      g->DrawFBox(xc, 0, dx, sy);
      xc += dx;
    }
  }
  else  {    // vertical
    int yc, dy;
    yc = sy;
    for(k=0; k<cmap->NCol(); k++) {
      dy = yc/(cmap->NCol()-k);
      yc -= dy;
      g->SelForeground((*cmap), k);
      g->DrawFBox(0, yc, sx, dy);
    }
  }
  
  return;
}






