#include "cxxexecutor.h"

#include <typeinfo>

#include "strutilxx.h"
#include "dvlist.h"
#include "cxxcmplnk.h"

#include "nomgadapter.h"
#include "pistdimgapp.h"


/* --Methode-- */
CxxExecutor::CxxExecutor(PIACmd *mpiac, PIStdImgApp* /* app */)
  : mUserCodeFn(""), mUserFctFn("")
  , mCompOpt(""), mLinkOpt(""), mMyLibs("")
  , mDefTmp(""), mDefRoot("cxx_spiapp"), mDefFunc("usercxx"), mPrtLevel(2)
{
mIncList.resize(0);
mCallArgs.resize(0);

// Gestion des fichiers par default dans TmpDir 
NamedObjMgr omg;
string tmpdir = omg.GetTmpDir();
if(tmpdir.size()>1) mDefTmp = tmpdir;

// On enregistre les nouvelles commandes 
string hgrp = "CxxExecutorCmd";
string usage,kw;

kw = "c++exec";
usage = "c++exec: Execute the following c++ user code\n";
usage+= "Usage: c++exec c++ user code\n";
usage+= "Warning: c++ user code can be found in \"TmpDir/"+mDefRoot+".h\"\n";
usage+= "         total generated code can be found in \"TmpDir/"+mDefRoot+".cc\"";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++execfrf";
usage = "c++execfrf: Execute c++ user_code [user_function_code]\n";
usage+= "Usage: c++execfrf fileuser.cc [fileuserfct.cc]\n";
usage+= "Warning: total generated code can be found in \"TmpDir/"+mDefRoot+".cc\"";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++args";
usage = "c++args: Define user function arguments for c++exec and c++execfrf\n";
usage+= "Usage: c++args arg1 arg2 arg3 ...\n";
usage+= "       c++args -? : give current arguments\n";
usage+= "       c++args    : reset current arguments";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++create";
usage = "c++create: create a file \"file.cc\" to be used by spiapp\n";
usage+= "Usage: c++create file.cc func c++ user code...\n";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++createfrf";
usage = "c++createfrf: create a file \"file.cc\" to be used by spiapp\n";
usage+= "        with a user file code \"fileuser.cc\"\n";
usage+= "        and an optional user function code \"fileuserfct.cc\"\n";
usage+= "Usage: c++createfrf file.cc func fileuser.cc [fileuserfct.cc]\n";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++compile";
usage = "c++compile: compile a file (file.cc -> file.so)\n";
usage+= "Usage: c++compile file\n";
usage+= "Warning: give \"file\" or \"file.so\" to create \"file.so\" from \"file.cc\"\n";
usage+= "       : to be used before c++link";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++link";
usage = "c++link: link function \"func\" in file.so to spiapp\n";
usage+= "Usage: c++link file.so func";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++include";
usage = "c++include: give personnal includes to be used\n";
usage+= "Usage: c++include myinc1.h myinc2.h ...\n";
usage+= "       c++include -? : give current include files\n";
usage+= "       c++include    : reset current include files\n";
usage+= "Warning: to be used before c++create... c++exec...";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++compileopt";
usage = "c++compileopt: give additionnal compile options\n";
usage+= "Usage: c++compileopt -g -O5 -IMy_Inc_Dir ...\n";
usage+= "       c++compileopt -? : give current compile options\n";
usage+= "       c++compileopt    : reset current compile options\n";
usage+= "Warning: to be used before c++compile";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++linkopt";
usage = "c++linkopt: give additionnal link options\n";
usage+= "Usage: c++linkopt -g -O5 ...\n";
usage+= "       c++linkopt -? : give current link options\n";
usage+= "       c++linkopt    : reset current link options\n";
usage+= "Warning: to be used before c++compile";
mpiac->RegisterCommand(kw, usage, this, hgrp);

kw = "c++mylibs";
usage = "c++mylibs: give additionnal libraries\n";
usage+= "Usage: c++mylibs -LMy_Lib_Dir -lmylib1 -lmylib2 ...\n";
usage+= "       c++mylibs -? : give current additionnal libraries\n";
usage+= "       c++mylibs    : reset current additionnal libraries\n";
usage+= "Warning: to be used before c++compile";
mpiac->RegisterCommand(kw, usage, this, hgrp);


kw = "c++prtlevel";
usage = "c++prtlevel: Print level\n";
usage+= "Usage: c++prtlevel prtlevel\n";
usage+= "       prtlevel=0 : minimum printing\n";
usage+= "       prtlevel=1 : + compiler/linker output\n";
usage+= "       prtlevel=2 : + full infos (default)";
mpiac->RegisterCommand(kw, usage, this, hgrp);

}

/* --Methode-- */
CxxExecutor::~CxxExecutor()
{
}

/* --Methode-- */
int CxxExecutor::Execute(string& kw, vector<string>& tokens, string& toks)
{
int rc=0;
if(kw == "c++exec") {
  if(tokens.size()<1) {
    cout<<"Usage: c++exec c++ user code"<<endl;
    return(1);
  }
  rc = ExecuteCXX(toks); if(rc) return(1);

} else if(kw == "c++execfrf") {
  if(tokens.size()<1) {
    cout<<"Usage: c++execfrf fileuser.cc [fileuserfct.cc]"<<endl;
    return(1);
  }
  rc = FillUserCode(tokens[0]); if(rc) return(1);
  if(tokens.size()>1) rc = FillUserFctFrF(tokens[1]);
    else              rc = FillUserFctFrF();
  if(rc) return(1);
  rc = CrFile();   if(rc) return(1);
  rc = Compile();  if(rc) return(1);
  rc = Link();     if(rc) return(1);
  rc = Call();     if(rc) return(1);

} else if(kw == "c++args") {
  if(tokens.size()==1) if(tokens[0]=="-?")
    {cout<<"c++args "<<GetArgs()<<endl; return(0);}
  FillArgs(tokens);

} else if(kw == "c++create") {
  if(tokens.size()<3) {
    cout<<"Usage: c++create file.cc func c++ user code ..."<<endl;
    return(1);
  }
  rc = FillUserCode(toks,2);        if(rc) return(1);
  rc = FillUserFctFrS();            if(rc) return(1);
  rc = CrFile(tokens[0],tokens[1]); if(rc) return(1);

} else if(kw == "c++createfrf") {
  if(tokens.size()<3) {
    cout<<"Usage: c++createfrf file.cc func fileuser.cc [fileuserfct.cc]"<<endl;
    return(1);
  }
  rc = FillUserCode(tokens[2]); if(rc) return(1);
  if(tokens.size()>3) rc = FillUserFctFrF(tokens[3]);
    else              rc = FillUserFctFrF(tokens[3]);
  if(rc) return(1);
  rc = CrFile(tokens[0],tokens[1]); if(rc) return(1);

} else if(kw == "c++compile") {
  if(tokens.size()>=1) rc = Compile(tokens[0]);
  else                 rc = Compile();
  if(rc) return(1);

} else if(kw == "c++link") {
  if(tokens.size()>=2)      rc = Link(tokens[0],tokens[1]);
  else if(tokens.size()>=1) rc = Link(tokens[0]);
  else                      rc = Link();
  if(rc) return(1);

} else if(kw == "c++include") {
  if(tokens.size()==1) if(tokens[0]=="-?")
    {cout<<"c++include "<<GetInclude()<<endl; return(0);}
  FillInclude(tokens);

} else if(kw == "c++compileopt") {
  if(tokens.size()==1) if(tokens[0]=="-?")
    {cout<<"c++compileopt "<<GetCompileOpt()<<endl; return(0);}
  FillCompileOpt(tokens);

} else if(kw == "c++linkopt") {
  if(tokens.size()==1) if(tokens[0]=="-?")
    {cout<<"c++linkopt "<<GetLinkOpt()<<endl; return(0);}
  FillLinkOpt(tokens);

} else if(kw == "c++mylibs") {
  if(tokens.size()==1) if(tokens[0]=="-?")
    {cout<<"c++mylibs "<<GetLinkLibs()<<endl; return(0);}
  FillLinkLibs(tokens);

} else if(kw == "c++prtlevel") {
  if(tokens.size()==1) if(tokens[0]=="-?")
    {cout<<"c++prtlevel prtlevel = "<<mPrtLevel<<endl; return(0);}
  if(tokens.size()>0) {
    int lp=atoi(tokens[0].c_str()); if(lp<0) lp=0;
    mPrtLevel=(uint_2) lp;
  } else mPrtLevel=2;

}

return(0);
}

/* --Methode-- */
int  CxxExecutor::ExecuteCXX(string usercode,string userfct)
{
int rc=0;
rc = FillUserCode(usercode,0); if(rc) return(1);
rc = FillUserFctFrS(userfct);  if(rc) return(1);
rc = CrFile();   if(rc) return(1);
rc = Compile();  if(rc) return(1);
rc = Link();     if(rc) return(1);
rc = Call();     if(rc) return(1);
return 0;
}

/* --Methode-- */
int CxxExecutor::CrFile(string cfilename,string func)
// Si un nom n'est pas precise alors TmpDir/cxx_spiapp.cc
{
if(cfilename.size()<1) cfilename = mDefTmp + mDefRoot + ".cc";

if(func.size()<1) func = mDefFunc;

ofstream os(cfilename.c_str(),ios::out);
if(!os)
  {cout<<"CxxExecutor::CrFile: unable to open "<<cfilename<<endl;
   return 1;}

PutInclude(os);
os<<endl;

PutIncludeUser(os);
os<<endl;

os<<"//-------------------------------------------------//"<<endl;
os<<"//----------------- User Functions ----------------//"<<endl;
os<<"//-------------------------------------------------//"<<endl;
if(mUserFctFn.size()>0) os<<"#include \""<<mUserFctFn<<"\""<<endl;
os<<endl;


os<<"extern \"C\" {"<<endl;
os<<"  int "<<func<<"( vector<string>& args );"<<endl;
os<<"}"<<endl<<endl;
os<<"int "<<func<<"( vector<string>& args )"<<endl;
os<<"{"<<endl;
os<<"// Some definitions to help using spiapp;"<<endl;
os<<"NamedObjMgr omg;"<<endl;
os<<"Services2NObjMgr& srvo = *omg.GetServiceObj();"<<endl;
os<<endl;

PutObject(os);
os<<endl;

PutVar(os);
os<<endl;

os<<"//--------------------------------------------//"<<endl;
os<<"//----------------- User Code ----------------//"<<endl;
os<<"//--------------------------------------------//"<<endl;
if(mUserCodeFn.size()>0) os<<"#include \""<<mUserCodeFn<<"\""<<endl;
os<<endl;

os<<"return 0;"<<endl;
os<<"}"<<endl;

if(mPrtLevel>1)
  cout<<"File "<<cfilename<<" for function "<<func<<" created :"<<endl;
if(mPrtLevel>1 && mUserCodeFn.size()>0)
  cout<<"  User code was in file "<<mUserCodeFn<<endl;
if(mPrtLevel>1 && mUserFctFn.size()>0)
  cout<<"  User function code was in file "<<mUserFctFn<<endl;
return 0;
}

/* --Methode-- */
void CxxExecutor::PutInclude(ofstream& os)
{
os<<"#include \"machdefs.h\""<<endl
  <<endl

  <<"//---- System et stdc++ include files"<<endl
  <<"#include <stdio.h>"<<endl
  <<"#include <stdlib.h>"<<endl
  <<"#include <math.h>"<<endl
  <<"#include <ctype.h>"<<endl
  <<"#include <string.h>"<<endl
  <<"#include <iostream.h>"<<endl
  <<"#include <fstream.h>"<<endl
  <<"#include <complex>"<<endl
  <<endl

  <<"#include <typeinfo>"<<endl
  <<"#include <string>"<<endl
  <<"#include <vector>"<<endl
  <<"#include <map>"<<endl
  <<"#include <functional>"<<endl
  <<"#include <list>"<<endl
  <<endl

  <<"//---- Sophya include files"<<endl
  <<"#include \"systools.h\""<<endl
  <<"#include \"ntools.h\""<<endl
  <<"#include \"array.h\""<<endl
  <<"#include \"histats.h\""<<endl
  <<endl

  <<"//---- Spiapp include files"<<endl
  <<"#include \"nobjmgr.h\""<<endl
  <<"#include \"servnobjm.h\""<<endl
  <<endl

  <<"#define KeepObj(obj) ___nomobj = #obj; omg.AddObj(obj,___nomobj);"<<endl
  <<"#define KeepVar(var) ___nomobj = #var; omg.GetVarList().Get(___nomobj) = var ;"<<endl
  <<endl;

return;
}

/* --Methode-- */
void CxxExecutor::PutIncludeUser(ofstream& os)
{
if(mIncList.size()<1) return;
for(uint_4 i=0;i<mIncList.size();i++)
  os<<"#include \""<<mIncList[i]<<"\""<<endl;
}

/* --Methode-- */
void CxxExecutor::PutObject(ofstream& os)
{
NamedObjMgr omg;
NObjMgrAdapter* objmgrad;
vector<string> objlist;
string patt = "*";
omg.GetObjList(patt,objlist); 
int nobjs = objlist.size();

os<<"//-------------- Object List --------------"<<endl;
os<<"//Number of objects = "<<nobjs<<endl;
os<<"string ___nomobj;"<<endl<<endl;
if(nobjs<=0) return;

string dir,nobj,stmp,obtype;
for(int i=0;i<nobjs;i++) {
  objmgrad = omg.GetObjAdapter(objlist[i]);
  omg.ParseObjectName(objlist[i],dir,nobj);
  obtype = objmgrad->GetDataObjType();
  stmp = "___" + nobj;

  os<<"___nomobj = \""<<nobj<<"\";"<<endl;
  os<<obtype<<"* "<<stmp
    <<" = dynamic_cast< "<<obtype<<" * >(omg.GetObj(___nomobj));"<<endl;
  os<<"if("<<stmp<<"==NULL) throw NullPtrError"
    <<"(\"CxxExecutor::PutObject: Non existing object "<<nobj
    <<"... please update file\");"<<endl;
  os<<obtype<<"& "<<nobj<<" = (*"<<stmp<<");"<<endl<<endl;
}

return;
}

/* --Methode-- */
void CxxExecutor::PutVar(ofstream& os)
{  
os<<"//-------------- Variable List --------------"<<endl;
NamedObjMgr omg;
DVList& varlist = omg.GetVarList();
// varlist.Show(); varlist.Print();  
DVList::ValList::const_iterator it;
for(it=varlist.Begin(); it!=varlist.End(); it++) {
  string key = (*it).first;
  if (isalpha(key[0]) ) {
    os<<"___nomobj = \""<<key<<"\";"<<endl;
    os<<"MuTyV & $"<<key<<" = omg.GetVarList().Get(___nomobj);"<<endl;
  }
}

return;
}

/* --Methode-- */
int CxxExecutor::FillUserCode(string& usercode,uint_4 first)
// User code is read from input.
// - first is the first position in the "string" where the code starts
// - Code is put into file "TmpDir/cxx_spiapp.h".
{
mUserCodeFn = "";

// get the string part which is after word "first"
string code = usercode;
if(code.size()<=0) {cout<<"CxxExecutor::FillUserCode: no user code"<<endl;
                    return 1;}
size_t q;
for(uint_4 i=0;i<=first;i++) {
  q = code.find_first_not_of(" \t");
  if(q>=code.size()) {code=""; break;}
  code = code.substr(q);
  if(i==first) break;
  q = code.find_first_of(" \t");
  if(q>=code.size()) {code=""; break;}
  code = code.substr(q);
}
if(code.size()<=0)
  {cout<<"CxxExecutor::FillUserCode: no user code after "<<first<<endl;
   return 1;}

// Fill the file with user code
mUserCodeFn = mDefTmp + mDefRoot + ".h";
ofstream os(mUserCodeFn.c_str(),ios::out);
if(!os) {cout<<"CxxExecutor::FillUserCode: unable to open "
             <<mUserCodeFn<<endl;  mUserCodeFn = ""; return 1;}
os<<code<<endl;
if(mPrtLevel>1)
  cout<<"User code filled from standard input into "<<mUserCodeFn<<endl;
return 0;
}

/* --Methode-- */
int CxxExecutor::FillUserFctFrS(string userfctcode)
// - Fill user Fonction code from string "userfct"
// - Code is put into file "TmpDir/cxx_spiapp_fct.h".
{
mUserFctFn  = "";
if(userfctcode.size()<1) return 0;
mUserFctFn  = mDefTmp + mDefRoot + "_fct.h";
ofstream os(mUserFctFn.c_str(),ios::out);
if(!os) {cout<<"CxxExecutor::FillUserFctFrS: unable to open "
             <<mUserFctFn<<endl;  mUserFctFn = ""; return 1;}
os<<userfctcode<<endl;
if(mPrtLevel>1)
  cout<<"User Function code filled from standard input into "<<mUserFctFn<<endl;
return 0;
}

/* --Methode-- */
int CxxExecutor::FillUserCode(string filename)
// User code is read from "filename".
{
mUserCodeFn = filename;
if(mPrtLevel>1 && mUserCodeFn.size()>0)
  cout<<"User code filled from file "<<mUserCodeFn<<endl;
return 0;
}

/* --Methode-- */
int CxxExecutor::FillUserFctFrF(string filefctname)
// User function code is read from "filefctname".
{
mUserFctFn = filefctname;
if(mPrtLevel>1 && mUserFctFn.size()>0)
  cout<<"User Function code filled from file "<<mUserFctFn<<endl;
return 0;
}

/* --Methode-- */
int CxxExecutor::Compile(string rootfilename)
//--------------------------------------------------------//
// rootfilename = | name           | "" ou (default)      //
//--------------------------------------------------------//
// fichier .cc    | name.cc        | TmpDir/cxx_spiapp.cc //
//                | ../dir/name.cc |                      //
// fichier .o     | TmpDir/name.o  | TmpDir/cxx_spiapp.o  //
// fichier .so    | TmpDir/name.so | TmpDir/cxx_spiapp.so //
//--------------------------------------------------------//
{
if(rootfilename.size()<1) rootfilename = mDefTmp + mDefRoot;
if(mPrtLevel>1) cout<<"Compile "<<rootfilename<<endl;

int rc;
CxxCompilerLinker cxx;
if(mDefTmp.size()>0) cxx.SetTmpDir(mDefTmp);
if(mPrtLevel>0) cxx.SetVerbose(true);
  else          cxx.SetVerbose(false);

// Compilation
string fcc = rootfilename + ".cc";
string fo  = "";
cxx.AddCompileOptions(mCompOpt);
rc = cxx.Compile(fcc,fo);
if(mPrtLevel>1) cout << "Compilation rc = "<<rc<< endl;
if(rc) return 1;

// Fabrication Shared Lib.
string fso = "";
cxx.AddLinkOptions(mLinkOpt);
#ifdef SANS_EVOLPLANCK
  string sophlib = "-lPIE";
#else
  string sophlib = "-lPI";
#endif
cxx.AddLinkOptions(sophlib);
cxx.AddLinkOptions(mMyLibs);
rc = cxx.BuildSO(fo,fso);
if(mPrtLevel>1) cout << "Shared Library rc = "<<rc<< endl;
if(rc) return 2;

return 0;
}

/* --Methode-- */
//int CxxExecutor::Compile(string rootfilename)
// Ne marche pas si TmpDir != ""
//{
//if(rootfilename.size()<1) rootfilename = mDefRoot;
//if(mPrtLevel>1) cout<<"Compile: "<<rootfilename<<endl;
//int rc = 0;
//rc = CrMakefile();
//if(rc) return(1);
//string make  = "";
//make += "make -f " + mDefRoot + "_Makefile";
//make += " CXXFLAGS=\"" + mCompOpt + "\"";
//make += " LDFLAGS=\""  + mLinkOpt + "\"";
//make += " MYLIBS=\""   + mMyLibs  + "\"";
//make += " " + rootfilename;
//rc = system(make.c_str());
//if(rc)
//  {cout<<"CxxExecutor::Compile : \n"<<make<<" Failed"<<endl;
//   return 1000+rc;}
//return 0;
//}

/* --Methode-- */
//int CxxExecutor::CrMakefile(void)
// Ne marche pas si TmpDir != ""
//{
//string makename = mDefTmp + mDefRoot + "_Makefile";
//ofstream os(makename.c_str(),ios::out);
//if(!os)
//  {cout<<"CxxExecutor::CrMakefile: unable to open file for Makefile"<<endl;
//   return 1;}
//---------------------------------------------------------------------
//os<<"MODULEDECCXXFLAGS := -msg_quiet"<<endl;
//os<<"include $(DPCBASEREP)/Include/MakefileUser.h"<<endl;
//os<<"MYLIBS ="<<endl;
//os<<"LIBS = -L$(SLB) -lPI -lextsophya -lsophya -lm"<<endl;
//os<<"ifeq ($(MACHEROS),OSF1)"<<endl;
//os<<"LIBS := $(LIBS) -lfor"<<endl;
//os<<"endif"<<endl;
//os<<"ifeq ($(MACHEROS),Linux)"<<endl;
//os<<"LIBS := $(LIBS) -ldl -lf2c"<<endl;
//os<<"endif"<<endl;
//os<<"%.so:%.o"<<endl;
//os<<"%:%.cc"<<endl;
//os<<"%:%.o"<<endl;
//os<<"%.o:%.cc"<<endl;
//os<<"%.o:%.c"<<endl;
//os<<"%:%.c"<<endl;
//os<<endl;
//os<<".PRECIOUS: %.so"<<endl;
//os<<endl;
//os<<"%:%.so"<<endl;
//os<<"\t"<<"echo $@ \" made (.so) \""<<endl;
//os<<"%.so:%.o"<<endl;
//os<<"\t"<<"$(LINK.cc) -shared -o $@ $< $(LIBS) $(MYLIBS)"<<endl;
//os<<"%.o:%.cc"<<endl;
//os<<"\t"<<"$(COMPILE.cc) -o $@ $<"<<endl;
//os<<"%.o:%.c"<<endl;
//os<<"\t"<<"$(COMPILE.c) -c $(CFLAGS) $(USERFLAGS) -o $@ $<"<<endl;
//---------------------------------------------------------------------
//return 0;
//}

/* --Methode-- */
int CxxExecutor::Link(string libname,string func)
{
if(libname.size()<1) libname = mDefTmp + mDefRoot + ".so";
  else               libname = mDefTmp + libname;
if(func.size()<1) func = mDefFunc;

NamedObjMgr omg;
PIACmd* mpiac = omg.GetImgApp()->CmdInterpreter();

string key("linkff2");
vector<string> arg; arg.push_back(libname); arg.push_back(func);
string toks = libname + " " + func;
int rc = mpiac->ExecuteCommand(key,arg,toks);
if(mPrtLevel>1) cout<<"Link from "<<libname<<" for function "<<func
                  <<" (rc="<<rc<<")"<<endl;
return 0;
}

/* --Methode-- */
int CxxExecutor::Call(string func)
{
if(func.size()<1) func = mDefFunc;

NamedObjMgr omg;
PIACmd* mpiac = omg.GetImgApp()->CmdInterpreter();

string key("call");
vector<string> arg; arg.push_back(func);
string toks = func;
if(mCallArgs.size()>0)
  for(uint_4 i=0;i<mCallArgs.size();i++) arg.push_back(mCallArgs[i]);
mpiac->ExecuteCommand(key,arg,toks);
return 0;
}

/* --Methode-- */
void CxxExecutor::FillArgs(vector<string>& args)
{
mCallArgs.resize(0);
if(args.size()<1) return;
for(uint_4 i=0;i<args.size();i++) mCallArgs.push_back(args[i]);
}

void CxxExecutor::FillArgs(string& args)
{
mCallArgs.resize(0);
FillVStringFrString(args,mCallArgs,' ');
}

string CxxExecutor::GetArgs(void)
{
string dum = "";
if(mCallArgs.size()<1) return dum;
for(uint_4 i=0;i<mCallArgs.size();i++) dum += mCallArgs[i] + " ";
return dum;
}

/* --Methode-- */
void CxxExecutor::FillInclude(vector<string>& inc)
{
mIncList.resize(0);
if(inc.size()<1) return;
for(uint_4 i=0;i<inc.size();i++) mIncList.push_back(inc[i]);
}

void CxxExecutor::FillInclude(string& inc)
{
mIncList.resize(0);
FillVStringFrString(inc,mIncList,' ');
}

string CxxExecutor::GetInclude(void)
{
string dum = "";
if(mIncList.size()<1) return dum;
for(uint_4 i=0;i<mIncList.size();i++) dum += mIncList[i] + " ";
return dum;
}

/* --Methode-- */
void CxxExecutor::FillCompileOpt(vector<string>& copt)
{
mCompOpt = "";
if(copt.size()<1) return;
for(uint_4 i=0;i<copt.size();i++) mCompOpt += copt[i] + " ";
}

void CxxExecutor::FillCompileOpt(string& copt)
{
mCompOpt = copt;
}

string CxxExecutor::GetCompileOpt(void)
{
return mCompOpt;
}

/* --Methode-- */
void CxxExecutor::FillLinkOpt(vector<string>& lopt)
{
mLinkOpt = "";
if(lopt.size()<1) return;
for(uint_4 i=0;i<lopt.size();i++) mLinkOpt += lopt[i] + " ";
}

void CxxExecutor::FillLinkOpt(string& lopt)
{
mLinkOpt = lopt;
}

string CxxExecutor::GetLinkOpt(void)
{
return mLinkOpt;
}

/* --Methode-- */
void CxxExecutor::FillLinkLibs(vector<string>& llibs)
{
mMyLibs = "";
if(llibs.size()<1) return;
for(uint_4 i=0;i<llibs.size();i++) mMyLibs += llibs[i] + " ";
}

void CxxExecutor::FillLinkLibs(string& llibs)
{
mMyLibs = llibs;
}

string CxxExecutor::GetLinkLibs(void)
{
return mMyLibs;
}
