#include "pexceptions.h"
#include "fitsxntuple.h"
///////////////////////////////////////////////////////////
//   Les objets delegues pour la gestion de persistance sur fichiers fits 
//    pout XNTuple
///////////////////////////////////////////////////////////


#define LONNOM 31 


FITS_XNTuple::FITS_XNTuple()
{
  dobj_ = new XNTuple;
  InitNull();
  ownobj_ = true;
}

FITS_XNTuple::FITS_XNTuple(char inputfile[],int hdunum)
{
  dobj_ = new XNTuple;
  InitNull();
  ownobj_ = true; 

  Read(inputfile,hdunum);
}


FITS_XNTuple::FITS_XNTuple(const XNTuple & obj) 
{ 
  dobj_ = new XNTuple(obj);
  InitNull();
  ownobj_ = true; 
}
FITS_XNTuple::FITS_XNTuple(XNTuple* obj) 
{ 
  dobj_ = obj;
  InitNull();
  ownobj_ = false; 
}
FITS_XNTuple::~FITS_XNTuple()
{
  if (ownobj_ && dobj_ != NULL) delete dobj_;
}


void FITS_XNTuple::ReadLines(char inputfile[],int firstLine, int numberOfLines,int hdunum)
{
  fistLineToBeRead_ = firstLine;
  numberOfLinesToBeRead_ = numberOfLines;
  Read(inputfile,hdunum);
}


 
void FITS_XNTuple::ReadFromFits(FitsInFile& is)
{   
  if (!is.IsFitsTable())
    {
      throw PException("ReadFromFits: the fits file seems not to be a bintable nor ASCII table");
    }
  int nbcols, nbentries;
  nbcols = is.NbColsFromFits();
  nbentries = 0;
  int k;
  for (k=0; k<nbcols; k++) nbentries=max( nbentries, is.NentriesFromFits(k) );

  //
  // pour mettre les colonnes dans l'ordre double, float, int, char :
  // tableau de correspondance 
  // DfitsCol(j)= numero dans le fichier fits de la  jeme variable double du 
  // xntuple;
  // FfitsCol(j)= numero dans le fichier fits de la  jeme variable float du 
  // xntuple;
  // etc.
  vector<int> DfitsCol;
  vector<int> FfitsCol;
  vector<int> IfitsCol;
  vector<int> SfitsCol;
  for (k=0; k<nbcols;k++)
    {
      FitsFile::FitsDataType ss= is.ColTypeFromFits(k);
      if (ss == FitsFile::FitsDataType_double) DfitsCol.push_back(k);
      else if (ss == FitsFile::FitsDataType_float) FfitsCol.push_back(k);
      else if (ss == FitsFile::FitsDataType_int) IfitsCol.push_back(k);
      else if (ss == FitsFile::FitsDataType_char) SfitsCol.push_back(k);
      else {
	cout << " FITS_XNTuple: colonne fits " << k << " type= " << ss << endl;
	throw  IOExc("type de champ inconnu");
      }
    }
  char ** ColName = new char*[nbcols];
  int compt=0;
  for (k=0; k<DfitsCol.size(); k++)
    {
      ColName[compt] = new char[LONNOM+1]; 
      strncpy(ColName[compt], is.ColNameFromFits(DfitsCol[k]).c_str(), LONNOM);
      ColName[compt++][ LONNOM] =  '\0';
    }
  for (k=0; k<FfitsCol.size(); k++)
    {
      ColName[compt] = new char[LONNOM+1]; 
      strncpy(ColName[compt], is.ColNameFromFits(FfitsCol[k]).c_str(), LONNOM);
      ColName[compt++][ LONNOM] =  '\0';
    }
  for (k=0; k<IfitsCol.size(); k++)
    {
      ColName[compt] = new char[LONNOM+1]; 
      strncpy(ColName[compt], is.ColNameFromFits(IfitsCol[k]).c_str(), LONNOM);
      ColName[compt++][ LONNOM] =  '\0';
    }
  for (k=0; k<SfitsCol.size(); k++)
    {
      ColName[compt] = new char[LONNOM+1]; 
      strncpy(ColName[compt], is.ColNameFromFits(SfitsCol[k]).c_str(), LONNOM);
      ColName[compt++][LONNOM] =  '\0';
    }

  if(dobj_ == NULL) 
    { 
      dobj_= new XNTuple(DfitsCol.size(), FfitsCol.size(), IfitsCol.size(), SfitsCol.size(),ColName);
      ownobj_ = true;      
    }
  else 
    {
      if (ownobj_)
	{
	  (*dobj_)= XNTuple(DfitsCol.size(), FfitsCol.size(), IfitsCol.size(), SfitsCol.size(),ColName);
	}
      else
	{
	  if (DfitsCol.size() != dobj_->NDVar() || FfitsCol.size() != dobj_->NFVar() ||  IfitsCol.size() != dobj_->NIVar() || SfitsCol.size() != dobj_->NSVar())
	    {
	      cout << " WARNING : FITS_XNTuple : XNTuple reconfigured " << endl;
	      (*dobj_)= XNTuple(DfitsCol.size(), FfitsCol.size(), IfitsCol.size(), SfitsCol.size(),ColName);
	    }
	}
    }

  for (k=0; k<nbcols;k++) 
    {
      delete [] ColName[k];
    }
  delete [] ColName;

    double* dligne;
    float* fligne;
    int* iligne;
    char** cligne;

  if (DfitsCol.size()>0) dligne = new double[DfitsCol.size()];
  else dligne=NULL;
  if (FfitsCol.size()>0) fligne = new float[FfitsCol.size()];
  else fligne=NULL;
  if (IfitsCol.size()>0) iligne = new int[IfitsCol.size()];
  else iligne=NULL;
  if (SfitsCol.size()>0) 
    {
      cligne = new char*[SfitsCol.size()];
      int  taille_des_chaines=0;
      for (k=0; k< SfitsCol.size(); k++)  taille_des_chaines = max( taille_des_chaines, is.ColStringLengthFromFits(SfitsCol[k]) );
      for (k=0; k<SfitsCol.size(); k++) cligne[k]=new char[taille_des_chaines+1];
    }
  else cligne=NULL;
  int firstln, lastln;
  if (numberOfLinesToBeRead_ > 0) 
    {
      firstln = fistLineToBeRead_;
      lastln = firstln + numberOfLinesToBeRead_;
    }
  else
    {
      firstln = 0;
      lastln  = nbentries;
    }
  int numLigne;
  for (numLigne=firstln; numLigne < lastln; numLigne++)
    {
      is.GetBinTabLine(numLigne, dligne, fligne, iligne, cligne );
      dobj_->Fill((r_8*)dligne, (r_4*)fligne, (int_4*)iligne, cligne);    
    }
    delete [] dligne;
    delete [] fligne;
    delete [] iligne;
    for (k=0; k< SfitsCol.size(); k++) delete []  cligne[k];
    delete [] cligne; 
  dobj_->Info()=is.DVListFromFits();

}
void FITS_XNTuple::WriteToFits(FitsOutFile& os) 
{
  if(dobj_ == NULL) 
    {
      cout << " WriteToFits:: dobj_= null " << endl;
      return;
    }

  // table will have 'ncols'  columns
  int ncols = dobj_->NVar(); 
  // table will have 'nrows' rows
  int nrows = dobj_->NEntry();
  // get names and values from the join DVList object
  DVList dvl= dobj_->Info();
  // extension name
  string extname("XNTuple_Binary_tbl"); 
  vector<string> Noms(ncols);   
  int k;
  for (k=0; k< ncols; k++)
    {
      Noms[k] = dobj_->NomIndex(k) ;
    }
  string types;
  for (k=0; k<dobj_->NDVar();k++)
    {
      types+='D';
    }
  for (k=0; k<dobj_->NFVar();k++)
    {
      types+='E';
    }
  for (k=0; k<dobj_->NIVar();k++)
    {
      types+='I';
    }
  for (k=0; k<dobj_->NSVar();k++)
    {
      types+='A';
    }            
  vector<int> StringSizes(dobj_->NSVar());
  for (k=0; k< StringSizes.size(); k++) StringSizes[k]=dobj_->mStrSz;
  dvl["Content"]= "XNTuple";
  dvl.SetComment("Content", "name of SOPHYA object");
  os.makeHeaderBntblOnFits(types, Noms, nrows, ncols, &dvl, extname,StringSizes); 
   
  int compt=0; 
   if (dobj_->NDVar() > 0) 
     {
       double* dcolumn = new double[nrows];
       for (k=0; k<dobj_->NDVar();k++)
	 {
	   for(int j = 0; j < nrows; j++) dcolumn[j]= dobj_->GetDVal(j,compt);
	   os.PutColToFits(compt, nrows, dcolumn);
	   compt++;
	 }
       delete [] dcolumn;
     }

   if (dobj_->NFVar() > 0)
     {
       float* fcolumn = new float[nrows];
       for (k=0; k<dobj_->NFVar();k++)
	 {
	   for(int j = 0; j < nrows; j++) fcolumn[j]= dobj_->GetFVal(j,compt);
	   os.PutColToFits(compt, nrows, fcolumn);
	   compt++;
	 }
       delete [] fcolumn;
     }

   if (dobj_->NIVar() > 0)
     { 
       int* icolumn = new int[nrows];
       for (k=0; k<dobj_->NIVar();k++)
	 {
	   for(int j = 0; j < nrows; j++) icolumn[j]= dobj_->GetIVal(j,compt);
	   os.PutColToFits(compt, nrows, icolumn);
	   compt++;
	 }
       delete [] icolumn;
     }

   if (dobj_->NSVar() > 0)
     {
      char**  ccolumn = new char*[nrows];
      for (k=0; k<dobj_->NSVar();k++)
	{
	  int j;
	  for(j = 0; j < nrows; j++)
	    {
	      string s= dobj_->GetSVal(j,compt);
	      ccolumn[j] = new char[dobj_->mStrSz+1];
	      strcpy(ccolumn[j],s.c_str());
	    }
	  os.PutColToFits(compt, nrows, ccolumn);
	  compt++;
	  for(j = 0; j < nrows; j++)
	    {
	      delete [] ccolumn[j];
	      ccolumn[j] = NULL;
	    }

	}
      delete [] ccolumn;
     }
}
