#include "pexceptions.h"
#include "fitsautoreader.h"
#include "dvlist.h"

///////////////////////////////////////////////////////////////////////
// ---- gestion de persistance I/O format fits--
// objets
////////////////////////////////////////////////////////////////////

FITS_AutoReader::FITS_AutoReader() {InitNull();};
FITS_AutoReader::FITS_AutoReader(const char inputfile[])
{
  InitNull();
  inFits_  = new FitsInFile (inputfile);
}
FITS_AutoReader::FITS_AutoReader(string const & inputfile)
{
  InitNull();
  inFits_  = new FitsInFile (inputfile);
}
FITS_AutoReader::~FITS_AutoReader()
{
  if (inFits_ != NULL) delete inFits_;
  if (dobj_ != NULL) delete dobj_;
}


AnyDataObj* FITS_AutoReader::ReadObject(int hdunum) const
{
  inFits_->ReadHeader(hdunum);
  DVList dvl=inFits_->DVListFromFits();
  string nameObj = dvl.GetS("CONTENT");
  cout << " SOPHYA object identified as: " << dvl.GetS("CONTENT") << endl;
  if (nameObj == string("TArray") )
    {
      return newTArray();
    }
  else if  (nameObj == string("SphereHEALPix") )
    {
      return newSphereHEALPix();
    }
  else if  (nameObj == string("LocalMap") )
    {
      return newLocalMap();
    }
  else if  (nameObj == string("NTuple") )
    {
      return newNTuple();
    }
  else if  (nameObj == string("XNTuple") )
    {
      return newXNTuple();
    }
  // on n'a trouve aucun nom d'objet connu de SOPHYA, on fait une 
  // recherche qualitative.
  //
  // si c'est une image fits, on cree un TArray
  else if (inFits_->IsFitsImage())
    {
      return newTArray();
    }
  // si c'est une bintable on cherche le mot cle ORDERING pour identifier 
  // une spherehelpix
  else if (inFits_->IsFitsTable())
    {
      if (dvl.GetS("ORDERING") != string("")) return newSphereHEALPix();
      // sinon on cherche ntuple ou xntuple
      else
	{
	  int index=0;
	  for (int k=0; k < inFits_->NbColsFromFits(); k++) 
	    {
	      if (inFits_->ColTypeFromFits(k) != FitsFile::FitsDataType_float)
		{
		index = 1;
		break;
	      }
	  }
	if (index == 0)  return newNTuple();
	else return newXNTuple();
      }
    }
  else
    {
      throw IOExc("FITS_AutoReader::ReadObject : object not recognized as a  SOPHYA object");
    }
  
}

AnyDataObj*  FITS_AutoReader::newTArray() const
{
      FitsFile::FitsDataType dtype = inFits_->ImageType();
      switch (dtype)
	{
	case FitsFile::FitsDataType_double :
	  {
	    TArray<r_8>* matptr = new TArray<r_8>;
	    FITS_TArray<r_8> fta(matptr);
	    fta.Read(*inFits_, inFits_->currentHeaderIndex());
	    return matptr;
	  }
	case FitsFile::FitsDataType_float :
	  {
	    TArray<r_4>* matptr = new TArray<r_4>;
	    FITS_TArray<r_4> fta(matptr);
	    fta.Read(*inFits_,  inFits_->currentHeaderIndex());
	    return matptr;
	  }
	case  FitsFile::FitsDataType_int :
	  {
	    TArray<int_4>* matptr = new TArray<int_4>;
	    FITS_TArray<int_4> fta(matptr);
	    fta.Read(*inFits_,  inFits_->currentHeaderIndex());
	    return matptr;
	  }
	default :
	  cout << "type = " << dtype << endl;
	  throw IOExc("FITS_AutoReader::ReadObject : unsupported data type for TArray");
	}
}

AnyDataObj*  FITS_AutoReader::newSphereHEALPix() const
{
      FitsFile::FitsDataType dtype;
      if (inFits_->IsFitsTable()) dtype = inFits_->ColTypeFromFits(0);
      else
	{
	  cout << " WARNING : Sperehealpix not binary table : unusual " << endl;
	  dtype = inFits_->ImageType();
	}
      switch (dtype)
	{
	case FitsFile::FitsDataType_double :
	  {
	    SphereHEALPix<r_8>* sphptr = new SphereHEALPix<r_8>;
	    FITS_SphereHEALPix<r_8> fta(sphptr);
	    fta.Read(*inFits_,  inFits_->currentHeaderIndex());
	    return sphptr;
	  }
	case FitsFile::FitsDataType_float :
	  {
	    SphereHEALPix<r_4>* sphptr = new SphereHEALPix<r_4>;
	    FITS_SphereHEALPix<r_4> fta(sphptr);
	    fta.Read(*inFits_,  inFits_->currentHeaderIndex());
	    return sphptr;
	  }
	case  FitsFile::FitsDataType_int :
	  {
	    SphereHEALPix<int_4>* sphptr = new SphereHEALPix<int_4>;
	    FITS_SphereHEALPix<int_4> fta(sphptr);
	    fta.Read(*inFits_,  inFits_->currentHeaderIndex());
	    return sphptr;
	  }
	default :
	  cout << "type = " << dtype << endl;
	  throw IOExc("FITS_AutoReader::ReadObject : unsupported data type for SphereHEALpix");
	}
}

AnyDataObj*  FITS_AutoReader::newLocalMap() const
{
      FitsFile::FitsDataType dtype;
      if (inFits_->IsFitsTable()) dtype = inFits_->ColTypeFromFits(0);
      else
	{
	  cout << " WARNING : Localmap not binary table : unusual " << endl;
	  dtype = inFits_->ImageType();
	}
      switch (dtype)
	{
	case FitsFile::FitsDataType_double :
	  {
	    LocalMap<r_8>* locmptr = new LocalMap<r_8>;
	    FITS_LocalMap<r_8> fta(locmptr);
	    fta.Read(*inFits_,  inFits_->currentHeaderIndex());
	    return locmptr;
	  }
	case FitsFile::FitsDataType_float :
	  {
	    LocalMap<r_4>* locmptr = new LocalMap<r_4>;
	    FITS_LocalMap<r_4> fta(locmptr);
	    fta.Read(*inFits_,  inFits_->currentHeaderIndex());
	    return locmptr;
	  }
	case  FitsFile::FitsDataType_int :
	  {
	    LocalMap<int_4>* locmptr = new LocalMap<int_4>;
	    FITS_LocalMap<int_4> fta(locmptr);
	    fta.Read(*inFits_,  inFits_->currentHeaderIndex());
	    return locmptr;
	  }
	default :
	  cout << "type = " << dtype << endl;
	  throw IOExc("FITS_AutoReader::ReadObject : unsupported data type for LocalMap");
	}
}
NTuple* FITS_AutoReader::newNTuple() const
{
      NTuple* ntptr = new NTuple;
      FITS_NTuple fta(ntptr);
      fta.Read(*inFits_,  inFits_->currentHeaderIndex());
      return ntptr;
}
XNTuple* FITS_AutoReader::newXNTuple() const
{
      XNTuple* xntptr = new XNTuple;
      FITS_XNTuple fta(xntptr);
      fta.Read(*inFits_,  inFits_->currentHeaderIndex());
      return xntptr;
}

