#ifndef FITSAUTOREADER_SEEN
#define FITSAUTOREADER_SEEN


// Guy Le Meur 11/2000

#include "machdefs.h"
#include "anydataobj.h"
#include "fitsfile.h"
#include "fitstarray.h"
#include "fitsspherehealpix.h"
#include "fitsntuple.h"
#include "fitsxntuple.h"
#include "fitslocalmap.h"

namespace SOPHYA {
///////////////////////////////////////////////////////////////////////
// ------------- Classe pour la gestion de persistance I/O format fits--
// des objets
//////////////////////////////////////////////////////////////////////


class FITS_AutoReader 
{
public:

FITS_AutoReader();
FITS_AutoReader(const char inputfile[]);
FITS_AutoReader(string const & inputfile);
virtual ~FITS_AutoReader();
AnyDataObj* ReadObject(int hdunum = 0) const;


private :

AnyDataObj* newTArray() const;
AnyDataObj* newSphereHEALPix() const;
AnyDataObj* newLocalMap() const;
NTuple* newNTuple() const;
XNTuple* newXNTuple() const;
inline void InitNull()
   {
     inFits_ = NULL;
     dobj_ = NULL;
     ownobj_ = false;
   }

FitsInFile* inFits_;
AnyDataObj* dobj_;
bool ownobj_;

};
} // Fin du namespace

#endif
