#include <stdio.h>

#include <LString.h>
#include "pibwdgmac.h"
#include "piupdattachment.h"
#include <algobase.h>
#include <string.h>

#define mGraphic mWGrC  

// Les methodes de la classe  PIBWdgGen
 
/* --Methode-- */
PIBaseWdgMac::PIBaseWdgMac(PIContainerGen *par, char *nom,
                       int sx, int sy, int px, int py) :
PIBaseWdgGen(par, nom, sx, sy, px, py) 
{
    mGraphic = new PIGraphicMac(this);

    mAdapter->AddAttachment(new PIUpdAttachment(this));
    mPane->AddAttachment(new PIUpdAttachment(this));
    cursor = NULL;
    

}


/* --Methode-- */
PIBaseWdgMac::~PIBaseWdgMac()
{
}

/* --Methode-- */
void PIBaseWdgMac::ActivatePtrCross()
{
// toujours actif pour le moment
}

/* --Methode-- */
void PIBaseWdgMac::ActivateButton(int /*bid*/)
{
}

/* --Methode-- */
void PIBaseWdgMac::ActivateMove(int /*bid*/)
{
}

/* --Methode-- */
void PIBaseWdgMac::ActivateKeyboard()
{
}

/* --Methode-- */
void PIBaseWdgMac::EraseWindow(int x0, int y0, int dx, int dy)
{
  if (mPane->FocusDraw()) {
     GrafPtr p = mPane->GetMacPort();
     if (p) EraseRgn(p->visRgn);
//	   Rect r;
//	   mPane->CalcPortFrameRect(r);
//       EraseRect(&r);
  }
}



/* --Methode-- */
void PIBaseWdgMac::SelPointerShape(PIPointer ptr)
{
  CursHandle c;
  if (mPane->FocusDraw()) {
    switch(ptr) {
      case PI_ArrowPointer:
        cursor = &qd.arrow;
        break;
      case PI_CrossPointer:
        c = GetCursor(crossCursor);
        HLock((Handle)c);
        cursor = c ? *c : NULL;
        break;
      case PI_HandPointer:
        c = GetCursor(128);
        HLock((Handle)c);
        cursor = c ? *c : NULL;
        break;
    }
  }
  mPtrS = ptr;
}



/* --Methode-- */
PIPointer  PIBaseWdgMac::GetPointerShape()
{
return (mPtrS);
}



/* --Methode-- */
bool PIBaseWdgMac::AdjustCursor()
{
  if (cursor) {
    ::SetCursor(cursor);
    return true;
  }
  return false;
}

/* --Methode-- 
void PIBaseWdgMac::Refresh()
{
if (mPane->IsVisible())
  Draw();
}
   J'ai mis cette fonction ds PIWdgMac::IsVisible()    Reza $CHECK$  01/12/97 
*/



void PIBaseWdgMac::SetBackgroundColor(PIColors col)
{
  if (mPane->FocusDraw()) {
    long color;
    switch (col) {
      case PI_Black:
        color = blackColor;
        break;
      case PI_White:
        color = whiteColor;
        break;
      case PI_Red:
        color = redColor;
        break;
      case PI_Blue:
        color = blueColor;
        break;
      case PI_Green:
        color = greenColor;
        break;
      case PI_Yellow:
        color = yellowColor;
        break;
      default:
        color = blackColor;
    }
    mBCol = col;
    ::BackColor(color);
  }
}

PIColors  PIBaseWdgMac::GetBackgroundColor() 
{
return (mBCol);
}
