#ifndef PISTDWDGMAC_H_SEEN
#define PISTDWDGMAC_H_SEEN

#include "pistdwdggen.h"


class PILabelMac : public PILabelGen
{
public:
                     PILabelMac(PIContainerGen *par, char *nom,
                                 int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PILabelMac();
};

class PIButtonMac : public PIButtonGen
{
public:
                     PIButtonMac(PIContainerGen *par, char *nom, PIMessage msg = PIMsg_Click,
                                 int sx=10, int sy=10, int px=0, int py=0,
                                 PIBtnSign bsgn = PIBtn_Label);
  virtual           ~PIButtonMac();
  virtual void	     ListenToMessage(MessageT inMessage, void *ioParam);
  virtual void       ActivatePress(bool=false) {}
};

class PITextMac : public PITextGen
{
public:
                     PITextMac(PIContainerGen *par, char *nom,
                               int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PITextMac();

  virtual void       SetMutiLineMode(bool mlm=false);
  virtual void       SetTextEditable(bool te=true);

  virtual void       SetText(string const&);
  virtual string     GetText() const;
};

class PIScaleMac : public PIScaleGen
{
public:
                     PIScaleMac(PIContainerGen* par, char* nom, 
                                PIMessage msg=PIMsg_DataChanged, bool horiz=true,
                                int sx=100, int sy=10, int px=0, int py=0);
                    ~PIScaleMac();

  virtual void       SetMinMax(int min, int max);
  virtual void       SetValue(int val);
  virtual int        GetValue(); 
  virtual void	     ListenToMessage(MessageT inMessage, void *ioParam);
  virtual void	     HandleScroll(const Int16 inPart);
  
protected:
  static pascal void SBarAction(ControlHandle inMacControl,
								Int16 inPart);
};

class PIScrollBarMac : public PIScrollBarGen
{
public:
                     PIScrollBarMac(PIContainerGen* par, char* nom, 
                                PIMessage msg=PIMsg_DataChanged, bool vert=true,
                                int sx=100, int sy=10, int px=0, int py=0);
                    ~PIScrollBarMac();

  virtual void       ActivateDrag(bool /*acd*/=false) {};
  virtual void       SetMinMax(int min, int max);
  virtual void       SetValue(int val);
  virtual int        GetValue(); 
  virtual void	     ListenToMessage(MessageT inMessage, void *ioParam);
  virtual void	     HandleScroll(const Int16 inPart);
  virtual void       SetSlSize(int sz) {msz = sz;}
  virtual int        GetSlSize() {return msz;}
protected:
  static pascal void SBarAction(ControlHandle inMacControl,
								Int16 inPart);
  int msz;
};


class PICheckBoxMac : public PICheckBoxGen
{
public:
                     PICheckBoxMac(PIContainerGen* par, char* nom, 
                                   PIMessage msg = PIMsg_Click,
                                   int sx=10, int sy=10, int px=0, int py=0);
  virtual           ~PICheckBoxMac();
  virtual void	     ListenToMessage(MessageT inMessage, void *ioParam);
  virtual void       SetState(bool st=false);
  virtual bool       GetState();
};


 
typedef PILabelMac   PILabel;
typedef PIButtonMac  PIButton;
typedef PITextMac    PIText;
typedef PIScaleMac   PIScale;
typedef PIScrollBarMac PIScrollBar;
typedef PICheckBoxMac PICheckBox;

#endif
