#if 0
/* Fonctions interface XWindow pour affichage d'images */
/*                  Reza   05/95                       */

/*                  LAL (Orsay) / IN2P3-CNRS           */

#include <stdlib.h>
#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "xdispim.h"

/*  Variables globales pour  */

static int RzXwDispImg = 0;
static Display * display;
static int screen;
static GC defgc;
static RzXCMap rzxcmap[5];
static int rzxgcok = 0;
static Font fonts[5];

static int NbRzXw = 0;


/*  Fin des variables globales   */


/* Nouvelle-Fonction */
int RzXInitDisplay(int prtl)

/*   Connection avec un serveur X, et allocation des couleurs    */

{
Visual* vis;


struct rzvisu_struc
  {
  int MMsize_x;
  int MMsize_y;
  int Pixsize_x;
  int Pixsize_y;
  float resol_x;
  float resol_y;
  } rzvisu;


display = XOpenDisplay ("");

if (display == 0)
  { printf("RzXInitDisplay_Error: Cannot connect to X-Server \n");
    return(1); }
screen = XDefaultScreen(display);

rzvisu.Pixsize_x = DisplayWidth  (display, screen);
rzvisu.Pixsize_y = DisplayHeight (display, screen);
rzvisu.MMsize_x = DisplayWidthMM  (display, screen);
rzvisu.MMsize_y = DisplayHeightMM (display, screen);

rzvisu.resol_x = (float)rzvisu.Pixsize_x*10./(float)rzvisu.MMsize_x;
rzvisu.resol_y = (float)rzvisu.Pixsize_y*10./(float)rzvisu.MMsize_y;

vis = DefaultVisual(display,screen);

if (prtl > 0)
  {
  printf("RzXInitDisplay_Info: Screen size (X,Y) : %d * %d Pix (%d * %d  mm)\n",
         rzvisu.Pixsize_x,rzvisu.Pixsize_y,
         rzvisu.MMsize_x,rzvisu.MMsize_y);
  printf ("... Planes= %d  Cells= %d  depth= %d ", XDisplayPlanes(display, screen) ,
          XDisplayCells(display, screen), XDefaultDepth(display, screen));

  switch (vis->class)
    {
    case PseudoColor :
      printf (".... Class = %d (PseudoColor) \n",vis->class);
      break;
    case DirectColor : 
      printf (".... Class = %d (DirectColor) \n",vis->class);
      break;
    case GrayScale :
      printf (".... Class = %d (GreyScale) \n",vis->class);
      break;
    case StaticColor :
      printf (".... Class = %d (StaticColor) \n",vis->class);
      break;
    case StaticGray :
      printf (".... Class = %d (StaticGray) \n",vis->class);
      break;
    case TrueColor :   
      printf (".... Class = %d (TrueColor) \n",vis->class);
      break;
    default :
      printf (".... Class = %d (Unknown !) \n",vis->class);
      break;
    }

  }

/*  Allocating default CMap */
RzXAllocCMap(rzxcmap, CMAP_GREY32, prtl);
RzXAllocCMap(rzxcmap+1, CMAP_COL16, prtl);
RzXAllocCMap(rzxcmap+2, CMAP_GREYINV32, prtl);
RzXAllocCMap(rzxcmap+3, CMAP_COLRJ32, prtl);
rzxcmap[4].typ = -1;  rzxcmap[4].nCol = 0;

if (prtl > 1)
  printf("...Loading fonts Adobe-Courier Normal/Bold/Ital : \n");
fonts[0] = XLoadFont(display,
       "-adobe-courier-medium-r-normal--*-140-*-iso8859-1");
fonts[1] = XLoadFont(display,
       "-adobe-courier-bold-r-normal--*-140-*-iso8859-1");
fonts[2] = XLoadFont(display,
       "-adobe-courier-medium-o-normal--*-140-*-iso8859-1");

RzXwDispImg = 1;    /*  Variable de controle d'initialisation */

return(0);
}

/* Nouvelle-Fonction */
int RzXCheckInitDisp()
{
return (RzXwDispImg);
}


/* Nouvelle-Fonction */
int RzXGetPixDSize()
/*  Retourne la taille correspondant a depth en Byte ( 8->1) */
{
int depth;
depth = DefaultDepth(display,screen);
if (depth <= 8)  return(1);
else if (depth <= 16)  return(2);
else return(4);
}

/* Nouvelle-Fonction */
int RzXDispPixMap(Window xw, unsigned char *pix,  int sizx, int sizy, RzXCMap *cmap)
{
int depth;
XImage * ximg;
int i,j;
unsigned char *pp;

depth = DefaultDepth(display,screen);
ximg = XCreateImage (display,DefaultVisual(display,screen),
       depth,ZPixmap,0,pix,sizx,sizy,8,0);
pp = pix;
for(j=0; j<sizy; j++)
  for(i=0; i<sizx; i++) 
    { XPutPixel(ximg, i, j, cmap->colpix[*pp]);  pp++; }
XRaiseWindow(display, xw);
XPutImage(display,xw,defgc,ximg,0,0,0,0,sizx, sizy);
XSync(display,1);
XFree(ximg);

return(0);

}


/* Nouvelle-Fonction */
RzXCMap * RzXGetCMap(int cmapid)
{
int i;
for(i=0; i<5; i++)
  if (rzxcmap[i].typ == cmapid)  return(rzxcmap+i);
if (rzxcmap[4].typ >= 0)  RzXFreeCMap(rzxcmap+4);
RzXAllocCMap(rzxcmap+4, cmapid, 0);
return(rzxcmap+4);
}


/*  Definition d' une table de couleurs  R G B   */

static float R_RGB1[16] =
{0.0,0.00,0.0,0.0,0.0,0.00,0.0,0.6,0.8,1.0,1.00,1.0,0.75,1.0,0.85,1.0};
static float G_RGB1[16] =
{0.0,0.00,0.0,0.8,1.0,1.00,1.0,0.8,0.8,1.0,0.75,0.6,0.00,0.0,0.0,0.0};
static float B_RGB1[16] =
{0.0,0.75,1.0,1.0,1.0,0.75,0.0,0.0,0.0,0.0,0.00,0.5,0.75,1.0,0.0,0.0};



/* Nouvelle-Fonction */
int RzXAllocCMap(RzXCMap *rcmap, int cmapid, int prtl)
/*  Allocation des tables de couleurs  */

{
Colormap cmap;
XColor mycol;
int nok,i;

cmap = XDefaultColormap (display, screen);

nok = 0;

rcmap->typ = -1;

switch (cmapid)
  {
  case CMAP_GREY32 :
    rcmap->nCol = 32;   nok = 0;
    for(i=0; i<rcmap->nCol; i++)
      {
      mycol.red = mycol.green = mycol.blue = 3535+(i*62000/32);
      if (XAllocColor(display, cmap, &mycol) )
        { rcmap->colpix[i] = mycol.pixel;   nok++; }
      else rcmap->colpix[i] = BlackPixel(display, screen);  
      }
    rcmap->typ = CMAP_GREY32;
    break;

  case CMAP_GREYINV32 :
    rcmap->nCol = 32;   nok = 0;
    for(i=0; i<rcmap->nCol; i++)
      {
      mycol.red = mycol.green = mycol.blue = 65535-(i*62000/32);
      if (XAllocColor(display, cmap, &mycol) )
        { rcmap->colpix[i] = mycol.pixel;   nok++; }
      else rcmap->colpix[i] = BlackPixel(display, screen);  
      }
    rcmap->typ = CMAP_GREYINV32;
    break;

  case CMAP_COL16 :
    rcmap->nCol = 16;   nok = 0;
    for(i=0; i<rcmap->nCol; i++)
      {
      mycol.red = (int)(R_RGB1[i]*65535.);
      mycol.green = (int)(G_RGB1[i]*65535.);
      mycol.blue =(int)(B_RGB1[i]*65535.) ;
      if (XAllocColor(display, cmap, &mycol) )
        { rcmap->colpix[i] = mycol.pixel;   nok++; }
      else rcmap->colpix[i] = BlackPixel(display, screen);  
      }
    rcmap->typ = CMAP_COL16;
    break;

  case CMAP_COLRJ32 :
    rcmap->nCol = 32;   nok = 0;
    for(i=0; i<rcmap->nCol; i++)
      {
      if (i < 12) 
        { mycol.green = mycol.blue = 0;  
          mycol.red = 21535+(i*4000); }
      else if (i < 24)
        { mycol.blue = 0;   mycol.red = 65535;
          mycol.green = 21535+(i-12)*4000;  }
      else 
        { mycol.green = mycol.red = 65535;
          mycol.blue = 17535+(i-23)*6000; }

      if (XAllocColor(display, cmap, &mycol) )
        { rcmap->colpix[i] = mycol.pixel;   nok++; }
      else rcmap->colpix[i] = BlackPixel(display, screen);  
      }
    rcmap->typ = CMAP_COLRJ32;
    break;

  case CMAP_COLBR32 :
    rcmap->nCol = 32;   nok = 0;
    for(i=0; i<rcmap->nCol; i++)
      {
      if (i < 5) 
        { mycol.green = mycol.red = 0;  
          mycol.blue = 5535+i*15000; }
      else if (i < 10)
        { mycol.blue = 65535;
          mycol.green = 5535+(i-5)*9000;
          mycol.red = 0;  }
      else if (i < 15)
        { mycol.blue = 60000-(i-10)*15000;
          mycol.green = 41535+(i-10)*6000;
          mycol.red = 0;  }
      else if (i < 21)
        { mycol.blue = 0;
          mycol.green = 65535;
          mycol.red = 5535+(i-15)*12000;  }
      else if (i < 27)
        { mycol.blue = 0;
          mycol.green = 60000-(i-21)*12000;
          mycol.red = 65535-(i-21)*2000;  }
      else 
        { mycol.blue = 0;
          mycol.green = 0;
          mycol.red = 57535+(i-27)*2000; }

      if (XAllocColor(display, cmap, &mycol) )
        { rcmap->colpix[i] = mycol.pixel;   nok++; }
      else rcmap->colpix[i] = BlackPixel(display, screen);  
      }
    rcmap->typ = CMAP_COLBR32;
    break;

  case CMAP_COLRV32 :
    rcmap->nCol = 32;   nok = 0;
    for(i=0; i<rcmap->nCol; i++)
      {
      if (i < 8) 
        { mycol.green = 15000+(i*5000); mycol.blue = 0;  
          mycol.red = 15000+(i*5000); }
      else if (i < 21)
        { mycol.green = 50000-(i-7)*5000;   
          if (mycol.green < 0)  mycol.green = 0;
          mycol.blue = 0;
          mycol.red = 53535+(i-8)*1000;  }
      else 
        { mycol.green = 0;  mycol.red = 65535;
          mycol.blue = 15535+(i-21)*5000; }

      if (XAllocColor(display, cmap, &mycol) )
        { rcmap->colpix[i] = mycol.pixel;   nok++; }
      else rcmap->colpix[i] = BlackPixel(display, screen);  
      }
    rcmap->typ = CMAP_COLRV32;
    break;

  default :
    printf("RzXAllocCMap_Info: Erreur specification CMapType (%d) \n", cmapid);
    break;
  }

for(i=rcmap->nCol; i<256; i++)  rcmap->colpix[i] = 0;

if (prtl)
  printf("RzXAllocCMap_Info: %d colors allocated for CMap Type %d \n", nok, cmapid);

return(0);

}

/* Nouvelle-Fonction */
int RzXFreeCMap(RzXCMap *rcmap)
{
Colormap cmap;
int i;

cmap = XDefaultColormap (display, screen);
XFreeColors(display, cmap, rcmap->colpix,  rcmap->nCol, 0);
for(i=0; i<rcmap->nCol; i++)  rcmap->colpix[i] = 0;
rcmap->nCol = 0;
return(0);
}


/* Nouvelle-Fonction */
Window RzXNewWin(int sx, int sy, char *title, int posx, int posy)

/*  Creation de fenetre X simple pour mettre une image  */
{
XSizeHints hint;
Window   win;

hint.x = posx;   hint.y = posy;
hint.width  = sx;  hint.height = sy;
hint.flags  = PPosition | PSize;


win =  XCreateSimpleWindow (display, DefaultRootWindow (display),
       hint.x, hint.y, hint.width, hint.height, 3,
       WhitePixel(display, screen), BlackPixel(display, screen) );                        

XSetStandardProperties (display, win, title, title, None, NULL, 0, &hint);

if (!rzxgcok)
  {
  defgc = XCreateGC (display, win, 0, 0);
  rzxgcok = 1;
  }
XMapRaised(display,win);
XSync(display,1);

return(win);
}
#endif

