#ifndef FCT1DFIT_SEEN
#define FCT1DFIT_SEEN

#include "generalfit.h"

//================================================================
// CLASSES DE FONCTIONS 1D AVEC PARAMETRES POUR LE FIT
//================================================================

//////////////////////////////////////////////////////////////////
class Gauss1DPol : public GeneralFunction {
public:
  Gauss1DPol(unsigned int ndegpol,bool polcenter=false);
  Gauss1DPol(bool polcenter=false);
  virtual ~Gauss1DPol();

  virtual double Value(double const xp[], double const* Par);
  virtual double Val_Der(double const xp[],double const* Par,double* DgDpar);

  inline int NDegP() const {return NDegPol;}

protected:
  int NDegPol;    // degre du polynome
  bool PolCenter; // centrage du polynome
};

//////////////////////////////////////////////////////////////////
class GaussN1DPol : public GeneralFunction {
public:
  GaussN1DPol(unsigned int ndegpol,bool polcenter=false);
  GaussN1DPol(bool polcenter=false);
  virtual ~GaussN1DPol();

  virtual double Value(double const xp[], double const* Par);
  virtual double Val_Der(double const xp[],double const* Par,double* DgDpar);

  inline int NDegP() const {return NDegPol;}

protected:
  int NDegPol;    // degre du polynome
  bool PolCenter; // centrage du polynome
};

//////////////////////////////////////////////////////////////////
class Exp1DPol : public GeneralFunction {
public:
  Exp1DPol(unsigned int ndegpol,double x0=0.);
  Exp1DPol(double x0=0.);
  virtual ~Exp1DPol();

  virtual double Value(double const xp[], double const* Par);
  virtual double Val_Der(double const xp[],double const* Par,double* DgDpar);

  inline int NDegP() const {return NDegPol;}
  inline double XCenter() {return X_Center;}

protected:
  int NDegPol;     // degre du polynome
  double X_Center; // Centrage en X pour stabilitee
};

//////////////////////////////////////////////////////////////////
class Polyn1D : public GeneralFunction {
public:
  Polyn1D(unsigned int ndegpol,double x0=0.);
  virtual ~Polyn1D();

  virtual double Value(double const xp[], double const* Par);
  virtual double Val_Der(double const xp[],double const* Par,double* DgDpar);

  inline int NDegP() const {return NDegPol;}
  inline double XCenter() {return X_Center;}

protected:
  int NDegPol;     // degre du polynome
  double X_Center; // Centrage en X pour stabilitee
};

//////////////////////////////////////////////////////////////////
class HarmonieNu : public GeneralFunction {
public:
  HarmonieNu(unsigned int nharm=0, double t0=0.);
  virtual ~HarmonieNu();

  virtual double Value(double const xp[], double const* Par);
  virtual double Val_Der(double const xp[],double const* Par,double* DgDpar);

  inline int NHarmonic()  {return NHarm;}
  inline double  T0Center() const {return T0;}
  inline double& T0Center()       {return T0;}

protected:
  int NHarm;
  double T0;
};

//////////////////////////////////////////////////////////////////
class HarmonieT : public GeneralFunction {
public:
  HarmonieT(unsigned int nharm=0, double t0=0.);
  virtual ~HarmonieT();

  virtual double Value(double const xp[], double const* Par);
  virtual double Val_Der(double const xp[],double const* Par,double* DgDpar);

  inline int NHarmonic()  {return NHarm;}
  inline double  T0Center() const {return T0;}
  inline double& T0Center()       {return T0;}

protected:
  int NHarm;
  double T0;
};

//================================================================
// CLASSES DE FONCTIONS 2D AVEC PARAMETRES POUR LE FIT
//================================================================

//////////////////////////////////////////////////////////////////
class Polyn2D : public GeneralFunction {
public:
  Polyn2D(unsigned int ndegpol,double x0=0.,double y0=0.);
  virtual ~Polyn2D();

  virtual double Value(double const xp[], double const* Par);
  virtual double Val_Der(double const xp[],double const* Par,double* DgDpar);

  inline int NDegP() const {return NDegPol;}

protected:
  int NDegPol;     // degre du polynome
  double X_Center; // Centrage en X pour stabilitee
  double Y_Center; // Centrage en Y pour stabilitee
};

#endif
