// Class NTuple
//  CMV+Reza     Juillet 97
//  CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef NTUPLE_H_SEEN
#define NTUPLE_H_SEEN

#include <iostream.h>
#include <string>
#include <vector>

#if defined(__KCC__)
using std::string ;
#include <vector.h>
#endif

#include "ppersist.h"
#include "dvlist.h"


class NTuple : public PPersist {
public:
  enum {classId = ClassId_NTuple };

  		    NTuple(int nvar, char** noms, int blk=512);
		    NTuple();
		    NTuple(char* flnm);
  virtual           ~NTuple();

  void              Fill(r_4* x);

  inline int_4      NEntry() { return(mNEnt); }
  inline int_4      NVar() { return(mNVar); }

  float             GetVal(int n, int k)   const;
  inline float	    GetVal(int n, char* nom) const 
                         { return(GetVal(n, IndexNom(nom)) ); }
  int               IndexNom(const char* nom)  const ;
  char*             NomIndex(int k) const;
  string            VarList_C(const char* nomx=NULL)  const;

  r_4*	            GetVec(int n, r_4* ret=NULL)  const ;

  void              GetMinMax(int k, float& min, float& max)   const ; 
  inline void       GetMinMax(const char* nom, float& min, float& max)  const 
                         { GetMinMax(IndexNom(nom), min, max); }

  void              Print(int num, int nmax=1)  const ;
  void              Show(ostream& os) const;
  inline void       Show() const { Show(cout); }

  DVList&           Info();

  int_4             ClassId() const        { return classId; }
  static PPersist*  Create()               { return new NTuple;}

  virtual void      WriteSelf(POutPersist&) const;
  virtual void      ReadSelf(PInPersist&);


private:
  void  Clean();

  int_4 mNVar, mNEnt, mBlk, mNBlk;
  r_4* mVar;
  char* mNames;

  vector<r_4*> mPtr;

  DVList* mInfo;        // Infos (variables) attachees au NTuple
  
};

inline ostream& operator << (ostream& s, NTuple const & nt)
  {  nt.Show(s);  return(s);  }

#ifdef __MWERKS__
__MSL_FIX_ITERATORS__(r_4*);
#endif

#endif
  
