#ifndef SCAN_H_SEEN
#define SCAN_H_SEEN


// includes PEIDA
#include "ppersist.h"
#include <iostream.h>
#include "dvlist.h"
class Scan : public PPersist {

  public  :
    /* 
arguments du constructeur : 
  . ouverture (radians), 
  . un tableau de 3 reels (deux angles-en radians- definissant la direction de 
                      l'axe de rotation du satellite + vitesse de rotation 
                      en radians/s),
  . frequence d'echantillonnage (Hz), 
  . instant final de prise de donnees (s),
deux arguments optionnels :
  . instant initial pour la prise de donnees
  . offset d'antenne en angle phi
  */
Scan(float,float*,float,float,float,float);
Scan(const Scan& );
Scan() { 
  InitNull();
  cout << " constructeur de scan par defaut" << endl;
}
~Scan();

// ------------ Persistence handling

     enum {classId = 0xF003 };
int_4                  ClassId() const        { return classId; }

virtual void           WriteSelf(POutPersist&) const;
virtual void           ReadSelf(PInPersist&);

int_4     NbPoints() const;
int_4     NbTours() const;
int_4     NbPts1Tr() const; 
int_4     ValueIndex(float) const;
void    Direction(float, float& ,float& );
void    DirectionIndex(int_4,float& ,float& );
double& PixelValue(int_4 k) const;

/* Surcharge de la parenthese a un indice entier : remplit ou/et renvoie */
/* la valeur du contenu du pixel d'indice k                              */ 

  inline  double&        operator()(int_4 k)
                                      { return(PixelValue(k)) ; } ;
//++
DVList&  Info()
//
//      Renvoie une reference sur l'objet DVList Associe
//--
{
if (mInfo_ == NULL)  mInfo_ = new DVList;
return(*mInfo_);
}


  private :
    
void          Clear();
void          InitNull();

int_4 NmaxPts_;
int_4 NmaxTrs_;
int_4 NPts1Tr_;
r_4   Ouverture_;
r_4   OmegaTeta_;     /* direction de l'axe de rotation du satellite */
r_4   OmegaPhi_;      /* (radians)                                   */
r_4   OmegaRad_;      /* vitesse de rotation du satellite (radians/s) */
r_4   FrequenceEch_;  /* frequence d'echantillonnage (Hz)*/
r_4   TempsFinal_;
r_4   TempsInitial_;
r_4   PhiZero_;       /* Offset antenne (radians)  */
r_8*  sPix_;          /* valeurs contenues dans chaque pixel */ 
r_8   Rota_[9];       /* matrice de passage : [Xf]=[Rota][Xs] */
                      /* Xs : coordonnees dans un systeme lie au satellite*/ 
                      /* Xf : coordonnees dans un repere "fixe"           */ 
DVList* mInfo_;        // Infos (variables) attachees 
};


#endif /* SCAN_H_SEEN */
