#ifndef UNITVEC_H_SEEN
#define UNIITVEC_H_SEEN

#include <math.h>
#include <iostream.h>



//  Classe pour faire des vecteurs normes x,y,z a partir de Teta,Phi
//  et l inverse.  On peut calculer le produit scalaire et les vecteurs 
//  perpendiculaires.
//  Exemple:
//  UnitVector u1(0.5, 0.7);   // Vers Teta=0.5 Phi = 0.7 Rad.
//  UnitVector u2(1.,2.,1.);   // Vecteur norme parallele a (x=1., y=2., z=1.)
//  u2.Teta();                 // Direction teta de u2
//  u1.psc(u2);                // u1 prod. scalaire u2
//  UnitVector vp1 = u2.vperp();   // Vecteur perpendiculaire a u1 , meme phi (ou a 180 deg)
//  UnitVector vp2 = u2.vperp2();  // Vecteur perpendiculaire a u1 , a phi+90 deg

//  
class UnitVector {
public:
  UnitVector(double teta=0., double phi=0.) 
    {  set(teta, phi); }
  UnitVector(double vx, double vy, double vz) 
      { setxyz(vx, vy, vz); }

  inline void set(double teta, double phi) 
    { t=teta; p=phi; z = cos(teta); x = sin(teta)*cos(phi);  y =  sin(teta)*sin(phi); }
  inline void setxyz(double vx, double vy, double vz) 
    { double r = sqrt(vx*vx+vy*vy+vz*vz); x = vx/r; y = vy/r; z = vz/r;
    t = acos(z); p = atan2(y,x); }

  inline double psc(UnitVector& u) { return(x*u.x+y*u.y+z*u.z); }

  inline double Teta() { return(t); }
  inline double Phi() { return(p); }
  inline double X() { return(x); }
  inline double Y() { return(y); }
  inline double Z() { return(z); }

  inline UnitVector vperp() {double tp, pp; pp = p;  
     tp = t+0.5*M_PI; if (tp > M_PI) { tp = tp-M_PI; pp += M_PI*0.5; }
     return(UnitVector(tp, pp)); }
  inline UnitVector vperp2() {double tp, pp; tp = M_PI*0.5;  pp = p + 0.5*M_PI; 
     return(UnitVector(tp, pp)); }

  inline friend ostream& operator << (ostream& s, UnitVector const& u)
      { s << "UnitVector: X,Y,Z= (" << u.x << "," << u.y << "," << u.z 
          << ") Teta,Phi= " << u.t << "," << u.p << endl ;  return(s); }

  double x,y,z;
  double t,p;
};


#endif
