#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>

#include "pistdimgapp.h"
#include "piacmd.h"
#include "piversion.h"
#include "piaversion.h"

#include "timing.h"
#include "skyinit.h"


// ---- Pour charger automatiquement le module sopiamodule 
extern "C" {
void sopiamodule_init();
void sopiamodule_end();
}


/*  ================================ MAIN() =================================  */

int main(int narg, char *arg[])
{
int ofa;
int fgfpe, fgsegv, fgred, fgexec;

SkyTInitiator skyinit;
   
InitTim();

ofa = 1;   
if (narg > 1)
  {
  if (strcmp(arg[1],"-h") == 0) 
    {
    puts("\n piapp: Programme d'analyse interactive ");
    puts("Usage: piapp [-nored] [-nosig] [-nosigfpe] [-nosigsegv] [-help2tex] [-exec file [args]]");
    puts("  -nored : NoRedirect StdOut/StdErr");
    puts("  -nosig : Don't catch SigFPE, SigSEGV");
    puts("  -nosigfpe -nosigsegv: Don't catch SigFPE / SigSEGV");
    puts("  -help2tex: Create a LaTeX help file (piahelp.tex)");
    puts("  -exec file [args] : Execute command file \n");
    exit(0);
    }
  }

ofa = 1;
fgred = fgfpe = fgsegv = true;
fgexec = false;
string exfc;
// Pour fabriquer le help
bool fgtexh = false;
int ka;
for(ka=1; ka<narg; ka++) {
  if (strcmp(arg[ka],"-nored") == 0)   fgred=false; 
  else if (strcmp(arg[ka],"-nosig") == 0)   fgfpe=fgsegv=false; 
  else if (strcmp(arg[ka],"-nosigfpe") == 0)   fgfpe=false; 
  else if (strcmp(arg[ka],"-nosigsegv") == 0)   fgsegv=false; 
  else if (strcmp(arg[ka],"-help2tex") == 0) { fgtexh=true; fgred=false; }
  else if (strcmp(arg[ka],"-exec") == 0) {
    if (ka < narg-1) {
      fgexec = true;
      exfc = "exec";
      for(int kaa=ka+1; kaa<narg; kaa++)  { exfc += ' ';  exfc +=  arg[kaa]; }
      }
    break;
    }
  }

if (fgexec) printf(">>>>> Starting piapp , Executing %s \n", exfc.c_str()); 
else printf(">>>>> Starting piapp <<<<< \n");
printf("Version: piapp=%g  PI=%g  SOPHYA=%g \n", (double)PIAPP_VERSIONNUMBER, 
              (double)PI_VERSIONNUMBER, (double)skyinit.Version());

PIStdImgApp * app = new PIStdImgApp(narg, arg);

// Gestion de redirection stdout/err et Signaux
if (fgred) app->RedirectStdOutErr(true);
else app->RedirectStdOutErr(false);
app->CatchSignals(fgfpe, fgsegv);

// S'il y a un fichier de commande a executer
if (fgexec) app->CmdInterpreter()->Interpret(exfc);

// On charge le module sopiamodule
sopiamodule_init();

// S'il y a besoin de faire le fichier Help
if (fgtexh) { 
  string thf = "piahelp.tex";
  app->CmdInterpreter()->HelptoLaTex(thf);
  printf("piapp : Help file piahelp.tex created --> exit(0) \n"); 
  delete app;
  exit(0);
}

int rc = 0;
bool cont = true;
char ans[32],rep;
int excnt = 0;
while(cont) {
  rc = 0;   cont = false;
  app->SetReady();
  if (fgred) app->RedirectStdOutErr(true);
  try {
  app->Run();
  }  
  catch(PThrowable exc) {  // Catching SOPHYA exceptions 
    app->Stop();
    app->RedirectStdOutErr(false);  
    //BUG ? fait planter OSF-cxx     fflush(stdout); 
    cout << endl;      cerr << endl;
    cout << "\n piapp/main() PThrowable catched ! " << exc.Msg() << endl;
    cout << ++excnt << "- continue <CR>, Close Windows, "
         << " continue C<CR> Stop program S<CR> ? " << endl; 
    gets(ans);
    rep = toupper(ans[0]);  
    if (rep == 'S')  { 
      cout << " !!!! Stopping piapp !!!! " << endl;
      rc = 78;
      cont = false;
    }
    else { 
      if (rep == 'C') {
	cout << "piapp/main() Closing all windows ... " << endl;
	app->CloseAllWindows();
      }
      cout << " *** piapp - Continuing event loop *** " << endl;
      cont = true;
    }
  }
  catch(...) { // Catching all other exceptions 
    app->Stop();
    app->RedirectStdOutErr(false);  
    cout << endl;      cerr << endl;
    cout << "\n piapp/main() exception catched ! " << endl;
    cout << ++excnt << "- continue <CR>, Close Windows, "
         << " continue C<CR> Stop program S<CR> ? " << endl; 
    gets(ans);
    rep = toupper(ans[0]);  
    if (rep == 'S')  { 
      cout << " !!!! Stopping piapp !!!! " << endl;
      rc = 78;
      cont = false;
    }
    else { 
      if (rep == 'C') {
	cout << "piapp/main() Closing all windows ... " << endl;
	app->CloseAllWindows();
      }
      cout << " *** piapp - Continuing event loop *** " << endl;
      cont = true;
    }
  }
}

app->RedirectStdOutErr(false);  
// On de-charge le module sopiamodule
sopiamodule_end();
delete app;

cout << "\n------------------------------------------------ \n"
     << "-------- piapp : Exiting .... Rc= " << rc << " -----------\n"
     << "------------------------------------------------ " << endl; 
return(rc);
}

