// This may look like C code, but it is really -*- C++ -*-
// Adaptateur d objets (pour NamedObjMgr) 
// pour les classes TMatrix<T>, TVector<T> de Sophya
//                                      Reza 11/99
//  LAL-IN2P3/CNRS               CEA-DAPNIA     
 
#ifndef NOMTARRAYADAPTER_H_SEEN
#define NOMTARRAYADAPTER_H_SEEN

#include "nomgadapter.h"
#include "tarray.h"

//---------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet TArray 
//---------------------------------------------------------------

template <class T> 
class NOMAdapter_TArray : public NObjMgrAdapter {
public:
				NOMAdapter_TArray(TArray<T>* m = NULL);
  virtual			~NOMAdapter_TArray();

  virtual NObjMgrAdapter*	Clone(AnyDataObj* o);

  virtual string		GetDataObjType();

  virtual AnyDataObj*		CloneDataObj(bool share=false);

  //  virtual void			ReadFits(string const & flnm);
  //  virtual void			SaveFits(string const & flnm);
  virtual void			SavePPF(POutPersist& s, string const & nom);

  virtual void			Print(ostream& os);
  //  virtual PIDrawer*		GetDrawer(string& dopt);
  //  virtual P2DArrayAdapter*	Get2DArray(string& dopt);
  virtual NTupleInterface*	GetNTupleInterface(bool& adel);

  //  virtual GeneralFitData* GetGeneralFitData(bool& adel
  //        ,GeneralFitData::FitErrType errtype=GeneralFitData::DefaultError
  //        ,double errscale=1.,double errmin=0.
  //        ,int i1=0,int i2=-1,int j1=0,int j2=-1);
  // virtual AnyDataObj* FitResidusObj(GeneralFit& mfit);
  // virtual AnyDataObj* FitFunctionObj(GeneralFit& mfit);

protected:
  TArray<T>* mArr;
};

// Class Interface NTuple pour TArray<T>

template <class T> 
class NTupInt_TArray : public NTupleInterface {
public:
			NTupInt_TArray(TArray<T>* m);
  virtual		~NTupInt_TArray();
  virtual uint_4        NbLines() const ;
  virtual uint_4        NbColumns() const ;
  virtual r_8 *         GetLineD(int n) const ;
  virtual string        VarList_C(const char* nomx=NULL) const ;
protected:
  TArray<T>* mArr;
  mutable r_8 mRet[11];
};


#endif
