#include "machdefs.h"
#include "piinit.h"
#include "nobjmgr.h"
#include "servnobjm.h"
#include "nomhistadapter.h"
#include "nomgfdadapter.h"
#include "nomimagadapter.h"

#ifdef SANS_EVOLPLANCK
#include "nommatvecadapter.h"
#include "fitsimage.h"
#include "nomstladapter.h"
#else
#include <complex>
#include "nomtmatvecadapter.h"
#include "nomtarradapter.h"
#include "nomskymapadapter.h"
#include "spherethetaphi.h"
#include "spherehealpix.h"
#include "localmap.h"

#include "specrespvector.h"
#include "gaussfilt.h"
#include "nomspecrespadapter.h"

#endif

int PIAppInitiator::FgInit = 0;

PIAppInitiator::PIAppInitiator(PIStdImgApp * app)
#ifdef SANS_EVOLPLANCK
 : PeidaStarRecoInitiator()
#else
 : SambaInitiator()
#endif
{
  FgInit++;
  if (FgInit > 1)  return;

  Services2NObjMgr* serv = app->ObjMgr()->GetServiceObj();

  serv->RegisterClass(new Histo, new NOMAdapter_Histo );
  serv->RegisterClass(new HProf, new NOMAdapter_Histo );
  serv->RegisterClass(new Histo2D, new NOMAdapter_Histo2D );
  serv->RegisterClass(new NTuple, new NOMAdapter_NTuple );

  serv->RegisterClass(new XNTuple, new NOMAdapter_XNTuple );
  char* varenv=NULL;
  if ( (varenv=getenv("PEIDA_TMP")) == NULL )   varenv=getenv("TMPDIR") ;
  if (varenv)  XNTuple::SetSwapPath(varenv);

  serv->RegisterClass(new GeneralFitData, new NOMAdapter_GeneralFitData );

#ifdef SANS_EVOLPLANCK
  serv->RegisterClass(new Vector, new NOMAdapter_Vector );
  serv->RegisterClass(new Matrix, new NOMAdapter_Matrix );
#else
  serv->RegisterClass(new TArray<int_4>, new NOMAdapter_TArray<int_4> );
  serv->RegisterClass(new TArray<r_4>, new NOMAdapter_TArray<r_4> );
  serv->RegisterClass(new TArray<r_8>, new NOMAdapter_TArray<r_8> );
  serv->RegisterClass(new TArray<complex<r_4> >, new NOMAdapter_TArray<complex<r_4> > );
  serv->RegisterClass(new TArray<complex<r_8> >, new NOMAdapter_TArray<complex<r_8> > );

  serv->RegisterClass(new TVector<int_4>, new NOMAdapter_TMatrix<int_4> );
  serv->RegisterClass(new TMatrix<int_4>, new NOMAdapter_TMatrix<int_4> );
  serv->RegisterClass(new TVector<r_4>, new NOMAdapter_TMatrix<r_4> );
  serv->RegisterClass(new TMatrix<r_4>, new NOMAdapter_TMatrix<r_4> );
  serv->RegisterClass(new TVector<r_8>, new NOMAdapter_TMatrix<r_8> );
  serv->RegisterClass(new TMatrix<r_8>, new NOMAdapter_TMatrix<r_8> );
  serv->RegisterClass(new TVector<complex<r_4> >, new NOMAdapter_TMatrix<complex<r_4> > );
  serv->RegisterClass(new TMatrix<complex<r_4> >, new NOMAdapter_TMatrix<complex<r_4> > );
  serv->RegisterClass(new TVector<complex<r_8> >, new NOMAdapter_TMatrix<complex<r_8> > );
  serv->RegisterClass(new TMatrix<complex<r_8> >, new NOMAdapter_TMatrix<complex<r_8> > );
#endif

  serv->RegisterClass(new Image<uint_2>, new  NOMAdapter_Image<uint_2> );
  serv->RegisterClass(new Image<int_4>, new  NOMAdapter_Image<int_4> );
  serv->RegisterClass(new Image<r_4>, new  NOMAdapter_Image<r_4> );
 
#ifdef SANS_EVOLPLANCK
  serv->RegisterClass(new Image<int_2>, new  NOMAdapter_Image<int_2> );

  serv->RegisterClass(new FitsImage<uint_2>, new  NOMAdapter_Image<uint_2> );
  serv->RegisterClass(new FitsImage<int_2>, new  NOMAdapter_Image<int_2> );
  serv->RegisterClass(new FitsImage<int_4>, new  NOMAdapter_Image<int_4> );
  serv->RegisterClass(new FitsImage<r_4>, new  NOMAdapter_Image<r_4> );

  serv->RegisterClass(new StarList, new NOMAdapter_StarList );
#else
  serv->RegisterClass(new LocalMap<r_4>, new NOMAdapter_PixelMap<r_4> );
  serv->RegisterClass(new SphereThetaPhi<r_4>, new NOMAdapter_PixelMap<r_4> );
  serv->RegisterClass(new SphereHEALPix<r_4>, new NOMAdapter_PixelMap<r_4> );
  serv->RegisterClass(new LocalMap<r_8>, new NOMAdapter_PixelMap<r_8> );
  serv->RegisterClass(new SphereThetaPhi<r_8>, new NOMAdapter_PixelMap<r_8> );
  serv->RegisterClass(new SphereHEALPix<r_8>, new NOMAdapter_PixelMap<r_8> );
  serv->RegisterClass(new LocalMap<complex<float> >, new NOMAdapter_PixelMap<complex<float> > );
  serv->RegisterClass(new SphereThetaPhi<complex<float> >, new NOMAdapter_PixelMap<complex<float> > );
  serv->RegisterClass(new SphereHEALPix<complex<float> >, new NOMAdapter_PixelMap<complex<float> > );
  serv->RegisterClass(new LocalMap<complex<double> >, new NOMAdapter_PixelMap<complex<double> > );
  serv->RegisterClass(new SphereThetaPhi<complex<double> >, new NOMAdapter_PixelMap<complex<double> > );
  serv->RegisterClass(new SphereHEALPix<complex<double> >, new NOMAdapter_PixelMap<complex<double> > );

  serv->RegisterClass(new GaussianFilter, new NOMAdapter_SpectralResponse );
  serv->RegisterClass(new SpecRespVec, new NOMAdapter_SpectralResponse );
#endif

}

PIAppInitiator::~PIAppInitiator()
{
  FgInit--;
/*  if (FgInit == 0)
    {
    }  */
}

