#include <stdio.h>
#include "pintuple.h"

 
/* --Methode-- */
PINTuple::PINTuple(NTuple* nt, bool ad)
: PIDrawer()
{
  mNT = nt;
  mAdDO = ad; 
  SelectXY(NULL, NULL);
  SelectErrBar();
}

PINTuple::~PINTuple()
{
  if (mAdDO && mNT)  delete mNT;
}

/* --Methode-- */
void  PINTuple::SelectXY(const char* px, const char* py)
{
if (mNT == NULL)  xK = yK = -1;
if (px == NULL) xK = -1;
else xK = mNT->IndexNom(px);
if (py == NULL) yK = -1;
else yK = mNT->IndexNom(py);
}

/* --Methode-- */
void  PINTuple::SelectErrBar(const char* erbx, const char* erby)
{
if (mNT == NULL)  xebK = yebK = -1;
if (erbx == NULL) xebK = -1;
else xebK = mNT->IndexNom(erbx);
if (erby == NULL) yebK = -1;
else yebK = mNT->IndexNom(erby);
}


/* --Methode-- */
void PINTuple::UpdateLimits()
{
  if (!mNT) return;
  if (mNT->NEntry() <= 0)  return;
  if ( (xK < 0) || (yK < 0) )   return;

  // Commencer par trouver nos limites
  float dx, dy;
  float xmin, xmax, ymin, ymax;
  xmin = ymin = 9.e19;
  xmax = ymax = -9.e19;
  mNT->GetMinMax(xK, xmin, xmax);
  mNT->GetMinMax(yK, ymin, ymax);
    
  dx = 0.02*(xmax-xmin);
  dy = 0.02*(ymax-ymin);
  
  SetLimits(xmin-dx, xmax+dx, ymin-dy, ymax+dy);
  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
}


/* --Methode-- */
void PINTuple::Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax)
{
float xp,yp,xer,yer;
char buff[128];
int nok;

if (!mNT) return;
if ( (xK < 0) || (yK < 0) )  return;

nok = 0;  
for (int i=0; i<mNT->NEntry(); i++) {
  xp = mNT->GetVal(i, xK);
  yp = mNT->GetVal(i, yK);
  if ( (xp < xmin) || (xp > xmax) || (yp < ymin) || (yp > ymax) )  continue;
  nok++;
  g->DrawMarker(xp, yp); 
  if ( xebK >= 0 ) {
    xer = mNT->GetVal(i, xebK);
    g->DrawLine(xp-xer, yp, xp+xer, yp);
  }
  if ( yebK >= 0 ) {
    yer = mNT->GetVal(i, yebK);
    g->DrawLine(xp, yp-yer, xp, yp+yer);
  }
}

/*
sprintf(buff, "NTuple:  NEntry= %d  NDisp= %d", (int)mNT->NEntry(), nok);
g->BaseGraphic()->DrawString(15,15,buff);
*/
return;
}

