// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive  PIStackWindow  PIZoneWindow
//                             R. Ansari  08/98


#include "pistzwin.h"
#include "psfile.h"

// Fonction de l'objet PIPeriodic de PIStackWindow
static void myadperpact(void* a);

void myadperpact(void* a)
{
((PIStackWindow*)a)->DispNext();
}
/* --Methode-- */
PIStackWindow::PIStackWindow(PIMsgHandler* par, char* nom, PIWindowKind k,
                             int sx, int sy, int px, int py)
        : PIWindow(par, nom, k, sx, sy, px, py) , mPerad(1)
{
mCurdisp = -1;
mPerad.SetAction(myadperpact, this);
} 


/* --Methode-- */
PIStackWindow::~PIStackWindow()
{
mPerad.Stop();
Hide();
}

/* --Methode-- */
void PIStackWindow::ChildAdd(PIWdgGen* child)
{
int k;
for(k=0; k<NbChilds(); k++) GetChild(k)->UnManage();
PIWindow::ChildAdd(child);
child->Manage();
mCurdisp = NbChilds()-1;
return;
}

/* --Methode-- */
void PIStackWindow::ChildDel(PIWdgGen* child)
{
int k;
for(k=0; k<NbChilds(); k++) GetChild(k)->UnManage();
PIWindow::ChildDel(child);
if (NbChilds() > 0) {
  mCurdisp--;
  if (mCurdisp < 0)  mCurdisp = 0;
  if (mCurdisp > NbChilds()) mCurdisp = NbChilds()-1; 
  GetChild(mCurdisp)->Manage();
  }
else mCurdisp = -1;
return;
}

/* --Methode-- */
void PIStackWindow::PSPrint(PSFile *psf, int ofx, int ofy)
{
if (!psf) return;
int k;
for(k=0; k<NbChilds(); k++) { 
  psf->NewPage((float)XSize(), (float)YSize(),PI_Auto);
  GetChild(k)->PSPrint(psf, ofx, ofy);
  }
}

/* --Methode-- */
void PIStackWindow::DispNext()
{
if (NbChilds() < 1) return;
int k;
for(k=0; k<NbChilds(); k++) GetChild(k)->UnManage();
mCurdisp = (mCurdisp+1)%NbChilds();
GetChild(mCurdisp)->Manage();
return;
}

/* --Methode-- */
void PIStackWindow::StartAutoDisp(int dt)
{
mPerad.Start(dt);
}

/* --Methode-- */
void PIStackWindow::StopAutoDisp()
{
mPerad.Stop();
}

//-------------------------------------------------------------------------------

/* --Methode-- */
PIZoneWindow::PIZoneWindow(PIMsgHandler* par, char* nom, PIWindowKind k,
                           int nzx, int nzy, int sx, int sy, int px, int py)
        : PIWindow(par, nom, k, sx, sy, px, py)
{
if (nzx < 1) nzx = 1;
if (nzy < 1) nzy = 1;
if (nzx > 50) nzx = 50;
if (nzx > 50) nzx = 50;
mZx = nzx;  mZy = nzy;   mZc = 0;

mZWdg = new PIWdgGen*[nzx*nzy];
int i;
for(i=0; i<mZx*mZy; i++) mZWdg[i] = NULL; 
}

/* --Methode-- */
PIZoneWindow::~PIZoneWindow()
{
delete[] mZWdg;
}

/* --Methode-- */
void PIZoneWindow::ChildAdd(PIWdgGen * child)
{
if (!child) return;
if (mZWdg[mZc])  delete mZWdg[mZc];
int nx = mZc%mZx;
int ny = mZc/mZx;
PIWindow::ChildAdd(child);
mZWdg[mZc] = child;
child->SetBinding(PIBK_free,PIBK_free,PIBK_free, PIBK_free);
int sx = XSize()/mZx;
int sy = YSize()/mZy;
child->SetPos(nx*sx, ny*sy);
child->SetSize(sx, sy);
child->SetBinding(PIBK_elastic,PIBK_elastic,PIBK_elastic, PIBK_elastic);
mZc = (mZc+1)%(mZx*mZy);
}

/* --Methode-- */
void PIZoneWindow::ChildDel(PIWdgGen * child)
{
if (!child)  return;
int k;
for(k=0; k<mZx*mZy; k++) 
  if (mZWdg[k] == child) mZWdg[k] = NULL;  
PIWindow::ChildDel(child);
return;
}

/* --Methode-- */
void PIZoneWindow::NZones(int& nzx, int& nzy)
{
nzx = mZx;   nzy = mZy;
}

/* --Methode-- */
void PIZoneWindow::NextChildPosSize(int& px, int& py, int& sx, int& sy)
{
sx = XSize()/mZx;
sy = YSize()/mZy;
int nx = mZc%mZx;
int ny = mZc/mZx;
px = nx*sx;  py = ny*sy;
}
