#!/bin/csh
#
#  Script pour la definition d'environnement SOPHYA (version SGI-magique)
#                             R. Ansari   14/11/2000
#
set sgi64 = 'N'
set sversion = 'pro'
if ($#argv > 0)  then
  if ($1 == '-h') then
    echo 'Usage: source env.csh [pro/new/old] [64] ' 
    echo '  Defines the environment for using SOPHYA '
    echo '  First optional argument defines the library version (pro/new/... Default=pro)'
    echo '  Second optional argument, == 64 -> 64 bit architecture version '
    exit 0
  endif
  set sversion = $1
  if ($#argv > 1)  then
    if  ($2 == '64')  then
	set sgi64 = 'Y'
    endif
  endif
endif

echo ' en.csh : setting environment variables for SOPHYA on SGI'

setenv EROSCXX CC
if ($sgi64 == 'Y')  then
  echo ' SGI-64 bits architecture selected ... ' 
  setenv DPCBASEREP /usr/local/Sophya64/$sversion
  setenv EXTLIBDIR /usr/local/Sophya64/ExtLibs
  setenv SOPHYA_SGI64 1
  setenv LD_LIBRARY64_PATH .:${LD_LIBRARY64_PATH}:${DPCBASEREP}/IRIX64-CC/ShLibs
else
  setenv DPCBASEREP /usr/local/Sophya/$sversion
  setenv EXTLIBDIR /usr/local/Sophya/ExtLibs
  unsetenv SOPHYA_SGI64
  setenv LD_LIBRARYN32_PATH .:${LD_LIBRARYN32_PATH}:${DPCBASEREP}/IRIX64-CC/ShLibs
endif

set path = ($path $DPCBASEREP/IRIX64-CC/Exec)

echo ' EROSCXX= ' $EROSCXX
echo ' DPCBASEREP= ' $DPCBASEREP
echo ' EXTLIBDIR= ' $EXTLIBDIR
echo ' LD_LIBRARYN32_PATH= ' $LD_LIBRARYN32_PATH 
echo ' LD_LIBRARY64_PATH= ' $LD_LIBRARY64_PATH 
echo ' PATH= ' $path

exit 0



