// Module PI : Peida Interactive     PIScDrawWdg
// Gestionnaire Drawer-2D  E.Aubourg, R. Ansari  96-98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "piscdrawwdg.h"
#include "pidrwtools.h"
#include "parradapter.h"

PIScDrawWdg::PIScDrawWdg(PIContainerGen *par, char *nom,
                         int sx, int sy, int px, int py)
:PIBaseWdg(par, nom, sx, sy, px, py)
{
  mBDrw = new PIElDrawer;
  SetLimits(-1.,1.,-1.,1.,kAxeDirLtoR,kAxeDirDownUp);
  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);  
  FreeLimits();
  xEndDrag = yEndDrag = xBegDrag = yBegDrag = 0;
  SetDefaultDrawRectangle(0.12, 0.12, 0.88, 0.88, true);
  AddDrawer(mBDrw, true, false, false);
  
  mTrlb = mTxw = NULL;
  mTrW = NULL;
  SetTextWin(NULL);

  ActivateKeyboard();
  ActivateButton(1);    // Pour pouvoir activer la fenetre et coordonnees
  ActivateMove(1);      //    "         "         "        "
  ActivateButton(2);
  ActivateMove(2);

}

PIScDrawWdg::~PIScDrawWdg()
{
  delete mBDrw;
  if (mTrW)  delete mTrW;
}

void 
PIScDrawWdg::Keyboard(int key, PIKeyModifier kmod)
{
if (kmod == PIKM_Alt) {
  if (key == 'V' || key == 'v') RequestSelection();  // Pour coller (copier/coller)  
  if (key == 'Z' || key == 'z') { mBDrw->ElDelAll();  Refresh(); } // Pour supprimer tous les signes 
  if (key == 'O' || key == 'o') { 
    PIDrwTools::SetCurrentBaseWdg(this);
    PIDrwTools::ShowPIDrwTools();   // Fentre axes et options de trace
    }
  }
}
void 
PIScDrawWdg::PasteSelection(unsigned int typ, void *pdata, unsigned int l)
{
if (typ != PICP_string) return;
int ll = (l<256) ? l+1 : 256;
char pc[256];
strncpy(pc, (char*)pdata, ll-1);  pc[ll-1] = '\0';
mBDrw->ElAddText(mPPos[0], mPPos[1], pc );
mBDrw->Refresh();
}

void
PIScDrawWdg::SetLimits(float xmin, float xmax, float ymin, float ymax,
                       int axrl, int ayud, bool tmp)
{
  if (xmax <= xmin || ymax <= ymin)
    return; // $CHECK$ exception ?
  SetDefaultDrawerLimits(xmin, xmax, ymin, ymax, axrl, ayud);
  mBDrw->SetLimits(xmin, xmax, ymin, ymax, axrl, ayud);
  mPPos[0] = 0.5*(XMin()+XMax());
  mPPos[1] = 0.5*(YMin()+YMax());
  if (!tmp) {
    xMinS = xmin;
    xMaxS = xmax;
    yMinS = ymin;
    yMaxS = ymax;
  }
}
  
void
PIScDrawWdg::UpdateLimits()
{
  if (NbDrawers() < 2)  return;
  PIDrawer* d = GetDrawer(1);
  if (d == NULL) return;
  d->UpdateLimits();
  SetLimits(d->XMin(), d->XMax(), d->YMin(), d->YMax()); 
  Refresh();
  return;  
}

int 
PIScDrawWdg::AddScDrawer(PIDrawer* d, bool ad)
{
  if (d == NULL)  return(-1);
  if (! LimitsFixed() ) {  //  On met a jour les limites 
    d->UpdateLimits();
    SetLimits(d->XMin(), d->XMax(), d->YMin(), d->YMax());
  }
  return(AddDrawer(d, true, ad));
}


void
PIScDrawWdg::SetTextWin(PILabel * tw, bool trw, int tx, int ty)
{
mTxw = tw;
if (trw)
  {
  if (mTrW)  mTrW->SetSize(tx, ty);
  else
    {
    mTrW = new PIWindow(this, "Point", PIWK_transient, tx, ty, 0, 0);
    mTrW->SetAutoDelChilds(true);
    mTrlb = new PILabel(mTrW, "PointCoord", tx, ty, 0, 0);
    mTrlb->SetBinding(PIBK_fixed,PIBK_fixed, PIBK_fixed,PIBK_fixed);
    }
  }
else
  if (mTrW) { delete mTrW; mTrW = NULL;  mTrlb = NULL; }

return;
}



// Gestion affichage coordonnees du point 

string   PIScDrawWdg::GetClickText(float x, float y) 
// Donne le texte a afficher pour position x,y  
{
  char buff[128];
  sprintf(buff, "X= %g  Y= %g",  x, y);
  return((string)buff);
}

void
PIScDrawWdg::But1Press(int x, int y)
{
  if (UpdateText(x, y))
     {
     if (mTrW)
       { 
       int tpx, tpy;
       GetScreenPos(tpx, tpy);       
       tpy -= (mTrW->YSize()+5);
       if (tpy < 0)  tpy = 0;
       mTrW->SetPos(tpx, tpy);
       mTrW->Show();
       }
     SelPointerShape(PI_CrossPointer);
     }
  Send(Msg(), PIMsg_Active);
  PIDrwTools::SetCurrentBaseWdg(this);
}

void
PIScDrawWdg::Ptr1Move(int x, int y)
{
  UpdateText(x, y);
}

void
PIScDrawWdg::But1Release(int x, int y)
{
  if (UpdateText(x, y)) 
    SelPointerShape(PI_ArrowPointer);
  if (mTrW)  mTrW->Hide();
}

bool
PIScDrawWdg::UpdateText(int xp, int yp)
{

  float dx, dy;
  mBDrw->GetGraphicUC()->GrC2UC(xp, yp, dx, dy); 
  mPPos[0] = dx;  mPPos[1] = dy; 
  if ((mTxw == NULL) && (mTrlb == NULL)) return(false);
  
  string ctxt =  GetClickText(dx, dy);

  if (mTxw)
    mTxw->SetLabel(ctxt);
  if (mTrlb)
    mTrlb->SetLabel(ctxt);
  return(true);

}

// Gestion du zoom
void
PIScDrawWdg::But2Press(int x, int y)
{
  xEndDrag = xBegDrag = x;
  yEndDrag = yBegDrag = y;
  cForCol = mWGrC->GetForeground();
  cGOmod  = mWGrC->GetGOMode();
  cPointer = GetPointerShape();
  cLatt = mWGrC->GetLineAtt();
  SelPointerShape(PI_CrossPointer);
  mWGrC->SelForeground(PI_Magenta);
  mWGrC->SelGOMode(PI_GOXOR);
  mWGrC->SelLine(PI_ThinLine);
  Send(Msg(), PIMsg_Active);
  PIDrwTools::SetCurrentBaseWdg(this);
}

void
PIScDrawWdg::But2Release(int /*x*/, int /*y*/)
{

  mWGrC->DrawBox(xBegDrag, yBegDrag, xEndDrag-xBegDrag, yEndDrag-yBegDrag);

  mWGrC->SelForeground(cForCol);
  mWGrC->SelGOMode(cGOmod);
  SelPointerShape(cPointer); 
  mWGrC->SelLine(cLatt); 
  
  if (xBegDrag == xEndDrag || yBegDrag == yEndDrag)
    SetLimits(xMinS, xMaxS, yMinS, yMaxS, kAxeDirSame, kAxeDirSame );
  else {
    float xl,yl,xh,yh;
    mBDrw->GetGraphicUC()->GrC2UC(xBegDrag, yBegDrag, xl, yl);
    mBDrw->GetGraphicUC()->GrC2UC(xEndDrag, yEndDrag, xh, yh);
    if (xl > xh) swap(xl, xh);
    if (yl > yh) swap(yl, yh);
    SetLimits(xl,xh,yl,yh, kAxeDirSame, kAxeDirSame, true);
  }
  
  Refresh();
}

void
PIScDrawWdg::Ptr2Move(int x, int y)
{
  mWGrC->DrawBox(xBegDrag, yBegDrag, xEndDrag-xBegDrag, yEndDrag-yBegDrag);
  xEndDrag = x;
  yEndDrag = y;
  mWGrC->DrawBox(xBegDrag, yBegDrag, xEndDrag-xBegDrag, yEndDrag-yBegDrag);
}


// ----------------------------------------------------------
//  Classe de trace de points/fonctions Y=f(X)
//  Trace Y=ay->Value() = f(X= ax->Value()) si ax et ay != NULL
//  Trace Y=ax->Value() = f(X= ax->X())  si ay == NULL
// ----------------------------------------------------------

/* --Methode-- */
PIYfXDrawer::PIYfXDrawer(P1DArrayAdapter* ax, P1DArrayAdapter* ay, bool ad)
    : PIDrawer()
{
  mAdDO = ad;
  mAx = ax;
  mAy = ay;
  if ((mAx == NULL))  mSz = 0;
  else {
    if (!mAy)  mSz = mAx->Size();
    else   mSz = (mAx->Size() < mAy->Size()) ? mAx->Size() :  mAy->Size();
    }
} 

/* --Methode-- */
PIYfXDrawer::~PIYfXDrawer()
{
  if (mAdDO && mAx)  delete mAx;
  if (mAdDO && mAy)  delete mAy;
}

/* --Methode-- */
void PIYfXDrawer::UpdateLimits()
{
  if (mSz <= 0)  return;
  float xmin, xmax, ymin, ymax;
  int i=0;
  float cv;
  if (mAy) {
    xmin = xmax = mAx->Value(0);
    ymin = ymax = mAy->Value(0);
    for(i=1; i<mSz; i++) {
      cv = mAx->Value(i); 
      if (cv < xmin)  xmin = cv;
      if (cv > xmax)  xmax = cv;
      cv = mAy->Value(i); 
      if (cv < ymin)  ymin = cv;
      if (cv > ymax)  ymax = cv;
      }
    }
  else {
    xmin = xmax = mAx->X(0);
    ymin = ymax = mAx->Value(0);
    for(i=1; i<mSz; i++) {
      cv = mAx->X(i); 
      if (cv < xmin)  xmin = cv;
      if (cv > xmax)  xmax = cv;
      cv = mAx->Value(i); 
      if (cv < ymin)  ymin = cv;
      if (cv > ymax)  ymax = cv;
      }
    }

  float dx, dy;
  dx = 0.02*(xmax-xmin);
  dy = 0.02*(ymax-ymin);

  SetLimits(xmin-dx, xmax+dx, ymin-dy, ymax+dy);
  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
}


/* --Methode-- */
void PIYfXDrawer::Draw(PIGraphicUC* g, float xmin, float ymin, float xmax, float ymax)
{
  float xp,yp;
  int i;

  if (mSz <= 0)  return;

//  Trace des markers 
  if ( (mMrk != PI_NotDefMarker) ||  (mLAtt == PI_NotDefLineAtt) ) {
    for(i=0; i<mSz; i++) {
      if (mAy) { xp = mAx->Value(i); yp = mAy->Value(i); }
      else { xp = mAx->X(i);  yp = mAx->Value(i); }
      if ( (xp < xmin) || (xp > xmax) || (yp < ymin) || (yp > ymax) )  continue;
      g->DrawMarker(xp, yp);
    }
  }

  if (mLAtt == PI_NotDefLineAtt)    return;

// Trace des lignes 
  float xp2, yp2;
  if (mAy) { xp = mAx->Value(0); yp = mAy->Value(0); }
  else { xp = mAx->X(0);  yp = mAx->Value(0); }
  for(i=1; i<mSz; i++) {
    if (mAy) { xp2 = mAx->Value(i); yp2 = mAy->Value(i); }
    else { xp2 = mAx->X(i);  yp2 = mAx->Value(i); }
    if ( ((xp < xmin) || (xp > xmax) || (yp < ymin) || (yp > ymax)) &&
         ((xp2 < xmin) || (xp2 > xmax) || (yp2 < ymin) || (yp2 > ymax)) )  continue;
    g->DrawLine(xp, yp, xp2, yp2);
    xp = xp2; yp = yp2;
  }
}
