#include <stdio.h>
#include <X11/cursorfont.h>
#include "piapplx.h"
#include "picontainerx.h"


// Pour rediriger stdout 
#include <unistd.h>
#include <fcntl.h>

#include <iostream.h>


// #define DEBUG_APPLX

static Cursor a_curs[3];
static bool a_fgcur=false;

//  Voir fichier pimenux.cc , Pour resoudre certains conflits avec les WindowManagers
void SetTopWdgForMenuX(SysDWdg mtw);

static PIApplication* cur_piapp = NULL;
PIApplication* PIApplicationGetApp() { return cur_piapp; }


// Classe de container special pour top-container de Application X

class PITopContAppX : public PIContainer {
public :
	    	PITopContAppX(PIContainer *par, char *nom,
                          int sx=10, int sy=10, int px=0, int py=0);
   virtual  	~PITopContAppX(); 

   virtual void SetSize(int sx, int sy);
   virtual void SetPos(int px, int py);
};

/* --Methode-- */
PITopContAppX::PITopContAppX(PIContainer *par, char *nom, int sx, int sy, int px, int py)
        : PIContainer(par, nom, sx, sy, px, py)
{
  SetBinding(PIBK_fixed, PIBK_fixed, PIBK_fixed, PIBK_fixed);
}

/* --Methode-- */
PITopContAppX::~PITopContAppX()
{
}

/* --Methode-- */
void PITopContAppX::SetSize(int sx, int sy)
{
Parent()->SetSize(sx+XPos(), sy+YPos());
PIContainer::SetSize(sx, sy);
}

/* --Methode-- */
void PITopContAppX::SetPos(int px, int py)
{
}

/* --Methode-- */
PIApplicationX::PIApplicationX(int sx, int sy, int narg, char *arg[])
: PIApplicationGen()
{
int sxt, syt;

#ifdef DEBUG_APPLX
puts("PIApplicationX::PIApplicationX()_info : App creation");
#endif
mStop = true;
topwdg = new PIWdgX(narg, arg);

intcont = new PIContainerX((PIMsgHandler *)this, topwdg, "MBCont", 
                            10, 10, 0, 0);
// Pb avec les Popup MenuX et certains Window Manager , voir pimenux.cc
SetTopWdgForMenuX(intcont->XtWdg());

menubar = new PIMenubar(this, "DefMenubar");
Menubar()->SetBinding(PIBK_fixed, PIBK_fixed, PIBK_fixed, PIBK_free);
sxt = ( sx > Menubar()->XSize() ) ? sx : Menubar()->XSize();
syt = ( sy > 0 ) ? sy : 0;
int msx,msy;
PrefCompSz(msx, msy);
//syt += Menubar()->YSize();
syt += msy;
MBCont()->SetSize(sxt, syt);
if (sx < sxt)  sx = sxt;
if (sy < 10) sy = 10;
topcont = new PITopContAppX(MBCont(), "TopLevelCont", 
                            sx, sy, 0, msy);
topcont->Show();

MBCont()->Show();
topwdg->Manage();

if (!a_fgcur)
  {
  Display *mdsp;
  mdsp = XtDisplay (topwdg->XtWdg()); 
  a_curs[0] = XCreateFontCursor(mdsp, XC_arrow);
  a_curs[1] = XCreateFontCursor(mdsp, XC_X_cursor);
  a_curs[2] = XCreateFontCursor(mdsp, XC_watch);
  }

cur_piapp = this;
mState = -1;
SetReady();
}

/* --Methode-- */
PIApplicationX::~PIApplicationX()
{
#ifdef DEBUG_APPLX
puts("PIApplicationX::~PIApplicationX()_info : App delete");
#endif
Display *mdsp;
mdsp = XtDisplay (topwdg->XtWdg()); 
topwdg->UnManage();
delete menubar;
if (topcont != MBCont())  delete topcont;
delete intcont;
delete topwdg;
XtCloseDisplay(mdsp);
cur_piapp = NULL;
return;
}

/* --Methode-- */
void PIApplicationX::Run()
{
XEvent evt;
#ifdef DEBUG_APPLX
puts("PIApplicationX::Run()_info : App Run ");
#endif

topwdg->SetSize(MBCont()->XSize(), MBCont()->YSize());

int szx, szy, szf;
XtAppContext * appctx = PIXtAppCtx(szx, szy, szf);

// Pour appeler FinishCreate() des objets dans la fenetre principale 
MBCont()->FinishCreate();
while (mStop)
  {
  XtAppNextEvent(*appctx, &evt);
  XtDispatchEvent(&evt);
  }
return;
}


/* --Methode-- */
void PIApplicationX::SetReady()
{
if (mState != kReadyState)
  {
  Display * mdsp;
  mState = kReadyState;
  Menubar()->SetSensitive();
  mdsp = XtDisplay (topwdg->XtWdg());
  XDefineCursor(mdsp, XtWindow(topwdg->XtWdg()), a_curs[0]);
  XFlush(mdsp);
  }
}

/* --Methode-- */
void PIApplicationX::SetBusy()
{
if (mState != kBusyState)
  {
  Display * mdsp;
  mState = kBusyState;
  Menubar()->SetSensitive();
  mdsp = XtDisplay (topwdg->XtWdg());
//  if ( XtIsRealized(topwdg->XtWdg()) )
  XDefineCursor(mdsp, XtWindow(topwdg->XtWdg()), a_curs[2]);
  XFlush(mdsp);
  }
return;
}

/* --Methode-- */
void PIApplicationX::SetBlocked()
{
if (mState != kBlockedState)
  {
  Display * mdsp;
  mState = kBlockedState;
  Menubar()->SetUnSensitive();
  mdsp = XtDisplay (topwdg->XtWdg());
  XDefineCursor(mdsp, XtWindow(topwdg->XtWdg()), a_curs[1]);
  XFlush(mdsp);
  }
}


/* --Methode-- */
void PIApplicationX::PrefCompSz(int& szx, int& szy)
{
int szf;
PIXtAppCtx(szx, szy, szf);
return;
}

/* --Methode-- */
void PIApplicationX::ScreenSz(int& szx, int& szy)
{
Display * dsp = PIXDisplay();
szx = DisplayWidth(dsp, DefaultScreen(dsp));
szy = DisplayHeight(dsp, DefaultScreen(dsp));
}



/* Call-Back - Fonction privee de ce fichier */
static void redirectstream_callback(XtPointer, int *, XtInputId*);

static PIConsole* consstream[2] = {NULL, NULL};
static unsigned char streamva[2] = { PIVA_Def, PIVA_Ital};
static int streamno[2] = {0,1};
static XtInputId inputid[2];
static int origfiledes[2]={-1, -1};   // descripteurs de fichiers de depart
static bool firstcall[2]={true, true};    // 1er appel a Redirect

static void redirectstream_callback(XtPointer cld, int * fd, XtInputId* /*iid*/)
{
char buff[128];
int nr;

int idx = *((int*)cld);
if (idx != 1) idx = 0; 
if (!consstream[idx]) return;
while ( (nr=read(*fd, buff, 127)) > 0 ) {
  buff[nr] = '\0'; consstream[idx]->AddStr(buff, streamva[idx], false);
  }
consstream[idx]->Refresh();
}

/* --Methode-- */
void PIApplicationX::RedirectOutStream(PIConsole* cons, unsigned char va)
{
if ( origfiledes[0]<0 )  origfiledes[0] = fcntl(1, F_DUPFD);     
if ( cons == consstream[0]) return;
if ( (consstream[0]) && (cons) ) { consstream[0] = cons; streamva[0] = va; return; }
else if (!cons) { 
  consstream[0] = NULL;  
  XtRemoveInput(inputid[0]);
  dup2(origfiledes[0], 1);
  return;
  }

consstream[0] = cons; streamva[0] = va;

int p[2];
pipe(p);
// Redirection de stdout (fid=1) :  
close(1);
dup(p[1]);
close(p[1]);
fcntl(p[0], F_SETFL, O_NONBLOCK);

setlinebuf(stdout);
ios::sync_with_stdio();

int szx, szy, szf;
XtAppContext * appctx = PIXtAppCtx(szx, szy, szf);
inputid[0] = XtAppAddInput(*appctx, p[0], (XtPointer) XtInputReadMask, 
                           redirectstream_callback, (XtPointer) streamno);
}

/* --Methode-- */
void PIApplicationX::RedirectErrStream(PIConsole* cons, unsigned char va)
{
if ( origfiledes[1]<0 )  origfiledes[1] = fcntl(2, F_DUPFD);     
if ( cons == consstream[1]) return;
if ( (consstream[1]) && (cons) ) { consstream[1] = cons; streamva[1] = va; return; }
else if (!cons) { 
  consstream[1] = NULL;  
  XtRemoveInput(inputid[1]);
  dup2(origfiledes[1], 2);
  return;
  }

consstream[1] = cons; streamva[1] = va;

int p[2];
pipe(p);
// Redirection de stderr (fid=2) :
close(2);
dup(p[1]);
close(p[1]);
fcntl(p[0], F_SETFL, O_NONBLOCK);

setlinebuf(stderr);
ios::sync_with_stdio();

int szx, szy, szf;
XtAppContext * appctx = PIXtAppCtx(szx, szy, szf);
inputid[1] = XtAppAddInput(*appctx, p[0], (XtPointer) XtInputReadMask, 
                           redirectstream_callback, (XtPointer) (streamno+1));
}

