#include <stdio.h>
#include "pihisto.h"

PIHisto::PIHisto(Histo* histo, bool ad)
: PIDrawer(), mHisto(histo)
{
  mAdDO = ad;     // Flag pour suppression automatique de mHisto
}

PIHisto::~PIHisto()
{
  if (mAdDO)
    delete mHisto;
}



void
PIHisto::UpdateLimits()
{
  if (!mHisto)  return;  
  SetLimits(mHisto->XMin(), mHisto->XMax(), mHisto->VMin(), mHisto->VMax()*1.2);
  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);
}


void
PIHisto::Draw(PIGraphicUC* g, float /*xmin*/, float /*ymin*/, float /*xmax*/, float /*ymax*/)
{
  if (!mHisto)  return;  
  if (mLAtt != PI_NotDefLineAtt) {
    float x1,y1, x2, y2;
    x1 = mHisto->BinLowEdge(0);
    y1 = 0; 
    for (int i=0; i<mHisto->NBins(); i++) {
      x2 = x1; 
      y2 = (*mHisto)(i);
      g->DrawLine(x1,y1, x2, y2);
      y1 = y2; 
      x2 = mHisto->BinHighEdge(i);
      g->DrawLine(x1,y1, x2, y2);
      x1 = x2; 
      }
      y2 = 0; g->DrawLine(x1,y1, x2, y2);
    }
  else for (int i=0; i<mHisto->NBins(); i++) {
		float left   = mHisto->BinLowEdge(i);
		float width  = mHisto->BinWidth();
		float bottom = 0;
		float height = (*mHisto)(i);
		g->DrawFBox(left,bottom,width,height);
		g->DrawLine(left, bottom, left, bottom + height); // Au moins une ligne...
	}
  DrawStats(g);
}

void
PIHisto::DrawStats(PIGraphicUC* g)
{
  if (!mHisto) return;
  if (mLAtt == PI_NotDefLineAtt)  g->SelLine(PI_ThinLine);
  float cellHeight = (YMax() - YMin()) * 0.05;
  float cellWidth  = (XMax() - XMin()) * 0.23;
  g->DrawLine(XMax() - cellWidth, YMax(),
                       XMax() - cellWidth, YMax() - cellHeight);
  g->DrawLine(XMax() - cellWidth, YMax() - cellHeight,
                       XMax()            , YMax() - cellHeight);
  char label[50];
  sprintf(label, "N = %.6g", mHisto->NData());
  g->SelFontSz((YMax() - YMin())/30);
  g->DrawString(XMax() - cellWidth*0.9, YMax() - cellHeight*0.8, label);
                       
}
