#include "toisqfilter.h"
#include "toimanager.h"

void TOISqFilter::init() {
  cout << "TOISqFilter::init" << endl;
  declareInput("signal");
  declareOutput("out");
  name = "sqfilt";
  upExtra = 1;
}

void TOISqFilter::run() {
  TOIManager* mgr = TOIManager::getManager();
  int snb = getMinOut();
  int sne = getMaxOut();

  for (int sn = snb; sn <= sne; sn++) {
    try {
      double x1 = getData(0, sn);
      double x2 = getData(0, sn+1);
      double y = (x1+x2)/2;
      putData(0, sn, y);
    } catch (PException e) {
      cout << "TOISqFilter exception " << e.Msg() << endl;
      continue;
    }
  }
}
