#include "fitstoiwtr.h"
#include "toimanager.h"



extern void fits_lock();
extern void fits_unlock();

FITSTOIWriter::FITSTOIWriter(string fn) {
  fname = fn;
  fstatus = 0;

  // Open file
  remove(fname.c_str()); 
  fits_lock();
  fits_create_file(&fptr,fname.c_str(),&fstatus);
  fits_unlock();
  name = "wtr";
}

FITSTOIWriter::~FITSTOIWriter() {
}

void FITSTOIWriter::addInput(string name, TOI* toi) {
  declareInput(name);
  fwinputs.push_back(toi);
}


void FITSTOIWriter::run() {
  cout << "fitstoiwriter running" << endl;
  // init done here
  delete[] inTOIs;
  inTOIs = new (TOI*[fwinputs.size()]);

  for (int i=0; i<fwinputs.size(); i++) {
    inTOIs[i] = fwinputs[i];
  }

  int ncols = inIx.size();

  char** colnames = new (char*[ncols]);
  char** coltypes = new (char*[ncols]);
  char** colunits = new (char*[ncols]);

  for (map<string, int>::iterator i = inIx.begin(); i != inIx.end(); i++) {
    int j = (*i).second;
    string n = (*i).first;
    colnames[j] = const_cast<char*>(n.c_str());
    coltypes[j] = "1D";
    colunits[j] = "?";
  }

  fits_lock();
  fits_create_tbl(fptr, BINARY_TBL, 0, ncols, colnames, coltypes, colunits, NULL, &fstatus);
  fits_write_date(fptr, &fstatus);
  fits_unlock();

  delete[] colunits;
  delete[] coltypes;
  delete[] colnames;

  // Add headers ?

  // loop

  int fitsLine = 1;
  TOIManager* mgr = TOIManager::getManager();
  // int snb = mgr->getRequestedBegin();
  //int sne = mgr->getRequestedEnd();
  int snb = getMinIn();
  int sne = getMaxIn();

  for (int sn = snb; sn <= sne; sn++) {
    try {
      for (int i=0; i<ncols; i++) {
	//	cout << "wtr req " << sn << endl;
	double x = getData(i, sn);
	//	cout << "wtr got " << sn << endl;
	fits_lock();
	fits_write_col_dbl(fptr, i+1, fitsLine, 1, 1, &x, &fstatus);
	if (fstatus != 0) {
	  cerr << "fitstoiwtr error sn = " << sn << " i = "<< i << endl;
	  fits_report_error(stderr, fstatus);
	  abort();
	}
	fits_unlock();
      }
    } catch (PException e) {
      cout << "fitstoiwtr exception " << e.Msg() << endl;
      continue;
    }
    fitsLine++;
  }

  fits_lock();
  fits_close_file(fptr, &fstatus);
  fits_report_error(stderr, fstatus);
  fits_unlock();
  cout << "fitstoiwriter done" << endl;
}








