#include "fitstoirdr.h"
#include "toimanager.h"



FITSTOIReader::FITSTOIReader(string fn) {
  fname = fn;
  cout << "FITSTOIReader::FITSTOIReader" << endl;
  cout << "FITSTOIReader::inited " << inited << endl;
  name = "rdr";
}

FITSTOIReader::~FITSTOIReader() {
}

pthread_mutex_t fits_mutex = PTHREAD_MUTEX_INITIALIZER;
void fits_lock();
void fits_unlock();

void fits_lock() {
  pthread_mutex_lock(&fits_mutex);
}
void fits_unlock() {
  pthread_mutex_unlock(&fits_mutex);
}

void FITSTOIReader::init() {
  fits_lock();
  cout << "FITSTOIReader::init" << endl;
  fstatus = 0;
  // Open file
  fits_open_file(&fptr,fname.c_str(),READONLY,&fstatus);
  if (fstatus != 0) {
    fits_report_error(stderr, fstatus);
    fits_unlock();
    exit (-1);
  }
  
  // Go to first extension, which should be a BINTABLE
  
  int simple, bitpix, naxis;
  long naxes;
  long pcount, gcount;
  int extend;
  fits_read_imghdr(fptr, 1, &simple, &bitpix, 
		   &naxis, &naxes, &pcount, &gcount, &extend, &fstatus);
  
  fits_movabs_hdu(fptr, 2, NULL, &fstatus);
  
  int ncols;
  fits_get_num_cols(fptr,&ncols,&fstatus);
  fits_get_num_rows(fptr,&nrows,&fstatus);

  cout << "FITSTOIReader cols = " << ncols << endl;

  // Dans cette version, on s'attend a ce que la premiere colonne soit le samplenum
  for (int i=1; i<ncols; i++) {
    char templt[10];
    sprintf(templt, "%d", i+1);
    char colname[200];
    int colnum;
    fits_get_colname(fptr, CASESEN, templt, colname, &colnum, &fstatus);
    cout << "FITSTOIReader col " << colname << endl;
    declareOutput(colname);
  }
  int anyNul;
  double y;
  fits_read_col_dbl(fptr,1,1,1,1,0,&y,&anyNul,&fstatus);
  firstSn = (int) (y+.1);
  fits_unlock();
}

int FITSTOIReader::calcMinOut() {
  TOIManager* mgr = TOIManager::getManager();
  int firstReq = mgr->getRequestedBegin();
  return firstSn > firstReq ? firstSn : firstReq;
}

int FITSTOIReader::calcMaxOut() {
  TOIManager* mgr = TOIManager::getManager();
  int lastReq = mgr->getRequestedEnd();
  int lastSn  = firstSn + nrows - 1;
  return lastSn < lastReq ? lastSn : lastReq;
}


void FITSTOIReader::run() {
  // Il faudrait optimiser en fonction de ce qui a ete demande comme samplenum,
  // mais cela implique de gerer aussi bien echant uniforme que non.
  // On pourrait aussi lire plusieurs elements d'un coup.
  int ncols = outIx.size();
  cout << "reader reading..." << endl;
  for (int i=0; i<nrows; i++) {
    int anyNul;
    double y;
    fits_lock();
    fits_read_col_dbl(fptr,1,i+1,1,1,0,&y,&anyNul,&fstatus);
    fits_unlock();
    int sn = (int) (y+.1);
    TOIManager* mgr = TOIManager::getManager();
    if (sn > mgr->getRequestedEnd()) break;
    if (sn < mgr->getRequestedBegin()) continue;
    //    if (sn < mgr->getRequestedBegin()+10) cout << "rdr out " << sn << endl;
    for (int j=1; j<=ncols; j++) {
      fits_lock();
      fits_read_col_dbl(fptr,j+1,i+1,1,1,0,&y,&anyNul,&fstatus);
      fits_unlock();
      putData(j-1, sn, y);
    }
  }
  cout << "reader done reading... " << pthread_self() << endl;
}
