#include "asciitoiwtr.h"
#include "toimanager.h"

ASCIITOIWriter::ASCIITOIWriter(string fn) 
  : fname(fn), s(fn.c_str()) 
{
  name = "ascii writer";
  outFlags = false;
}

ASCIITOIWriter::~ASCIITOIWriter()
{}

void ASCIITOIWriter::setOutFlags(bool yn) {
  outFlags = yn;
}

void ASCIITOIWriter::addInput(string name, TOI* toi) {
  declareInput(name);
  fwinputs.push_back(toi);
}


void ASCIITOIWriter::run() {
  cout << "asciitoiwriter running" << endl;
  // init done here
  delete[] inTOIs;
  inTOIs = new (TOI*[fwinputs.size()]);

  for (int i=0; i<fwinputs.size(); i++) {
    inTOIs[i] = fwinputs[i];
  }

  int ncols = inIx.size();


  TOIManager* mgr = TOIManager::getManager();
  int snb = getMinIn();
  int sne = getMaxIn();

  for (int sn = snb; sn <= sne; sn++) {
    s << sn << "   ";
    for (int i=0; i<ncols; i++) {
      double x = getData(i, sn);
      s << x << "   ";
      if (outFlags) {
	int_4 f = getFlag(i, sn);
	s << f << "   ";
      }
    }
    s << '\n';
  }
}
