
#include "ntupintf.h"
#include <stdlib.h>
#include <stdio.h>

/*!
   \class SOPHYA::NTupleInterface
   \ingroup HiStats
   Interface class (pure virtual) defining generic operations on NTuple,
   a 2-dimensional data set with named columns
*/

//++
// Class	NTupleInterface
// Lib	Outils++ 
// include	ntupintf.h
//
//	Interface permettant de construire des vues NTuples (tableau lignes-colonnes) 
//	pour differents objets. Toutes les methodes ont une implementation par defaut. 
//--

//++
// NTupleInterface()
//	Constructeur.
// virtual ~NTupleInterface()
//	Destructeur
// uint_4  NbLines() const 
//	Nombre de lignes du tableau
// uint_4  NbColumns() const 
//	Nombre de colonnes du tableau
// r_8 *  GetLineD(int n) const
//	Renvoie un tableau avec le contenu de la ligne "n"
// r_8	GetCell(int n, int k) const
//	Renvoie le contenu de la cellule correspondant a la ligne "n"
//	et colonne "k"
// r_8  GetCell(int n, string const & nom) const
//	Renvoie le contenu de la cellule correspondant a la ligne "n"
//	pour la colonne identifiee par "nom"
// string  GetCelltoString(int n, int k) const
//	Renvoie le contenu de la cellule correspondant a la ligne "n"
//	et colonne "k", sous forme de chaine de caracteres.
// string  GetCell(int n, string const & nom) const
//	Renvoie le contenu de la cellule correspondant a la ligne "n"
//	pour la colonne identifiee par "nom", sous forme de chaine de caracteres.
// void GetMinMax(int k, double& min, double& max)  const
//	Renvoie la valeur mini et maxi de la colonne numero "k"
// void	GetMinMax(string const & nom, double& min, double& max)
//	Renvoie la valeur mini et maxi de la colonne identifiee par "nom"
// int  ColumnIndex(string const & nom)  const
//	Renvoie le numero de colonne identifiee par "nom". Renvoie -1 (negatif)
//	si colonne "nom" n'existe pas.
// string ColumnName(int k) const
//	Renvoie le nom de la colonne numero "k"
// string VarList_C(const char* nomx=NULL) const
//	Renvoie une chaine avec les declarations "C" pour les
//	variables avec les noms de colonnes
// string  LineHeaderToString()
//	Renvoie une chaine avec les noms de colonnes, utilisables pour l'impression
// string  LineToString(int n)
//	Renvoie une chaine avec le contenu de la ligne "n", utilisable pour l'impression
//--

/* --Methode-- */
NTupleInterface::NTupleInterface()
{
}
/* --Methode-- */
NTupleInterface::~NTupleInterface()
{
}

//! Retuns the number of lines (rows) of the data set
/* --Methode-- */
uint_4 NTupleInterface::NbLines() const
{
return(0);
}

//! Retuns the number of columns of the data set 
/* --Methode-- */
uint_4 NTupleInterface::NbColumns() const
{
return(0);
}

//! Retuns the content of a given line 
/*! 
   An array (double *) containg all cells of a given line, converted to 
   float values is returned
*/
/* --Methode-- */
r_8 * NTupleInterface::GetLineD(int ) const
{
return(NULL);
}

//! Returns the content of a given cell
/*!
    The cell is identified by the line and column number. Its content is
    converted to a floating value.
*/
/* --Methode-- */
r_8 NTupleInterface::GetCell(int , int ) const
{
return(0.);
}

//! Returns the content of a given cell
/*!
    The cell is identified by the line number and column name. Its content is
    converted to a floating value.
*/
/* --Methode-- */
r_8 NTupleInterface::GetCell(int n, string const & nom) const
{
return(GetCell(n, ColumnIndex(nom)));
}

//! Returns the string representation of a given cell
/*!
    The cell is identified by the line and column number. Its content is
    converted to a string.
*/
string NTupleInterface::GetCelltoString(int n, int k) const
{
char strg[64];
//sprintf(strg,"C%d= %g\n", k, GetCell(n, k));
sprintf(strg,"%g\n", GetCell(n, k));
return(strg);
}

//! Returns the string representation of a given cell
/*!
    The cell is identified by the line number and column name. Its content is
    converted to a string.
*/
string NTupleInterface::GetCelltoString(int n, string const & nom) const
{
return(GetCelltoString(n, ColumnIndex(nom)));
}

//! Returns the minimum and maximum values for a given column
/* --Methode-- */
void NTupleInterface::GetMinMax(int , double& min, double& max)   const
{
min = max = 0.;
}

/* --Methode-- */
//! Returns the minimum and maximum values for a given named column
void NTupleInterface::GetMinMax(string const & , double& min, double& max)   const
{
min = max = 0.;
}

/* --Methode-- */
//! Returns the column index given the column name
int NTupleInterface::ColumnIndex(string const & nom)  const
{
return(-1);
}

/* --Methode-- */
//! Returns the column name corresponding to a column index.
string NTupleInterface::ColumnName(int k) const
{
return("");
}

/* --Methode-- */
string NTupleInterface::VarList_C(const char*) const
{
return("");
}

/* --Methode-- */
string NTupleInterface::LineHeaderToString() const
{
return("");
}

/* --Methode-- */
string NTupleInterface::LineToString(int ) const
{
return("");
}



