// Module PI : Peida Interactive     PIGraphic 
// Primitives de trace graphiques    R. Ansari  97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIGRAPHICGEN_H_SEEN
#define PIGRAPHICGEN_H_SEEN

#include "pisysdep.h"

#include PIWDG_H
#include PICMAP_H


enum PIColors  { PI_ColorFromMap = -2, PI_NotDefColor = -1, 
                 PI_Black = 0, PI_White = 1,  PI_Grey = 2,
                 PI_Red = 3, PI_Blue = 4, PI_Green = 5,  
                 PI_Yellow = 6, PI_Magenta = 7, 
                 PI_Cyan = 8, PI_Turquoise = 9, PI_NavyBlue = 10, 
                 PI_Orange = 11, PI_SiennaRed = 12, PI_Purple = 13,  
                 PI_LimeGreen = 14, PI_Gold = 15 };

enum PIFontSize { PI_NotDefFontSize = -1, 
                  PI_SmallSizeFont = 1, PI_NormalSizeFont = 2, PI_BigSizeFont = 3 };

enum PIFontAtt { PI_NotDefFontAtt = -1,
                 PI_RomanFont = 1, PI_BoldFont = 2, PI_ItalicFont = 4 };

enum PILineAtt { PI_NotDefLineAtt = -1,
                 PI_NormalLine = 0, PI_ThinLine = 1, PI_ThickLine = 2 };

enum PIMarker  { PI_NotDefMarker = -1,
                 PI_DotMarker = 0, PI_PlusMarker=1, PI_CrossMarker=2,  
                 PI_CircleMarker=3, PI_FCircleMarker=4,
                 PI_BoxMarker=5, PI_FBoxMarker=6,
                 PI_TriangleMarker=7, PI_FTriangleMarker=8,
                 PI_StarMarker=9, PI_FStarMarker=10 };

enum PIGOMode { PI_GOCopy = 0, PI_GOXOR = 1 }; 


//  Classe pour gerer indifferement des coordonnees float ou int 
class PIGrCoord {
public:
  inline PIGrCoord() { iv = 0; fv = 0.;}
  inline PIGrCoord(int a) { iv = a; fv = (float)a;}
  inline PIGrCoord(float a) { iv = (int)a; fv = a;}
  inline PIGrCoord(double a) { iv = (int)a; fv = (float)a;}
  inline operator int() { return(iv); }
  inline operator short() { return((short)iv); }
  inline operator unsigned int() { return((unsigned int)iv); }
  inline operator unsigned short() { return((unsigned short)iv); }
  inline operator float() { return(fv); }
  inline PIGrCoord& operator= (int a) { iv = a; fv = (float)a; return(*this); }
  inline PIGrCoord& operator= (float a) { iv = (int)a; fv = a; return(*this); }
  inline PIGrCoord& operator= (double a) { iv = (int)a; fv = (float)a; return(*this); }
  int iv;
  float fv;
};

enum PIGraphicsType { PI_ScrWindowGraphics = 0, PI_PSFileGraphics = 1, 
                      PI_UCGraphics = 2, PI_3DGraphics = 3 };

// Classe generique de trace graphique de base :

class PIGraphicGen
{
public:
                     PIGraphicGen();
                     PIGraphicGen(PIWdg* wdg);
  virtual           ~PIGraphicGen();

  virtual int        kind();

//  Espace des coordonnees
  virtual void       GetGrSpace(PIGrCoord& xmin, PIGrCoord& xmax, PIGrCoord& ymin, PIGrCoord& ymax); 

//  Trace graphiques
  virtual void       Erase(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)     = 0;
  virtual void       DrawString(PIGrCoord x, PIGrCoord y, char* s, int pos = 0)        = 0;
  virtual void       DrawOpaqueString(PIGrCoord x, PIGrCoord y, char* s, int pos = 0)  = 0;
  virtual void       DrawLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2)  = 0;
  virtual void       DrawBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)   = 0;
  virtual void       DrawFBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)  = 0;
  virtual void       DrawCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r)               = 0;
  virtual void       DrawFCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r)              = 0;
  virtual void       DrawPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true)    = 0;  
  virtual void       DrawFPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc=true)   = 0;  
  virtual void       DrawMarker(PIGrCoord x0, PIGrCoord y0)                            = 0;
  virtual void       DrawMarkers(PIGrCoord *x, PIGrCoord *y, int n)                    = 0;
  virtual void       DrawPixmap(PIGrCoord x, PIGrCoord y, unsigned char *pix, 
                                int sx, int sy, PIColorMap* cmap)              = 0;

// Modifications attributs graphiques
  virtual void       SelForeground(PIColors col=PI_Black)                      = 0;
  virtual void       SelBackground(PIColors col=PI_White)                      = 0;
  virtual void       SelForeground(PIColorMap& cmap, int cid)                  = 0;
  virtual void       SelBackground(PIColorMap& cmap, int cid)                  = 0;
  virtual void       SelGOMode(PIGOMode mod=PI_GOCopy)                         = 0;
  virtual void       SelFont(PIFontSize sz=PI_NormalSizeFont, 
                             PIFontAtt att=PI_RomanFont)                       = 0;
  virtual void       SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont)       = 0; 
  virtual void       SelLine(PILineAtt att=PI_NormalLine)                      = 0;
  virtual void       SelMarker(int msz=3, PIMarker mrk=PI_DotMarker)           = 0;

// Selection de zone de trace (clip)
  virtual void       SetClipRectangle(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)  = 0;
  virtual void       ClearClipRectangle()                                      = 0;

// Acces aux attributs graphiques 
  virtual PIColors   GetForeground()    = 0;
  virtual PIColors   GetBackground()    = 0;
  virtual PIGOMode   GetGOMode()        = 0;
  virtual PIFontAtt  GetFontAtt()       = 0;
  virtual int        GetFontSize()      = 0;
  virtual PILineAtt  GetLineAtt()       = 0;
  virtual PIMarker   GetMarker()        = 0;
  virtual int        GetMarkerSize()    = 0;

  virtual int        GetFontHeight(int& asc, int& desc)      = 0;
  virtual PIGrCoord  CalcStringWidth(char const* s)          = 0;

// Sauvegarde des attributs graphiques 
  virtual void       SaveGraphicAtt();
  virtual void       RestoreGraphicAtt();

protected:
// Pour Save/Restore des attributs graphiques 
  PIWdg* myWdg;

  PIColors  sFCol, sBCol;
  PIGOMode sGOm;
  PIFontAtt sFAtt;
  PILineAtt sLAtt;
  int sFSize;
  PIMarker sMrk;
  int sMrkSz;
};

#endif

typedef PIGraphicGen PIGraphic;

// hierarchie apparente
//   PIGraphic               ( == Gen, mais pas visible de l'utilisateur).
//     PIGraphicWin   ( == X ou Mac)
//     PIGraphicPS
//     PIGraphicUC
