// Module PI : Peida Interactive     PIGraphicUC 
// Trace graphiques User-Coordinates    R. Ansari  97
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "pigraphuc.h"


// Pour echanger deux valeurs PIGrCoord
static float swpfl;
static inline void fl_swap(float& grc1, float& grc2)
{ swpfl = grc1; grc1 = grc2; grc2 = swpfl; }

/* --Methode-- */
PIGraphicUC::PIGraphicUC(PIGraphicGen* g, PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
  : PIGraphicGen()
{
  mGrC = g;
  xW0 = x0;  yW0 = y0; 
  xWd = dx;  yWd = dy; 
  aXdir = false;  // Vrai si Axe X de Droite vers Gauche 
  aYdir = false;  // Vrai si Axe Y de Haut vers Bas
  SetUCS(0., 1., 0., 1., kAxeDirLtoR, kAxeDirDownUp);
  clip = true;  
}

/* --Methode-- */
PIGraphicUC::~PIGraphicUC()
{
}

/* --Methode-- */
int PIGraphicUC::kind() 
{
return PI_UCGraphics; 
}

/* --Methode-- */
void PIGraphicUC::SetBaseGraphic(PIGraphicGen* g, PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
{
  mGrC = g;
  xW0 = x0;  yW0 = y0; 
  xWd = dx;  yWd = dy; 
  SetUCS(xMin, xMax, yMin, yMax, kAxeDirSame, kAxeDirSame);
}

/* --Methode-- */
void PIGraphicUC::GetGrSpace(PIGrCoord& xmin, PIGrCoord& xmax, PIGrCoord& ymin, PIGrCoord& ymax)
{
xmin = xMin;  ymin = yMin;  
xmax = xMax;  ymax = yMax;
}


/* --Methode-- */
void PIGraphicUC::SetUCS(float xmin, float xmax, float ymin, float ymax,
                         int axrl, int ayud)
{

  if (axrl == kAxeDirAuto) {
    float ff;
    if (xmax < xmin)  { axrl = kAxeDirRtoL;   ff=xmin;  xmin=xmax;  xmax=ff; }
    else  axrl = kAxeDirLtoR;
  }
  if (ayud == kAxeDirAuto) {
    float ff;
    if (ymax < ymin)  { ayud = kAxeDirUpDown;   ff=ymin;  ymin=ymax;  ymax=ff; }
    else  ayud = kAxeDirDownUp;
  }

  if (xmax <= xmin  || ymax <= ymin)
    return; // $CHECK$ exception ?
  if (axrl == kAxeDirLtoR)  aXdir = false;
  else if (axrl == kAxeDirRtoL)  aXdir = true;
  if (ayud == kAxeDirDownUp)  aYdir = false;
  else if (ayud == kAxeDirUpDown)  aYdir = true;
  xMin = xmin;
  xMax = xmax;
  yMin = ymin;
  yMax = ymax;

  xScale = xWd/(xMax-xMin);
  if (xScale < 1.e-19)  xScale = 1.e-19;  // Protection 
  if (aXdir)  { 
    xScale = -xScale;
    xOrg   = -xMax * xScale;
  }
  else xOrg   = -xMin * xScale;
  xOrg += xW0;

  yScale = yWd/(yMax-yMin);
  if (yScale < 1.e-19)  yScale = 1.e-19;  // Protection 
  if (!aYdir) {
    yScale = -yScale;
    yOrg   = -yMax  * yScale;
    }
  else yOrg   = -yMin * yScale;
  yOrg += yW0;
  return;
}


/* --Methode-- */
void PIGraphicUC::UC2GrC(float x, float y, float& xpix, float& ypix)
{
  xpix = (float)(xOrg + x*xScale);  // $CHECK$ Reza 21/06/98 ? + .5);
  ypix = (float)(yOrg + y*yScale);  // $CHECK$ Reza 21/06/98 ?+ .5);
}

/* --Methode-- */
void PIGraphicUC::GrC2UC(float xpix, float ypix, float& x, float& y)
{
  x = (xpix-xOrg)/xScale;
  y = (ypix-yOrg)/yScale;
}

/* --Methode-- */
void PIGraphicUC::DUC2GrC(float dx, float dy, float& dxpix, float& dypix)
{
  dxpix = dx*xScale;
  if (dxpix < 0)  dxpix = -dxpix;
  dypix = dy*yScale;
  if (dypix < 0)  dypix = -dypix;
}

/* --Methode-- */
void PIGraphicUC::DGrC2UC(float dxpix, float dypix, float& dx, float& dy)
{
  dx = dxpix/xScale;
  dy = dypix/yScale;
  if (dx < 0.) dx = -dx;
  if (dy < 0.) dy = -dy;
}

/* --Methode-- */
void PIGraphicUC::Erase(PIGrCoord xc, PIGrCoord yc, PIGrCoord dxc, PIGrCoord dyc)
{
  if (!mGrC) return;
  float x, y, dx, dy;
  x = xc;  dx = dxc;
  y = yc;  dy = dyc;
  if (clip) {
    if (dx < 0) {
      x = x+dx;
      dx = -dx;
    }
    if (dy < 0) {
      y = y+dy;
      dy = -dy;
    }
    if (x > xMax || x+dx < xMin || y > yMax || y+dy < yMin) return;
    if (x < xMin) {
      dx -= (xMin-x);
      x = xMin;
    }
    if (y < yMin) {
      dy -= (yMin-y);
      y = yMin;
    }
    if (x+dx > xMax)
      dx = (xMax-x);
    if (y+dy > yMax)
      dy = (yMax-y);
  }

  float xf, yf, xf2, yf2;
  UC2GrC(x, y, xf, yf);
  UC2GrC(x+dx, y+dy, xf2, yf2);
  if (xf2 < xf)  fl_swap(xf, xf2);
  if (yf2 < yf)  fl_swap(yf, yf2);
  mGrC->Erase(xf, yf, xf2-xf, yf2-yf);
}

/* --Methode-- */
void PIGraphicUC::DrawString(PIGrCoord x, PIGrCoord y, char* s, int pos)
{
  if (!mGrC) return;
  float xf, yf;
  UC2GrC(x, y, xf, yf);
  mGrC->DrawString(xf, yf, s, pos);  
}

/* --Methode-- */
void PIGraphicUC::DrawOpaqueString(PIGrCoord x, PIGrCoord y, char* s, int pos)
{
  if (!mGrC) return;
  float xf, yf;
  UC2GrC(x, y, xf, yf);
  mGrC->DrawOpaqueString(xf, yf, s, pos);  
}

/* --Methode-- */
void PIGraphicUC::DrawLine(PIGrCoord xc1, PIGrCoord yc1, PIGrCoord xc2, PIGrCoord yc2)
{
  
  if (!mGrC) return;
  float x1, y1, x2, y2;
  x1 = xc1;  y1 = yc1;
  x2 = xc2;  y2 = yc2;
  if (clip) {
    if (x2 < xMin && x1 < xMin) return;
    if (x2 > xMax && x1 > xMax) return;
    if (y1 < yMin && y2 < yMin) return;
    if (y1 > yMax && y2 > yMax) return;
    if (x2 < x1) {
      fl_swap(x1,x2);
      fl_swap(y1,y2);
    }
    if (x2>xMax) {
      y2 = y1 + (y2-y1)/(x2-x1)*(xMax-x1);
      x2 = xMax;
    }
    if (x1<xMin) {
      y1 = y2 + (y1-y2)/(x1-x2)*(xMin-x2);
      x1 = xMin;
    }
    if (y2 < y1) {
      fl_swap(x1,x2);
      fl_swap(y1,y2);
    }
    if (y2>yMax) {
      x2 = x1 + (x2-x1)/(y2-y1)*(yMax-y1);
      y2 = yMax;
    }
    if (y1<yMin) {
      x1 = x2 + (x1-x2)/(y1-y2)*(yMin-y2);
      y1 = yMin;
    }
  }

  float xf1, yf1, xf2, yf2;
  UC2GrC(x1, y1, xf1, yf1);
  UC2GrC(x2, y2, xf2, yf2);
  mGrC->DrawLine(xf1, yf1, xf2, yf2);

}  


/* --Methode-- */
void PIGraphicUC::DrawBox(PIGrCoord xc, PIGrCoord yc, PIGrCoord dxc, PIGrCoord dyc)
{
  if (!mGrC) return;
  float x, y, dx, dy;
  x = xc;  dx = dxc;
  y = yc;  dy = dyc;
  if (clip) {
    if (dx < 0) {
      x = x+dx;
      dx = -dx;
    }
    if (dy < 0) {
      y = y+dy;
      dy = -dy;
    }
    if (x > xMax || x+dx < xMin || y > yMax || y+dy < yMin) return;
    if (x < xMin) {
      dx -= (xMin-x);
      x = xMin;
    }
    if (y < yMin) {
      dy -= (yMin-y);
      y = yMin;
    }
    if (x+dx > xMax)
      dx = (xMax-x);
    if (y+dy > yMax)
      dy = (yMax-y);
  }

  float xf, yf, xf2, yf2;
  UC2GrC(x, y, xf, yf);
  UC2GrC(x+dx, y+dy, xf2, yf2);
  if (xf2 < xf)  fl_swap(xf, xf2);
  if (yf2 < yf)  fl_swap(yf, yf2);
  mGrC->DrawBox(xf, yf, xf2-xf, yf2-yf);
}  

/* --Methode-- */
void PIGraphicUC::DrawFBox(PIGrCoord xc, PIGrCoord yc, PIGrCoord dxc, PIGrCoord dyc)
{
  if (!mGrC) return;
  float x, y, dx, dy;
  x = xc;  dx = dxc;
  y = yc;  dy = dyc;
  if (clip) {
    if (dx < 0) {
      x = x+dx;
      dx = -dx;
    }
    if (dy < 0) {
      y = y+dy;
      dy = -dy;
    }
    if (x > xMax || x+dx < xMin || y > yMax || y+dy < yMin) return;
    if (x < xMin) {
      dx -= (xMin-x);
      x = xMin;
    }
    if (y < yMin) {
      dy -= (yMin-y);
      y = yMin;
    }
    if (x+dx > xMax)
      dx = (xMax-x);
    if (y+dy > yMax)
      dy = (yMax-y);
  }

  float xf, yf, xf2, yf2;
  UC2GrC(x, y, xf, yf);
  UC2GrC(x+dx, y+dy, xf2, yf2);
  if (xf2 < xf)  fl_swap(xf, xf2);
  if (yf2 < yf)  fl_swap(yf, yf2);
  mGrC->DrawFBox(xf, yf, xf2-xf, yf2-yf);
}  

/* --Methode-- */
void PIGraphicUC::DrawCircle(PIGrCoord x, PIGrCoord y, PIGrCoord r)
{
  if (!mGrC) return;

  float xf, yf, rf,rfy;
  UC2GrC(x, y, xf, yf);
  DUC2GrC(r,r,rf,rfy);
  rf = 0.5*(rf+rfy);
  mGrC->DrawCircle(xf, yf, rf);
}  

/* --Methode-- */
void PIGraphicUC::DrawFCircle(PIGrCoord x, PIGrCoord y, PIGrCoord r)
{
  if (!mGrC) return;

  float xf, yf, rf, rfy;
  UC2GrC(x, y, xf, yf);
  DUC2GrC(r,r,rf,rfy);
  rf = 0.5*(rf+rfy);
  mGrC->DrawFCircle(xf, yf, rf);
}

#define NMXMULTP  30   // Pour multipoint sans new

/* --Methode-- */
void PIGraphicUC::DrawPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc)
{
  PIGrCoord xc[NMXMULTP], yc[NMXMULTP];
  PIGrCoord *pxc, *pyc;
  int i;
  float xf, yf;
 
  if (!mGrC) return;
  if (n <= 0)  return;

  if (n > NMXMULTP) { pxc = new PIGrCoord[n];  pyc = new PIGrCoord[n]; }
  else { pxc = xc;  pyc = yc; }
  for(i=0; i<n; i++) {
    UC2GrC(x[i], y[i], xf, yf);
    pxc[i] = xf;  pyc[i] = yf; 
  }
  mGrC->DrawPolygon(pxc, pyc, n, cinc);
  if (n > NMXMULTP) { delete[] pxc;  delete[] pyc; }
  return;
}
  
/* --Methode-- */
void PIGraphicUC::DrawFPolygon(PIGrCoord *x, PIGrCoord *y, int n, bool cinc)
{
  PIGrCoord xc[NMXMULTP], yc[NMXMULTP];
  PIGrCoord *pxc, *pyc;
  int i;
  float xf, yf;
 
  if (!mGrC) return;
  if (n <= 0)  return;

  if (n > NMXMULTP) { pxc = new PIGrCoord[n];  pyc = new PIGrCoord[n]; }
  else { pxc = xc;  pyc = yc; }
  for(i=0; i<n; i++) {
    UC2GrC(x[i], y[i], xf, yf);
    pxc[i] = xf;  pyc[i] = yf; 
  }
  mGrC->DrawFPolygon(pxc, pyc, n, cinc);
  if (n > NMXMULTP) { delete[] pxc;  delete[] pyc; }
  return;
}


/* --Methode-- */
void PIGraphicUC::DrawMarker(PIGrCoord x0, PIGrCoord y0)
{
  if (!mGrC) return;
  float xf, yf;
  UC2GrC(x0, y0, xf, yf);
  mGrC->DrawMarker(xf, yf);
  return;
}

/* --Methode-- */
void PIGraphicUC::DrawMarkers(PIGrCoord *x, PIGrCoord *y, int n)
{
  PIGrCoord xc[NMXMULTP], yc[NMXMULTP];
  PIGrCoord *pxc, *pyc;
  int i;
  float xf, yf;
 
  if (!mGrC) return;
  if (n <= 0)  return;

  if (n > NMXMULTP) { pxc = new PIGrCoord[n];  pyc = new PIGrCoord[n]; }
  else { pxc = xc;  pyc = yc; }
  for(i=0; i<n; i++) {
    UC2GrC(x[i], y[i], xf, yf);
    pxc[i] = xf;  pyc[i] = yf; 
  }
  mGrC->DrawMarkers(pxc, pyc, n);
  if (n > NMXMULTP) { delete[] pxc;  delete[] pyc; }
  return;
}

/* --Methode-- */
void PIGraphicUC::DrawPixmap(PIGrCoord x, PIGrCoord y, unsigned char *pix,
                        int sx, int sy, PIColorMap* cmap)
{
  if (!mGrC) return;
  if ( (sx < 1) || (sy < 1) )  return;
  if ((pix == NULL) || (cmap == NULL)) return; 
  float xf,yf;
  UC2GrC(x, y, xf, yf);
  mGrC->DrawPixmap(xf, yf, pix, sx, sy, cmap);
}



/* --Methode-- */
void PIGraphicUC::SelForeground(PIColors col)
{
  if (!mGrC) return;
  mGrC->SelForeground(col);
  return;  
}


/* --Methode-- */
void PIGraphicUC::SelBackground(PIColors col)
{
  if (!mGrC) return;
  mGrC->SelBackground(col);
  return;  
}

/* --Methode-- */
void PIGraphicUC::SelForeground(PIColorMap& cmap, int cid)
{
  if (!mGrC) return;
  mGrC->SelForeground(cmap, cid);
  return;  
}


/* --Methode-- */
void PIGraphicUC::SelBackground(PIColorMap& cmap, int cid)
{
  if (!mGrC) return;
  mGrC->SelBackground(cmap, cid);
  return;  
}

/* --Methode-- */
void PIGraphicUC::SelGOMode(PIGOMode mod)
{
  if (!mGrC) return;
  mGrC->SelGOMode(mod);
  return;  
}

/* --Methode-- */
void PIGraphicUC::SelFont(PIFontSize sz, PIFontAtt att)
{
  if (!mGrC) return;
  mGrC->SelFont(sz, att);
  return;  
}

/* --Methode-- */
void PIGraphicUC::SelFontSzPt(int npt, PIFontAtt att)
{
  if (!mGrC) return;
  mGrC->SelFontSzPt(npt, att);
  return;  
}


/* --Methode-- */
void PIGraphicUC::SelLine(PILineAtt att)
{
  if (!mGrC) return;
  mGrC->SelLine(att);
  return;  
}

/* --Methode-- */
void PIGraphicUC::SelMarker(int msz, PIMarker mrk)
{
  if (!mGrC) return;
  mGrC->SelMarker( msz, mrk);
}

/* --Methode-- */
void PIGraphicUC::SelFontSz(PIGrCoord sz, PIFontAtt att)
{
  if (!mGrC) return;
  float fx, fy;
  DUC2GrC((float)sz, (float)sz, fx, fy);
  int npt = (int)fy;
  if (npt < 8) npt = 8;
  if (npt > 127) npt = 127;
  mGrC->SelFontSzPt(npt, att);
}


/* --Methode-- */
void PIGraphicUC::SelMarkerSz(PIGrCoord sz, PIMarker mrk)
{
  if (!mGrC) return;
  float fx, fy;
  DUC2GrC((float)sz, (float)sz, fx, fy);
  int isz = int(0.5*(fx+fy+1));
  mGrC->SelMarker( isz, mrk);
}

/* --Methode-- */
void PIGraphicUC::SetClipRectangle(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
{
  /* $CHECK$  A faire Reza 08/02/97  */
return;
}
/* --Methode-- */
void PIGraphicUC::ClearClipRectangle()
{
  /* $CHECK$  A faire Reza 08/02/97  */
return;
}

/* --Methode-- */
PIColors PIGraphicUC::GetForeground()
{
  if (!mGrC) return(PI_NotDefColor);
  return(mGrC->GetForeground());
}

/* --Methode-- */
PIColors PIGraphicUC::GetBackground()
{
  if (!mGrC) return(PI_NotDefColor);
  return(mGrC->GetBackground());
}

/* --Methode-- */
PIGOMode PIGraphicUC::GetGOMode()
{
  if (!mGrC) return(PI_GOCopy);
  return(mGrC->GetGOMode());
}

/* --Methode-- */
PIFontAtt PIGraphicUC::GetFontAtt()
{
  if (!mGrC) return(PI_NotDefFontAtt);
  return(mGrC->GetFontAtt());
}

/* --Methode-- */
int PIGraphicUC::GetFontSize()
{
  if (!mGrC) return(0);
  return(mGrC->GetFontSize());
}

/* --Methode-- */
PILineAtt PIGraphicUC::GetLineAtt()
{
  if (!mGrC) return(PI_NotDefLineAtt);
  return(mGrC->GetLineAtt());
}

/* --Methode-- */
PIMarker PIGraphicUC::GetMarker()
{
  if (!mGrC) return(PI_NotDefMarker);
  return(mGrC->GetMarker());
}

/* --Methode-- */
int PIGraphicUC::GetMarkerSize()
{
  if (!mGrC) return(0);
  return(mGrC->GetMarkerSize());
}

/* --Methode-- */
int PIGraphicUC::GetFontHeight(int& asc, int& desc)
{
  asc = desc = 0;
  if (!mGrC) return(0);
  return( mGrC->GetFontHeight(asc, desc) );
}

/* --Methode-- */
PIGrCoord PIGraphicUC::CalcStringWidth(char const* s)
{
  if (!mGrC) return(0.);
  float dx = mGrC->CalcStringWidth(s);
  float dxx, dxy;
  DGrC2UC(dx, dx, dxx, dxy);
  return(dxx);
}


/* --Methode-- */
void PIGraphicUC::SaveGraphicAtt()
{
  if (!mGrC) return;
  mGrC->SaveGraphicAtt();
}

/* --Methode-- */
void PIGraphicUC::RestoreGraphicAtt()
{
  if (!mGrC) return;
  mGrC->RestoreGraphicAtt();
}

