#ifndef  FFTWServer_H_SEEN
#define  FFTWServer_H_SEEN

#include "machdefs.h"
#include "fftservintf.h"


// Classe definissant l'interface pour les transformees de Fourier 
// L'implementation par defaut est vide et lance une exception 

class FFTWServerPlan;

class FFTWServer : public FFTServerInterface {
 public:
  FFTWServer();
  virtual ~FFTWServer();

  
  virtual FFTServerInterface * Clone();

  // Transforme unidimensionnelle , N-dimensionnel
  virtual void FFTForward(TArray< complex<r_8> > const & in, TArray< complex<r_8> > & out);
  virtual void FFTBackward(TArray< complex<r_8> > const & in, TArray< complex<r_8> > & out);
  virtual void FFTForward(TArray< r_8 > const & in, TArray< complex<r_8> > & out);
  virtual void FFTBackward(TArray< complex<r_8> > const & in, TArray< r_8 > & out);

// Methodes statiques pour reordonner les donnees 
  virtual void ReShapetoReal( TArray< complex<r_8> > const & in, TArray< r_8 >  & out);
  virtual void ReShapetoCompl(TArray< r_8 > const & in, TArray< complex<r_8> > & out);

 protected:
 FFTWServerPlan * _p1df;
 FFTWServerPlan * _p1db;
 FFTWServerPlan * _pndf;
 FFTWServerPlan * _pndb;

 FFTWServerPlan * _p1drf;
 FFTWServerPlan * _p1drb;
 FFTWServerPlan * _pndrf;
 FFTWServerPlan * _pndrb;

 FFTArrayChecker<r_4> ckR4;
 FFTArrayChecker<r_8> ckR8;
};

#endif
