//   FFT (Fast Fourier Transform) Server Interface
//        R. Ansari     1999-2000
// DAPNIA/SPP (Saclay) / CEA    LAL - IN2P3/CNRS  (Orsay)

#ifndef  FFTServerIntf_H_SEEN
#define  FFTServerIntf_H_SEEN

#include "machdefs.h"
#include "pexceptions.h"
#include <complex>
#include "tmatrix.h"
#include "tvector.h"

// Classe definissant l'interface pour les transformees de Fourier 
// L'implementation par defaut est vide et lance une exception 

namespace SOPHYA {

class FFTServerInterface {
 public:

// Methodes de la classe 
  FFTServerInterface(string info);
  virtual ~FFTServerInterface();

  
  virtual FFTServerInterface * Clone() = 0;

  inline void setNormalize(bool fg=false) { _fgnorm = fg; }
  inline bool getNormalize() const { return(_fgnorm); } 
  inline string getInfo() const { return _info; }

  //---------------------------------------------------
  // Transforme N-dim sur des doubles
  virtual void FFTForward(TArray< complex<r_8> > const & in, TArray< complex<r_8> > & out);
  virtual void FFTBackward(TArray< complex<r_8> > const & in, TArray< complex<r_8> > & out);
  virtual void FFTForward(TArray< r_8 > const & in, TArray< complex<r_8> > & out);
  virtual void FFTBackward(TArray< complex<r_8> > const & in, TArray< r_8 > & out);

  // Transforme N-dim sur des float
  virtual void FFTForward(TArray< complex<r_4> > const & in, TArray< complex<r_4> > & out);
  virtual void FFTBackward(TArray< complex<r_4> > const & in, TArray< complex<r_4> > & out);
  virtual void FFTForward(TArray< r_4 > const & in, TArray< complex<r_4> > & out);
  virtual void FFTBackward(TArray< complex<r_4> > const & in, TArray< r_4 > & out);

 protected:
  bool _fgnorm;
  string _info;
};

} // Fin du namespace

template <class T> 
class FFTArrayChecker {
public:
		FFTArrayChecker(string msg, bool checkpack=true, bool onedonly=false);
  virtual	~FFTArrayChecker();
  static T	ZeroThreshold();
  virtual int	CheckResize(TArray< complex<T> > const & in, TArray< complex<T> > & out);
  virtual int	CheckResize(TArray< T > const & in, TArray< complex<T> > & out);
  virtual int	CheckResize(TArray< complex<T> > const & in, TArray< T > & out);
  //  virtual void  ReShapetoReal(TArray< complex<T> > const & in, TArray< T >  & out);
  //  virtual void  ReShapetoCompl(TArray< T > const & in, TArray< complex<T> > & out); 

protected:
  string _msg;
  bool _checkpack;
  bool _onedonly;
};

#endif
