#  SKYMIX  NbComponents  NSide_HealPix
@SKYMIX  1 16

#  READMAP  FitsName
#  To Read the already prepared (mixed) Output MAP from FITS file
#  FitsName should be the complete path to the FITS file
READMAP xxx.fits

#  Defining the Detection filter pass - band
#  GAUSSFILTER or FILTERFITSFILE  card
#  GAUSSFILTER -> Gaussian filter
#  FILTERFITSFILE -> Filter (nu, T(nu)) from FITS file
#  GAUSSFILTER  Nu0 Sigma_Nu Tmax NuMin NuMax
#  FILTERFITSFILE FileName NuMin NuMax
#       FileName should be a complete path
@GAUSSFILTER 143 12 0.84 50. 300.

#  MAPPATH  PathForFITS   
#  path for input Sky Component FITS files , and EmissionSpectra files 
MAPPATH /data/opus/Rz/SOPHYA/

#  ----        Sky components  ---------
#      ----     HealPix maps   ----
#  MAPFITSFILEi FITSfilename Normalisation
@MAPFITSFILE4  gauss.fits  1.0 

#      ---   Emission Spectra definition -----
#   SPECTRAFITSFILEi  FITSfilename  Fmin Fmax 
@SPECTRAFITSFILE4  pl.fits 100 600  

#   Other possible definition of emission spectra
#   BLACKBODYi  temperature
#  The blackbody object returns flux in units of watt/m2/sr/hz
#   We thus scale the map (x 1.e17) 
@MAPFITSFILE1  cossin.fits  1.e17 

#   For power-law spectra  f = a ((nu-nu0)/dnu)^b)
#   POWERLAWSPECTRAi  a nu0 dnu b Fmin Fmax
@MAPFITSFILE2  noise.fits    0.1 
@POWERLAWSPECTRA2 1. 150. 50. -0.5 100. 500.

#  For an emission spectrum which depends on the position 
#  in the map -> synchrotron for instance nu^(-beta(theta,phi))
#  MAPFITSFILE will still correspond to the brightness temperature
@MAPFITSFILE3 /exp/planck/Sync/Template408MHz.fits 0.2
#@MAPFITSFILE1 gauss.fits 0.2
# and the BETAFITSFILE will correspond to a map with the spectral
# index beta(theta,phi) 
# 408 is the normalisation frequency of the map
# 32 is the nside of the map on which the integration over the
#	spectralResponse of the detector will be performed
#	for the full resolution, write the nside of the map
#	or a negative value.
@BETAFITSFILE3 /exp/planck/Sync/SpectralIndex.fits  408e-3 16
#@BETAFITSFILE1 gauss.fits  408e-3 32

#  For adding a dipole component
# @DIPOLEx Theta Phi Amplitude [Temperature=Tcmb=2.726]
# CMB dipole parameters , theta, phi 3.358mK
# @DIPOLE4 0.73 -1.67 3.358e-3
@DIPOLE4 2.726

#  Define the Debug level
@DEBUGLEVEL  0
#  Define the Print level
@PRINTLEVEL  5
