// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive  PIStackWindow  PIZoneWindow
//                             R. Ansari  08/98

#ifndef PISTZWIN_H_SEEN
#define PISTZWIN_H_SEEN

#include "pisysdep.h"
#include PIWIN_H
#include PIPERIODIC_H

// ----------------------- Classe PIStackWindow ----------------------------
// Fenetre de type empilement , tout widget occupe la totalite de la fenetre,
// Un seul des widget visible (active) a chaque moment

class PIStackWindow : public PIWindow {
public:
		PIStackWindow(PIMsgHandler* par, char* nom, PIWindowKind k=PIWK_normal,
                              int sx=100, int sy=100, int px=0, int py=0);
		~PIStackWindow();

  virtual void  ChildAdd(PIWdg* child);
  virtual void  ChildDel(PIWdg* child);

  virtual void  PSPrint(PSFile *psf, int ofx=0, int ofy=0);

  virtual PIWdg*  CurrentWdg();
  virtual void  DispNext();
  virtual void  StartAutoDisp(int dt);
  virtual void  StopAutoDisp();

protected:
  PIPeriodic mPerad;
  int mCurdisp;
};

// ----------------------- Classe PIZoneWindow ----------------------------
// Fenetre avec nzx*nzy zone d affichage - Les nouveaux widgets dans chaque
// zone viennent remplacer les anciennes - Ceux-ci sont detruits automatiquement
 
class PIZoneWindow : public PIWindow {
public:
		PIZoneWindow(PIMsgHandler* par, char* nom, PIWindowKind k=PIWK_normal,
                             int nzx=1, int nzy=1, int sx=100, int sy=100, int px=0, int py=0);
		~PIZoneWindow();

  virtual void  ChildAdd(PIWdg* child);
  virtual void  ChildDel(PIWdg* child);
  virtual void  SetZone(int nzx, int nzy);
  virtual void  NbZone(int& nzx, int& nzy);
  virtual PIWdg*  NextChildPosSize(int& px, int& py, int& sx, int& sy);

protected:
  int mZx, mZy, mZc;
  PIWdg** mZWdg;
};
#endif
