#include "toimanager.h"
#include <limits.h>
#include <pthread.h>
#include <iostream.h>

TOIManager::TOIManager() {
  reqBegin = 0;
  reqEnd = LONG_MAX;
}

TOIManager* TOIManager::instance = NULL;

TOIManager* TOIManager::getManager() {
  if (instance == NULL) instance =  new TOIManager();
  return instance;
}

void TOIManager::setRequestedSample(long begin, long end) {
  reqBegin = begin;
  reqEnd   = end;
}

long TOIManager::getRequestedBegin() {
  return reqBegin;
}

long TOIManager::getRequestedEnd() {
  return reqEnd;
}

void TOIManager::addThread(pthread_t* t) {
  //  cout << "adding thread  "  <<  t << endl;
  threads.push_back(t); 
}

void TOIManager::joinAll() {
  for (vector<pthread_t*>::iterator i = threads.begin();
       i != threads.end(); i++) {
    pthread_t* pth = *i;
    cout << "joining thread  " << pth <<  endl;
    pthread_join(*pth, NULL);
    cout << "thread joined " << pth << endl;
  }
}
